/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.binary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class ArithmeticBinaryExpression
extends BinaryExpression {
    protected ArithmeticBinaryExpression(Expression leftExpression, Expression rightExpression) {
        super(leftExpression, rightExpression);
    }

    protected ArithmeticBinaryExpression(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    public final TSDataType inferTypes(TypeProvider typeProvider) {
        String expressionString = this.toString();
        if (!typeProvider.containsTypeInfoOf(expressionString)) {
            ArithmeticBinaryExpression.checkInputExpressionDataType(this.leftExpression.toString(), this.leftExpression.inferTypes(typeProvider), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            ArithmeticBinaryExpression.checkInputExpressionDataType(this.rightExpression.toString(), this.rightExpression.inferTypes(typeProvider), TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            typeProvider.setType(expressionString, TSDataType.DOUBLE);
        }
        return TSDataType.DOUBLE;
    }
}

