/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.binary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class CompareBinaryExpression
extends BinaryExpression {
    protected CompareBinaryExpression(Expression leftExpression, Expression rightExpression) {
        super(leftExpression, rightExpression);
    }

    protected CompareBinaryExpression(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) {
        String expressionString = this.toString();
        if (!typeProvider.containsTypeInfoOf(expressionString)) {
            TSDataType rightExpressionDataType;
            TSDataType leftExpressionDataType = this.leftExpression.inferTypes(typeProvider);
            if (!leftExpressionDataType.equals((Object)(rightExpressionDataType = this.rightExpression.inferTypes(typeProvider)))) {
                String leftExpressionString = this.leftExpression.toString();
                String rightExpressionString = this.rightExpression.toString();
                if (TSDataType.BOOLEAN.equals((Object)leftExpressionDataType) || TSDataType.BOOLEAN.equals((Object)rightExpressionDataType)) {
                    CompareBinaryExpression.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.BOOLEAN);
                    CompareBinaryExpression.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.BOOLEAN);
                } else if (TSDataType.TEXT.equals((Object)leftExpressionDataType) || TSDataType.TEXT.equals((Object)rightExpressionDataType)) {
                    CompareBinaryExpression.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.TEXT);
                    CompareBinaryExpression.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.TEXT);
                } else {
                    CompareBinaryExpression.checkInputExpressionDataType(leftExpressionString, leftExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                    CompareBinaryExpression.checkInputExpressionDataType(rightExpressionString, rightExpressionDataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
                }
            }
            typeProvider.setType(expressionString, TSDataType.BOOLEAN);
        }
        return TSDataType.BOOLEAN;
    }

    @Override
    public boolean isCompareBinaryExpression() {
        return true;
    }
}

