/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.rewriter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.common.filter.BasicFunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.rewriter.IFilterOptimizer;

public class MergeSingleFilterOptimizer
implements IFilterOptimizer {
    @Override
    public QueryFilter optimize(QueryFilter filter) throws StatementAnalyzeException {
        this.mergeSamePathFilter(filter);
        return filter;
    }

    private void checkInnerFilterLen(List<QueryFilter> children) throws StatementAnalyzeException {
        if (children.isEmpty()) {
            throw new StatementAnalyzeException("this inner filter has no children!");
        }
        if (children.size() == 1) {
            throw new StatementAnalyzeException("this inner filter has just one child!");
        }
    }

    private PartialPath mergeSamePathFilter(QueryFilter filter) throws StatementAnalyzeException {
        if (filter.isLeaf()) {
            return filter.getSinglePath();
        }
        List<QueryFilter> children = filter.getChildren();
        this.checkInnerFilterLen(children);
        PartialPath childPath = this.mergeSamePathFilter(children.get(0));
        for (int i = 1; i < children.size(); ++i) {
            PartialPath tempPath = this.mergeSamePathFilter(children.get(i));
            if (tempPath != null && tempPath.equals((Object)childPath)) continue;
            childPath = null;
        }
        if (childPath != null) {
            filter.setIsSingle(true);
            filter.setSinglePath(childPath);
            return childPath;
        }
        if (!children.isEmpty() && this.allIsBasic(children)) {
            children.sort(Comparator.comparing(o -> o.getSinglePath().getFullPath()));
        }
        ArrayList<QueryFilter> ret = new ArrayList<QueryFilter>();
        int firstNonSingleIndex = this.mergeSingleFilters(ret, filter);
        return this.addLastNullChild(ret, filter, firstNonSingleIndex, childPath);
    }

    private int mergeSingleFilters(List<QueryFilter> ret, QueryFilter filter) {
        PartialPath tempPath;
        int firstNonSingleIndex;
        List<QueryFilter> children = filter.getChildren();
        ArrayList<QueryFilter> tempExtrNode = null;
        PartialPath childPath = null;
        for (firstNonSingleIndex = 0; firstNonSingleIndex < children.size() && (tempPath = children.get(firstNonSingleIndex).getSinglePath()) != null; ++firstNonSingleIndex) {
            if (childPath == null) {
                childPath = tempPath;
                tempExtrNode = new ArrayList<QueryFilter>();
                tempExtrNode.add(children.get(firstNonSingleIndex));
                continue;
            }
            if (childPath.equals((Object)tempPath)) {
                QueryFilter child = children.get(firstNonSingleIndex);
                if (tempExtrNode.contains(child)) continue;
                tempExtrNode.add(child);
                continue;
            }
            if (tempExtrNode.size() == 1) {
                ret.add((QueryFilter)tempExtrNode.get(0));
                tempExtrNode.set(0, children.get(firstNonSingleIndex));
                childPath = tempPath;
                continue;
            }
            QueryFilter newFilter = new QueryFilter(filter.getFilterType(), true);
            newFilter.setSinglePath(childPath);
            newFilter.setChildren(tempExtrNode);
            ret.add(newFilter);
            tempExtrNode = new ArrayList();
            tempExtrNode.add(children.get(firstNonSingleIndex));
            childPath = tempPath;
        }
        if (childPath != null) {
            if (tempExtrNode.size() == 1) {
                ret.add((QueryFilter)tempExtrNode.get(0));
            } else {
                QueryFilter newFil = new QueryFilter(filter.getFilterType(), true);
                newFil.setSinglePath(childPath);
                newFil.setChildren(tempExtrNode);
                ret.add(newFil);
            }
        }
        return firstNonSingleIndex;
    }

    private PartialPath addLastNullChild(List<QueryFilter> ret, QueryFilter filter, int i, PartialPath childPath) {
        List<QueryFilter> children = filter.getChildren();
        while (i < children.size()) {
            ret.add(children.get(i));
            ++i;
        }
        if (ret.size() == 1) {
            filter.setIsSingle(true);
            filter.setSinglePath(childPath);
            filter.setChildren(ret.get(0).getChildren());
            return childPath;
        }
        filter.setIsSingle(false);
        filter.setChildren(ret);
        return null;
    }

    private boolean allIsBasic(List<QueryFilter> children) {
        for (QueryFilter child : children) {
            if (child instanceof BasicFunctionFilter) continue;
            return false;
        }
        return true;
    }
}

