/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class FilterOperator
implements Comparable<FilterOperator> {
    protected FilterConstant.FilterType filterType;
    private List<FilterOperator> childOperators = new ArrayList<FilterOperator>();
    protected boolean isLeaf = false;
    boolean isSingle = false;
    PartialPath singlePath = null;
    Set<PartialPath> pathSet;

    public FilterOperator() {
    }

    public FilterOperator(FilterConstant.FilterType filterType) {
        this.filterType = filterType;
    }

    public FilterOperator(FilterConstant.FilterType filterType, boolean isSingle) {
        this.filterType = filterType;
        this.isSingle = isSingle;
    }

    public FilterConstant.FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterConstant.FilterType filterType) {
        this.filterType = filterType;
    }

    public String getFilterName() {
        return FilterConstant.filterNames.get((Object)this.filterType);
    }

    public String getFilterSymbol() {
        return FilterConstant.filterSymbol.get((Object)this.filterType);
    }

    public List<FilterOperator> getChildren() {
        return this.childOperators;
    }

    public void setChildren(List<FilterOperator> children) {
        this.childOperators = children;
    }

    public void setIsSingle(boolean b) {
        this.isSingle = b;
    }

    public PartialPath getSinglePath() {
        return this.singlePath;
    }

    public void setSinglePath(PartialPath singlePath) {
        this.singlePath = singlePath;
    }

    public void addChildOperator(FilterOperator op) {
        this.childOperators.add(op);
    }

    public void setPathSet(Set<PartialPath> pathSet) {
        this.pathSet = pathSet;
    }

    public Set<PartialPath> getPathSet() {
        return this.pathSet;
    }

    public IExpression transformToExpression(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws QueryProcessException {
        if (this.isSingle) {
            Pair<IUnaryExpression, String> ret;
            try {
                ret = this.transformToSingleQueryFilter(pathTSDataTypeHashMap);
            }
            catch (MetadataException e) {
                throw new QueryProcessException((IoTDBException)((Object)e));
            }
            return (IExpression)ret.left;
        }
        if (this.childOperators.isEmpty()) {
            throw new LogicalOperatorException(String.valueOf((Object)this.filterType), "this filter is not leaf, but it's empty");
        }
        IExpression retFilter = this.childOperators.get(0).transformToExpression(pathTSDataTypeHashMap);
        block6: for (int i = 1; i < this.childOperators.size(); ++i) {
            IExpression currentFilter = this.childOperators.get(i).transformToExpression(pathTSDataTypeHashMap);
            switch (this.filterType) {
                case KW_AND: {
                    retFilter = BinaryExpression.and((IExpression)retFilter, (IExpression)currentFilter);
                    continue block6;
                }
                case KW_OR: {
                    retFilter = BinaryExpression.or((IExpression)retFilter, (IExpression)currentFilter);
                    continue block6;
                }
                default: {
                    throw new LogicalOperatorException(String.valueOf((Object)this.filterType), "Maybe it means " + this.getFilterName());
                }
            }
        }
        return retFilter;
    }

    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws LogicalOperatorException, MetadataException {
        if (this.childOperators.isEmpty()) {
            throw new LogicalOperatorException(String.valueOf((Object)this.filterType), "TransformToSingleFilter: this filter is not a leaf, but it's empty.");
        }
        Pair<IUnaryExpression, String> currentPair = this.childOperators.get(0).transformToSingleQueryFilter(pathTSDataTypeHashMap);
        IUnaryExpression retFilter = (IUnaryExpression)currentPair.left;
        String path = (String)currentPair.right;
        block4: for (int i = 1; i < this.childOperators.size(); ++i) {
            currentPair = this.childOperators.get(i).transformToSingleQueryFilter(pathTSDataTypeHashMap);
            if (!path.equals(currentPair.right)) {
                throw new LogicalOperatorException("TransformToSingleFilter: paths among children are not inconsistent: one is: " + path + ", another is: " + (String)currentPair.right);
            }
            switch (this.filterType) {
                case KW_AND: {
                    retFilter.setFilter((Filter)FilterFactory.and((Filter)retFilter.getFilter(), (Filter)((IUnaryExpression)currentPair.left).getFilter()));
                    continue block4;
                }
                case KW_OR: {
                    retFilter.setFilter((Filter)FilterFactory.or((Filter)retFilter.getFilter(), (Filter)((IUnaryExpression)currentPair.left).getFilter()));
                    continue block4;
                }
                default: {
                    throw new LogicalOperatorException(String.valueOf((Object)this.filterType), "Maybe it means " + this.getFilterName());
                }
            }
        }
        return new Pair((Object)retFilter, (Object)path);
    }

    @Override
    public int compareTo(FilterOperator fil) {
        if (this.singlePath == null && fil.singlePath == null) {
            return 0;
        }
        if (this.singlePath == null) {
            return 1;
        }
        if (fil.singlePath == null) {
            return -1;
        }
        return fil.singlePath.getFullPath().compareTo(this.singlePath.getFullPath());
    }

    public boolean equals(Object fil) {
        if (!(fil instanceof FilterOperator)) {
            return false;
        }
        FilterOperator operator = (FilterOperator)fil;
        return this.filterType == operator.filterType && this.getChildren().equals(operator.getChildren());
    }

    public int hashCode() {
        return this.getFilterSymbol().hashCode();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public String showTree() {
        return this.showTree(0);
    }

    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.getFilterName()});
        if (this.isSingle) {
            sc.addTail(new String[]{"[single:", this.getSinglePath().getFullPath(), "]"});
        }
        sc.addTail(new String[]{"\n"});
        for (FilterOperator filter : this.childOperators) {
            sc.addTail(new String[]{filter.showTree(spaceNum + 1)});
        }
        return sc.toString();
    }

    public String toString() {
        StringContainer sc = new StringContainer();
        sc.addTail(new String[]{"[", FilterConstant.filterNames.get((Object)this.filterType)});
        if (this.isSingle) {
            sc.addTail(new String[]{"[single:", this.getSinglePath().getFullPath(), "]"});
        }
        sc.addTail(new String[]{" "});
        for (FilterOperator filter : this.childOperators) {
            sc.addTail(new String[]{filter.toString()});
        }
        sc.addTail(new String[]{"]"});
        return sc.toString();
    }

    public FilterOperator copy() {
        FilterOperator ret = new FilterOperator(this.filterType);
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        if (this.singlePath != null) {
            ret.singlePath = this.singlePath.clone();
        }
        for (FilterOperator filterOperator : this.childOperators) {
            ret.addChildOperator(filterOperator.copy());
        }
        return ret;
    }
}

