/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.sql;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.AggregationQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FillClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.FillQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByFillClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByFillQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.GroupByQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.LastQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.LikeOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.RegexpOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.logical.crud.SelectIntoOperator;
import org.apache.iotdb.db.qp.logical.crud.SpecialClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.UDAFQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.UDTFQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.logical.sys.ActivateTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.ClearCacheOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateAlignedTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateContinuousQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.CreatePipeOperator;
import org.apache.iotdb.db.qp.logical.sys.CreatePipeSinkOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeletePartitionOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DropContinuousQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.DropFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.DropPipeOperator;
import org.apache.iotdb.db.qp.logical.sys.DropPipeSinkOperator;
import org.apache.iotdb.db.qp.logical.sys.DropTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.DropTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.KillQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MergeOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetSystemModeOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.SettleOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildNodesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowContinuousQueriesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowFunctionsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowLockInfoOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowNodesInTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPathsSetTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPathsUsingTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPipeOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPipeSinkOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPipeSinkTypeOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowQueryResourceOperate;
import org.apache.iotdb.db.qp.logical.sys.ShowStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTemplatesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTriggersOperator;
import org.apache.iotdb.db.qp.logical.sys.StartPipeOperator;
import org.apache.iotdb.db.qp.logical.sys.StartTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.StopPipeOperator;
import org.apache.iotdb.db.qp.logical.sys.StopTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.UnSetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.UnloadFileOperator;
import org.apache.iotdb.db.qp.logical.sys.UnsetTemplateOperator;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParserBaseVisitor;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.executor.fill.ValueFill;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class IoTDBSqlVisitor
extends IoTDBSqlParserBaseVisitor<Operator> {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String DELETE_RANGE_ERROR_MSG = "For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'";
    private static final String DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG = "For delete statement, where clause can only contain time expressions, value filter is not currently supported.";
    private static final Pattern leveledPathNodePattern = Pattern.compile("\\$\\{\\w+}");
    private static final Pattern NODE_NAME_IN_SELECT_INTO_PATTERN = Pattern.compile("([a-zA-Z0-9_${}\\u2E80-\\u9FFF]+)");
    private ZoneId zoneId;
    private QueryOperator queryOp;
    private IoTDBConstant.ClientVersion clientVersion = IoTDBConstant.ClientVersion.V_0_13;

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setClientVersion(IoTDBConstant.ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Operator visitSingleStatement(IoTDBSqlParser.SingleStatementContext ctx) {
        Operator operator = (Operator)this.visit((ParseTree)ctx.statement());
        if (ctx.DEBUG() != null) {
            operator.setDebug(true);
        }
        return operator;
    }

    public Operator visitSetStorageGroup(IoTDBSqlParser.SetStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public Operator visitCreateStorageGroup(IoTDBSqlParser.CreateStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public Operator visitCreateNonAlignedTimeseries(IoTDBSqlParser.CreateNonAlignedTimeseriesContext ctx) {
        CreateTimeSeriesOperator createTimeSeriesOperator = new CreateTimeSeriesOperator(51);
        createTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        if (ctx.attributeClauses() != null) {
            this.parseAttributeClauses(ctx.attributeClauses(), createTimeSeriesOperator);
        }
        return createTimeSeriesOperator;
    }

    public Operator visitCreateAlignedTimeseries(IoTDBSqlParser.CreateAlignedTimeseriesContext ctx) {
        CreateAlignedTimeSeriesOperator createAlignedTimeSeriesOperator = new CreateAlignedTimeSeriesOperator(51);
        createAlignedTimeSeriesOperator.setPrefixPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlignedMeasurements(ctx.alignedMeasurements(), createAlignedTimeSeriesOperator);
        return createAlignedTimeSeriesOperator;
    }

    public void parseAlignedMeasurements(IoTDBSqlParser.AlignedMeasurementsContext ctx, CreateAlignedTimeSeriesOperator createAlignedTimeSeriesOperator) {
        for (int i = 0; i < ctx.nodeNameWithoutWildcard().size(); ++i) {
            createAlignedTimeSeriesOperator.addMeasurement(this.parseNodeNameWithoutWildCard(ctx.nodeNameWithoutWildcard(i)));
            this.parseAttributeClauses(ctx.attributeClauses(i), createAlignedTimeSeriesOperator);
        }
    }

    public void parseAttributeClauses(IoTDBSqlParser.AttributeClausesContext ctx, CreateTimeSeriesOperator createTimeSeriesOperator) {
        if (ctx.aliasNodeName() != null) {
            createTimeSeriesOperator.setAlias(this.parseNodeName(ctx.aliasNodeName().nodeName()));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SQLParserException("expecting datatype");
            }
            props.put("dataType".toLowerCase(), this.parseAttributeValue(ctx.dataType).toLowerCase());
        }
        List attributePairs = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePairs) {
                props.put(this.parseAttributeKey(attributePair.attributeKey()).toLowerCase(), this.parseAttributeValue(attributePair.attributeValue()).toLowerCase());
            }
        }
        createTimeSeriesOperator.setProps(props);
        this.checkPropsInCreateTimeSeries(createTimeSeriesOperator);
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createTimeSeriesOperator);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createTimeSeriesOperator);
        }
    }

    private void checkPropsInCreateTimeSeries(CreateTimeSeriesOperator createTimeSeriesOperator) {
        Map<String, String> props = createTimeSeriesOperator.getProps();
        if (props != null && props.containsKey("dataType".toLowerCase())) {
            String datatypeString = props.get("dataType".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesOperator.setDataType(TSDataType.valueOf((String)datatypeString));
                props.remove("dataType".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported datatype: %s", datatypeString));
            }
        }
        if (createTimeSeriesOperator.getDataType() == null) {
            throw new SemanticException("datatype must be declared");
        }
        IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
        createTimeSeriesOperator.setEncoding(ioTDBDescriptor.getDefaultEncodingByType(createTimeSeriesOperator.getDataType()));
        if (props != null && props.containsKey("encoding".toLowerCase())) {
            String encodingString = props.get("encoding".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesOperator.setEncoding(TSEncoding.valueOf((String)encodingString));
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported encoding: %s", encodingString));
            }
        }
        createTimeSeriesOperator.setCompressor(TSFileDescriptor.getInstance().getConfig().getCompressor());
        if (props != null && props.containsKey("compression".toLowerCase())) {
            String compressionString = props.get("compression".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesOperator.setCompressor(CompressionType.valueOf((String)compressionString));
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressionString));
            }
        }
        if (props != null && props.containsKey("compressor".toLowerCase())) {
            String compressorString = props.get("compressor".toLowerCase()).toUpperCase();
            try {
                createTimeSeriesOperator.setCompressor(CompressionType.valueOf((String)compressorString));
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("Unsupported compression: %s", compressorString));
            }
        }
        createTimeSeriesOperator.setProps(props);
    }

    public void parseAttributeClauses(IoTDBSqlParser.AttributeClausesContext ctx, CreateAlignedTimeSeriesOperator createAlignedTimeSeriesOperator) {
        if (ctx.aliasNodeName() != null) {
            createAlignedTimeSeriesOperator.addAliasList(this.parseNodeName(ctx.aliasNodeName().nodeName()));
        } else {
            createAlignedTimeSeriesOperator.addAliasList(null);
        }
        TSDataType dataType = null;
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SQLParserException("expecting datatype");
            }
            String dataTypeString = ctx.dataType.getText().toUpperCase();
            try {
                dataType = TSDataType.valueOf((String)dataTypeString);
                createAlignedTimeSeriesOperator.addDataType(dataType);
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported datatype: %s", dataTypeString));
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.attributePair() != null) {
            for (int i = 0; i < ctx.attributePair().size(); ++i) {
                props.put(this.parseAttributeKey(ctx.attributePair(i).attributeKey()).toLowerCase(), this.parseAttributeValue(ctx.attributePair(i).attributeValue()));
            }
        }
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (props.containsKey("encoding".toLowerCase())) {
            String encodingString = ((String)props.get("encoding".toLowerCase())).toUpperCase();
            try {
                encoding = TSEncoding.valueOf((String)encodingString);
                createAlignedTimeSeriesOperator.addEncoding(encoding);
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported encoding: %s", encodingString));
            }
        } else {
            createAlignedTimeSeriesOperator.addEncoding(encoding);
        }
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (props.containsKey("compressor".toLowerCase())) {
            String compressorString = ((String)props.get("compressor".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressorString);
                createAlignedTimeSeriesOperator.addCompressor(compressor);
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compressor: %s", compressorString));
            }
        } else if (props.containsKey("compression".toLowerCase())) {
            String compressionString = ((String)props.get("compression".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressionString);
                createAlignedTimeSeriesOperator.addCompressor(compressor);
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compression: %s", compressionString));
            }
        } else {
            createAlignedTimeSeriesOperator.addCompressor(compressor);
        }
        if (props.size() > 0) {
            throw new SQLParserException("create aligned timeseries: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createAlignedTimeSeriesOperator);
        } else {
            createAlignedTimeSeriesOperator.addTagsList(null);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createAlignedTimeSeriesOperator);
        } else {
            createAlignedTimeSeriesOperator.addAttributesList(null);
        }
    }

    public Operator visitCreateSchemaTemplate(IoTDBSqlParser.CreateSchemaTemplateContext ctx) {
        CreateTemplateOperator createTemplateOperator = new CreateTemplateOperator(112);
        createTemplateOperator.setName(this.parseIdentifier(ctx.templateName.getText()));
        if (ctx.ALIGNED() != null) {
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                measurements.add(this.parseNodeNameWithoutWildCard(templateClauseContext.nodeNameWithoutWildcard()));
                this.parseAttributeClause(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
            }
            createTemplateOperator.addMeasurements(measurements);
            createTemplateOperator.addDataTypes(dataTypes);
            createTemplateOperator.addEncodings(encodings);
            createTemplateOperator.addCompressor(compressors);
        } else {
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                this.parseTemplateMeasurementClause(templateClauseContext, createTemplateOperator);
            }
        }
        return createTemplateOperator;
    }

    private void parseTemplateMeasurementClause(IoTDBSqlParser.TemplateMeasurementClauseContext ctx, CreateTemplateOperator createTemplateOperator) {
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        measurements.add(this.parseNodeNameWithoutWildCard(ctx.nodeNameWithoutWildcard()));
        this.parseAttributeClause(ctx.attributeClauses(), dataTypes, encodings, compressors);
        createTemplateOperator.addMeasurements(measurements);
        createTemplateOperator.addDataTypes(dataTypes);
        createTemplateOperator.addEncodings(encodings);
        createTemplateOperator.addCompressor(compressors);
    }

    void parseAttributeClause(IoTDBSqlParser.AttributeClausesContext ctx, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) {
        if (ctx.aliasNodeName() != null) {
            throw new SQLParserException("schema template: alias is not supported yet.");
        }
        TSDataType dataType = null;
        if (ctx.dataType != null) {
            if (ctx.attributeKey() != null && !this.parseAttributeKey(ctx.attributeKey()).equalsIgnoreCase("dataType")) {
                throw new SQLParserException("expecting datatype");
            }
            String dataTypeString = ctx.dataType.getText().toUpperCase();
            try {
                dataType = TSDataType.valueOf((String)dataTypeString);
                dataTypes.add(dataType);
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported datatype: %s", dataTypeString));
            }
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx.attributePair() != null) {
            for (int i = 0; i < ctx.attributePair().size(); ++i) {
                props.put(this.parseAttributeKey(ctx.attributePair(i).attributeKey()).toLowerCase(), this.parseAttributeValue(ctx.attributePair(i).attributeValue()));
            }
        }
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (props.containsKey("encoding".toLowerCase())) {
            String encodingString = ((String)props.get("encoding".toLowerCase())).toUpperCase();
            try {
                encoding = TSEncoding.valueOf((String)encodingString);
                encodings.add(encoding);
                props.remove("encoding".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported encoding: %s", encodingString));
            }
        } else {
            encodings.add(encoding);
        }
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (props.containsKey("compressor".toLowerCase())) {
            String compressorString = ((String)props.get("compressor".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressorString);
                compressors.add(compressor);
                props.remove("compressor".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compressor: %s", compressorString));
            }
        } else if (props.containsKey("compression".toLowerCase())) {
            String compressionString = ((String)props.get("compression".toLowerCase())).toUpperCase();
            try {
                compressor = CompressionType.valueOf((String)compressionString);
                compressors.add(compressor);
                props.remove("compression".toLowerCase());
            }
            catch (Exception e) {
                throw new SemanticException(String.format("unsupported compression: %s", compressionString));
            }
        } else {
            compressors.add(compressor);
        }
        if (props.size() > 0) {
            throw new SQLParserException("schema template: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            throw new SQLParserException("schema template: tag is not supported yet.");
        }
        if (ctx.attributeClause() != null) {
            throw new SQLParserException("schema template: attribute is not supported yet.");
        }
    }

    public Operator visitCreateTimeseriesOfSchemaTemplate(IoTDBSqlParser.CreateTimeseriesOfSchemaTemplateContext ctx) {
        ActivateTemplateOperator operator = new ActivateTemplateOperator(114);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitCreateFunction(IoTDBSqlParser.CreateFunctionContext ctx) {
        CreateFunctionOperator createFunctionOperator = new CreateFunctionOperator(92);
        createFunctionOperator.setUdfName(this.parseIdentifier(ctx.udfName.getText()));
        createFunctionOperator.setClassName(this.parseStringLiteral(ctx.className.getText()));
        return createFunctionOperator;
    }

    public Operator visitCreateTrigger(IoTDBSqlParser.CreateTriggerContext ctx) {
        CreateTriggerOperator createTriggerOperator = new CreateTriggerOperator(100);
        createTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        if (ctx.triggerEventClause().DELETE() != null) {
            throw new SQLParserException("Trigger does not support DELETE as TRIGGER_EVENT for now.");
        }
        createTriggerOperator.setEvent(ctx.triggerEventClause().BEFORE() != null ? TriggerEvent.BEFORE_INSERT : TriggerEvent.AFTER_INSERT);
        createTriggerOperator.setFullPath(this.parsePrefixPath(ctx.prefixPath()));
        createTriggerOperator.setClassName(this.parseStringLiteral(ctx.className.getText()));
        if (ctx.triggerAttributeClause() != null) {
            for (IoTDBSqlParser.TriggerAttributeContext triggerAttributeContext : ctx.triggerAttributeClause().triggerAttribute()) {
                createTriggerOperator.addAttribute(this.parseAttributeKey(triggerAttributeContext.key), this.parseAttributeValue(triggerAttributeContext.value));
            }
        }
        return createTriggerOperator;
    }

    public Operator visitCreateContinuousQuery(IoTDBSqlParser.CreateContinuousQueryContext ctx) {
        CreateContinuousQueryOperator createContinuousQueryOperator = new CreateContinuousQueryOperator(106);
        createContinuousQueryOperator.setQuerySql(ctx.getText());
        createContinuousQueryOperator.setContinuousQueryName(this.parseIdentifier(ctx.continuousQueryName.getText()));
        if (ctx.resampleClause() != null) {
            this.parseResampleClause(ctx.resampleClause(), createContinuousQueryOperator);
        }
        this.parseCqSelectIntoClause(ctx.cqSelectIntoClause(), createContinuousQueryOperator);
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(ctx.cqSelectIntoClause().selectClause().getText().substring(6));
        sb.append(" from ");
        sb.append(ctx.cqSelectIntoClause().fromClause().prefixPath(0).getText());
        sb.append(" group by ([now() - ");
        String groupByInterval = ctx.cqSelectIntoClause().cqGroupByTimeClause().DURATION_LITERAL().getText();
        if (createContinuousQueryOperator.getForInterval() == 0L) {
            sb.append(groupByInterval);
        } else {
            List durations = ctx.resampleClause().DURATION_LITERAL();
            sb.append(((TerminalNode)durations.get(durations.size() - 1)).getText());
        }
        sb.append(", now()), ");
        sb.append(groupByInterval);
        sb.append(")");
        if (this.queryOp.isGroupByLevel()) {
            sb.append(", level = ");
            int[] levels = this.queryOp.getSpecialClauseComponent().getLevels();
            sb.append(levels[0]);
            for (int i = 1; i < levels.length; ++i) {
                sb.append(String.format(", %d", levels[i]));
            }
        }
        createContinuousQueryOperator.setQuerySql(sb.toString());
        if (createContinuousQueryOperator.getEveryInterval() == 0L) {
            createContinuousQueryOperator.setEveryInterval(((GroupByClauseComponent)this.queryOp.getSpecialClauseComponent()).getUnit());
        }
        if (createContinuousQueryOperator.getEveryInterval() < IoTDBDescriptor.getInstance().getConfig().getContinuousQueryMinimumEveryInterval()) {
            throw new SQLParserException("CQ: every interval should not be lower than the minimum value you configured.");
        }
        if (createContinuousQueryOperator.getForInterval() == 0L) {
            createContinuousQueryOperator.setForInterval(((GroupByClauseComponent)this.queryOp.getSpecialClauseComponent()).getUnit());
        }
        return createContinuousQueryOperator;
    }

    public void parseCqSelectIntoClause(IoTDBSqlParser.CqSelectIntoClauseContext ctx, CreateContinuousQueryOperator createContinuousQueryOperator) {
        this.queryOp = new GroupByQueryOperator();
        this.parseSelectClause(ctx.selectClause());
        this.parseFromClause(ctx.fromClause());
        if (this.queryOp.getSelectComponent().getResultColumns().size() > 1) {
            throw new SQLParserException("CQ: CQ currently does not support multiple result columns.");
        }
        if (this.queryOp.getFromComponent().getPrefixPaths().size() > 1) {
            throw new SQLParserException("CQ: CQ currently does not support multiple series.");
        }
        this.parseCqGroupByTimeClause(ctx.cqGroupByTimeClause(), createContinuousQueryOperator);
        if (this.queryOp.isGroupByLevel()) {
            int[] groupByQueryLevels = this.queryOp.getSpecialClauseComponent().getLevels();
            int fromPrefixLevelLimit = this.queryOp.getFromComponent().getPrefixPaths().get(0).getNodeLength();
            if (Arrays.stream(groupByQueryLevels).max().getAsInt() >= fromPrefixLevelLimit) {
                throw new SQLParserException("CQ: Level should not exceed the <from_prefix> length.");
            }
        }
        createContinuousQueryOperator.setTargetPath(this.parseIntoPath(ctx.intoPath()));
        createContinuousQueryOperator.setQueryOperator(this.queryOp);
    }

    public void parseCqGroupByTimeClause(IoTDBSqlParser.CqGroupByTimeClauseContext ctx, CreateContinuousQueryOperator createContinuousQueryOperator) {
        GroupByClauseComponent groupByClauseComponent = new GroupByClauseComponent();
        long groupByInterval = this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL().getText(), true, groupByClauseComponent);
        groupByClauseComponent.setUnit(groupByInterval);
        createContinuousQueryOperator.setGroupByTimeInterval(groupByInterval);
        createContinuousQueryOperator.setGroupByTimeIntervalString(ctx.DURATION_LITERAL().getText());
        groupByClauseComponent.setSlidingStep(groupByClauseComponent.getUnit());
        groupByClauseComponent.setSlidingStepByMonth(groupByClauseComponent.isIntervalByMonth());
        groupByClauseComponent.setLeftCRightO(true);
        if (ctx.LEVEL() != null && ctx.INTEGER_LITERAL() != null) {
            int[] levels = new int[ctx.INTEGER_LITERAL().size()];
            for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
                levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
            }
            groupByClauseComponent.setLevels(levels);
        }
        this.queryOp.setSpecialClauseComponent(groupByClauseComponent);
    }

    public void parseResampleClause(IoTDBSqlParser.ResampleClauseContext ctx, CreateContinuousQueryOperator operator) {
        if (ctx.DURATION_LITERAL().size() == 1) {
            if (ctx.EVERY() != null) {
                operator.setEveryInterval(DatetimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(0).getText()));
            } else if (ctx.FOR() != null) {
                operator.setForInterval(DatetimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(0).getText()));
            }
        } else if (ctx.DURATION_LITERAL().size() == 2) {
            operator.setEveryInterval(DatetimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(0).getText()));
            operator.setForInterval(DatetimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(1).getText()));
        }
        if (ctx.BOUNDARY() != null) {
            operator.setFirstExecutionTimeBoundary(this.parseDateExpression(ctx.dateExpression()));
        }
    }

    public Operator visitAlterTimeseries(IoTDBSqlParser.AlterTimeseriesContext ctx) {
        AlterTimeSeriesOperator alterTimeSeriesOperator = new AlterTimeSeriesOperator(80);
        alterTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesOperator);
        return alterTimeSeriesOperator;
    }

    private void parseAlterClause(IoTDBSqlParser.AlterClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.RENAME);
            alterMap.put(this.parseAttributeKey(ctx.beforeName), this.parseAttributeKey(ctx.currentName));
        } else if (ctx.SET() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.DROP);
            for (int i = 0; i < ctx.attributeKey().size(); ++i) {
                alterMap.put(this.parseAttributeKey((IoTDBSqlParser.AttributeKeyContext)ctx.attributeKey().get(i)), null);
            }
        } else if (ctx.TAGS() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.UPSERT);
            if (ctx.aliasClause() != null) {
                this.parseAliasClause(ctx.aliasClause(), alterTimeSeriesOperator);
            }
            if (ctx.tagClause() != null) {
                this.parseTagClause(ctx.tagClause(), alterTimeSeriesOperator);
            }
            if (ctx.attributeClause() != null) {
                this.parseAttributeClause(ctx.attributeClause(), alterTimeSeriesOperator);
            }
        }
        alterTimeSeriesOperator.setAlterMap(alterMap);
    }

    public void parseAliasClause(IoTDBSqlParser.AliasClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        if (alterTimeSeriesOperator != null && ctx.ALIAS() != null) {
            alterTimeSeriesOperator.setAlias(this.parseAlias(ctx.alias()));
        }
    }

    public Operator visitDeleteStorageGroup(IoTDBSqlParser.DeleteStorageGroupContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteStorageGroupOperator deleteStorageGroupOperator = new DeleteStorageGroupOperator(62);
        deleteStorageGroupOperator.setDeletePathList(deletePaths);
        return deleteStorageGroupOperator;
    }

    public Operator visitDeleteTimeseries(IoTDBSqlParser.DeleteTimeseriesContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteTimeSeriesOperator deleteTimeSeriesOperator = new DeleteTimeSeriesOperator(52);
        deleteTimeSeriesOperator.setDeletePathList(deletePaths);
        return deleteTimeSeriesOperator;
    }

    public Operator visitDeletePartition(IoTDBSqlParser.DeletePartitionContext ctx) {
        DeletePartitionOperator deletePartitionOperator = new DeletePartitionOperator(88);
        deletePartitionOperator.setStorageGroupName(this.parsePrefixPath(ctx.prefixPath()));
        HashSet<Long> idSet = new HashSet<Long>();
        for (TerminalNode terminalNode : ctx.INTEGER_LITERAL()) {
            idSet.add(Long.parseLong(terminalNode.getText()));
        }
        deletePartitionOperator.setPartitionIds(idSet);
        return deletePartitionOperator;
    }

    public Operator visitDropFunction(IoTDBSqlParser.DropFunctionContext ctx) {
        DropFunctionOperator dropFunctionOperator = new DropFunctionOperator(93);
        dropFunctionOperator.setUdfName(this.parseIdentifier(ctx.udfName.getText()));
        return dropFunctionOperator;
    }

    public Operator visitDropTrigger(IoTDBSqlParser.DropTriggerContext ctx) {
        DropTriggerOperator dropTriggerOperator = new DropTriggerOperator(101);
        dropTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        return dropTriggerOperator;
    }

    public Operator visitDropContinuousQuery(IoTDBSqlParser.DropContinuousQueryContext ctx) {
        DropContinuousQueryOperator dropContinuousQueryOperator = new DropContinuousQueryOperator(107);
        dropContinuousQueryOperator.setContinuousQueryName(this.parseIdentifier(ctx.continuousQueryName.getText()));
        return dropContinuousQueryOperator;
    }

    public Operator visitDropSchemaTemplate(IoTDBSqlParser.DropSchemaTemplateContext ctx) {
        DropTemplateOperator dropTemplateOperator = new DropTemplateOperator(118);
        dropTemplateOperator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return dropTemplateOperator;
    }

    public Operator visitSetTTL(IoTDBSqlParser.SetTTLContext ctx) {
        SetTTLOperator operator = new SetTTLOperator(63);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        operator.setDataTTL(Long.parseLong(ctx.INTEGER_LITERAL().getText()));
        return operator;
    }

    public Operator visitUnsetTTL(IoTDBSqlParser.UnsetTTLContext ctx) {
        UnSetTTLOperator operator = new UnSetTTLOperator(64);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitSetSchemaTemplate(IoTDBSqlParser.SetSchemaTemplateContext ctx) {
        SetTemplateOperator operator = new SetTemplateOperator(113);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        operator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return operator;
    }

    public Operator visitUnsetSchemaTemplate(IoTDBSqlParser.UnsetSchemaTemplateContext ctx) {
        UnsetTemplateOperator operator = new UnsetTemplateOperator(115);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        operator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return operator;
    }

    public Operator visitStartTrigger(IoTDBSqlParser.StartTriggerContext ctx) {
        StartTriggerOperator startTriggerOperator = new StartTriggerOperator(102);
        startTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        return startTriggerOperator;
    }

    public Operator visitStopTrigger(IoTDBSqlParser.StopTriggerContext ctx) {
        StopTriggerOperator stopTriggerOperator = new StopTriggerOperator(103);
        stopTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        return stopTriggerOperator;
    }

    public Operator visitShowStorageGroup(IoTDBSqlParser.ShowStorageGroupContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowStorageGroupOperator(74, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowStorageGroupOperator(74, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowDevices(IoTDBSqlParser.ShowDevicesContext ctx) {
        ShowDevicesOperator showDevicesOperator = ctx.prefixPath() != null ? new ShowDevicesOperator(76, this.parsePrefixPath(ctx.prefixPath())) : new ShowDevicesOperator(76, new PartialPath(SQLConstant.getSingleRootArray()));
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showDevicesOperator);
        }
        if (ctx.WITH() != null) {
            showDevicesOperator.setSgCol(true);
        }
        return showDevicesOperator;
    }

    public Operator visitShowTimeseries(IoTDBSqlParser.ShowTimeseriesContext ctx) {
        boolean orderByHeat = ctx.LATEST() != null;
        ShowTimeSeriesOperator showTimeSeriesOperator = ctx.prefixPath() != null ? new ShowTimeSeriesOperator(73, this.parsePrefixPath(ctx.prefixPath()), orderByHeat) : new ShowTimeSeriesOperator(73, new PartialPath(SQLConstant.getSingleRootArray()), orderByHeat);
        if (ctx.tagWhereClause() != null) {
            this.parseShowWhereClause(ctx.tagWhereClause(), showTimeSeriesOperator);
        }
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showTimeSeriesOperator);
        }
        return showTimeSeriesOperator;
    }

    private void parseShowWhereClause(IoTDBSqlParser.TagWhereClauseContext ctx, ShowTimeSeriesOperator operator) {
        IoTDBSqlParser.AttributeValueContext attributeValueContext;
        if (ctx.containsExpression() != null) {
            operator.setContains(true);
            attributeValueContext = ctx.containsExpression().attributeValue();
            operator.setKey(this.parseAttributeKey(ctx.containsExpression().attributeKey()));
        } else {
            operator.setContains(false);
            attributeValueContext = ctx.attributePair().attributeValue();
            operator.setKey(this.parseAttributeKey(ctx.attributePair().attributeKey()));
        }
        operator.setValue(this.parseAttributeValue(attributeValueContext));
    }

    public Operator visitShowChildPaths(IoTDBSqlParser.ShowChildPathsContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildPathsOperator(75, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildPathsOperator(75, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowChildNodes(IoTDBSqlParser.ShowChildNodesContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildNodesOperator(99, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildNodesOperator(99, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowFunctions(IoTDBSqlParser.ShowFunctionsContext ctx) {
        return new ShowFunctionsOperator(94);
    }

    public Operator visitShowTriggers(IoTDBSqlParser.ShowTriggersContext ctx) {
        return new ShowTriggersOperator(104);
    }

    public Operator visitShowContinuousQueries(IoTDBSqlParser.ShowContinuousQueriesContext ctx) {
        return new ShowContinuousQueriesOperator(108);
    }

    public Operator visitShowTTL(IoTDBSqlParser.ShowTTLContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        List prefixPathList = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPathList) {
            storageGroups.add(this.parsePrefixPath(prefixPath));
        }
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowAllTTL(IoTDBSqlParser.ShowAllTTLContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowSchemaTemplates(IoTDBSqlParser.ShowSchemaTemplatesContext ctx) {
        return new ShowTemplatesOperator(119);
    }

    public Operator visitShowNodesInSchemaTemplate(IoTDBSqlParser.ShowNodesInSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowNodesInTemplateOperator(120, templateName);
    }

    public Operator visitShowPathsSetSchemaTemplate(IoTDBSqlParser.ShowPathsSetSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowPathsSetTemplateOperator(121, templateName);
    }

    public Operator visitShowPathsUsingSchemaTemplate(IoTDBSqlParser.ShowPathsUsingSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowPathsUsingTemplateOperator(122, templateName);
    }

    public Operator visitCountStorageGroup(IoTDBSqlParser.CountStorageGroupContext ctx) {
        IoTDBSqlParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(96, path);
    }

    public Operator visitCountDevices(IoTDBSqlParser.CountDevicesContext ctx) {
        IoTDBSqlParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(95, path);
    }

    public Operator visitCountTimeseries(IoTDBSqlParser.CountTimeseriesContext ctx) {
        PartialPath path;
        IoTDBSqlParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath partialPath = path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        if (ctx.INTEGER_LITERAL() != null) {
            return new CountOperator(78, path, Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        }
        return new CountOperator(77, path);
    }

    public Operator visitCountNodes(IoTDBSqlParser.CountNodesContext ctx) {
        return new CountOperator(79, this.parsePrefixPath(ctx.prefixPath()), Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
    }

    public Operator visitSelectStatement(IoTDBSqlParser.SelectStatementContext ctx) {
        if (ctx.specialClause() != null) {
            this.queryOp = (QueryOperator)this.visit((ParseTree)ctx.specialClause());
        }
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseSelectClause(ctx.selectClause());
        this.parseFromClause(ctx.fromClause());
        if (ctx.whereClause() != null) {
            WhereComponent whereComponent = this.parseWhereClause(ctx.whereClause());
            this.queryOp.setWhereComponent(whereComponent);
        }
        this.queryOp.setEnableTracing(ctx.TRACING() != null);
        return ctx.intoClause() == null ? this.queryOp : this.parseAndConstructSelectIntoOperator(ctx);
    }

    private SelectIntoOperator parseAndConstructSelectIntoOperator(IoTDBSqlParser.SelectStatementContext ctx) {
        if (this.queryOp.getFromComponent().getPrefixPaths().size() != 1) {
            throw new SQLParserException("select into: the number of prefix paths in the from clause should be 1.");
        }
        int sourcePathsCount = this.queryOp.getSelectComponent().getResultColumns().size();
        if (sourcePathsCount != ctx.intoClause().intoPath().size()) {
            throw new SQLParserException("select into: the number of source paths and the number of target paths should be the same.");
        }
        SelectIntoOperator selectIntoOperator = new SelectIntoOperator();
        selectIntoOperator.setQueryOperator(this.queryOp);
        ArrayList<PartialPath> intoPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < sourcePathsCount; ++i) {
            intoPaths.add(this.parseIntoPath(ctx.intoClause().intoPath(i)));
        }
        selectIntoOperator.setIntoPaths(intoPaths);
        selectIntoOperator.setIntoPathsAligned(ctx.intoClause().ALIGNED() != null);
        return selectIntoOperator;
    }

    private PartialPath parseIntoPath(IoTDBSqlParser.IntoPathContext intoPathContext) {
        int levelLimitOfSourcePrefixPath = this.queryOp.isGroupByLevel() ? Arrays.stream(this.queryOp.getSpecialClauseComponent().getLevels()).max().getAsInt() : this.queryOp.getFromComponent().getPrefixPaths().get(0).getNodeLength() - 1;
        PartialPath intoPath = null;
        if (intoPathContext.fullPath() != null) {
            intoPath = this.parseFullPathInSelectInto(intoPathContext.fullPath());
            Matcher m = leveledPathNodePattern.matcher(intoPath.getFullPath());
            while (m.find()) {
                int nodeIndex;
                String param = m.group();
                try {
                    nodeIndex = Integer.parseInt(param.substring(2, param.length() - 1).trim());
                }
                catch (NumberFormatException e) {
                    throw new SQLParserException("the x of ${x} should be an integer.");
                }
                if (nodeIndex >= 1 && levelLimitOfSourcePrefixPath >= nodeIndex) continue;
                throw new SQLParserException("the x of ${x} should be greater than 0 and equal to or less than <level> or the length of queried path prefix.");
            }
        } else if (intoPathContext.nodeNameWithoutWildcard() != null) {
            int i;
            List nodeNameWithoutStars = intoPathContext.nodeNameWithoutWildcard();
            String[] intoPathNodes = new String[1 + levelLimitOfSourcePrefixPath + nodeNameWithoutStars.size()];
            intoPathNodes[0] = "root";
            for (i = 1; i <= levelLimitOfSourcePrefixPath; ++i) {
                intoPathNodes[i] = "${" + i + "}";
            }
            for (i = 1; i <= nodeNameWithoutStars.size(); ++i) {
                intoPathNodes[levelLimitOfSourcePrefixPath + i] = this.parseNodeNameWithoutWildCardInSelectInto((IoTDBSqlParser.NodeNameWithoutWildcardContext)nodeNameWithoutStars.get(i - 1));
            }
            intoPath = new PartialPath(intoPathNodes);
        }
        return intoPath;
    }

    public Operator visitSpecialLimitStatement(IoTDBSqlParser.SpecialLimitStatementContext ctx) {
        return (Operator)this.visit((ParseTree)ctx.specialLimit());
    }

    public Operator visitOrderByTimeStatement(IoTDBSqlParser.OrderByTimeStatementContext ctx) {
        this.queryOp = new QueryOperator();
        this.parseOrderByClause(ctx.orderByClause());
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByTimeStatement(IoTDBSqlParser.GroupByTimeStatementContext ctx) {
        this.queryOp = new GroupByQueryOperator();
        this.parseGroupByTimeClause(ctx.groupByTimeClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByFillStatement(IoTDBSqlParser.GroupByFillStatementContext ctx) {
        this.queryOp = new GroupByFillQueryOperator();
        this.parseGroupByFillClause(ctx.groupByFillClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByLevelStatement(IoTDBSqlParser.GroupByLevelStatementContext ctx) {
        this.queryOp = new AggregationQueryOperator();
        this.parseGroupByLevelClause(ctx.groupByLevelClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitFillStatement(IoTDBSqlParser.FillStatementContext ctx) {
        this.queryOp = new FillQueryOperator();
        this.parseFillClause(ctx.fillClause());
        if (ctx.orderByClause() != null) {
            this.parseOrderByClause(ctx.orderByClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitLimitStatement(IoTDBSqlParser.LimitStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseLimitClause(ctx.limitClause(), this.queryOp);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitSlimitStatement(IoTDBSqlParser.SlimitStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseSlimitClause(ctx.slimitClause());
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitWithoutNullStatement(IoTDBSqlParser.WithoutNullStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseWithoutNullClause(ctx.withoutNullClause());
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitAlignByDeviceClauseOrDisableAlignStatement(IoTDBSqlParser.AlignByDeviceClauseOrDisableAlignStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        return this.queryOp;
    }

    private void parseAlignByDeviceClauseOrDisableAlign(IoTDBSqlParser.AlignByDeviceClauseOrDisableAlignContext ctx) {
        SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        if (ctx.alignByDeviceClause() != null) {
            this.parseAlignByDeviceClause(specialClauseComponent);
        } else {
            this.parseDisableAlign(specialClauseComponent);
        }
        this.queryOp.setSpecialClauseComponent(specialClauseComponent);
    }

    private void parseAlignByDeviceClause(SpecialClauseComponent specialClauseComponent) {
        specialClauseComponent.setAlignByDevice(true);
    }

    private void parseDisableAlign(SpecialClauseComponent specialClauseComponent) {
        specialClauseComponent.setAlignByTime(false);
    }

    private void parseOrderByClause(IoTDBSqlParser.OrderByClauseContext ctx) {
        if (ctx.orderByAttributeClause().size() > 1) {
            throw new SQLParserException("Sorting by multiple fields is not supported.");
        }
        SortItem sortItem = this.parseOrderByAttributeClause(ctx.orderByAttributeClause(0));
        if (sortItem.getSortKey() != SortKey.TIME) {
            throw new SQLParserException("It only supports sorting by time.");
        }
        if (sortItem.getOrdering() == Ordering.DESC) {
            SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
            if (specialClauseComponent == null) {
                specialClauseComponent = new SpecialClauseComponent();
            }
            specialClauseComponent.setAscending(false);
            this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        }
    }

    private SortItem parseOrderByAttributeClause(IoTDBSqlParser.OrderByAttributeClauseContext ctx) {
        return new SortItem(SortKey.valueOf(ctx.sortKey().getText().toUpperCase()), ctx.DESC() != null ? Ordering.DESC : Ordering.ASC);
    }

    private void parseGroupByTimeClause(IoTDBSqlParser.GroupByTimeClauseContext ctx) {
        GroupByClauseComponent groupByClauseComponent = new GroupByClauseComponent();
        groupByClauseComponent.setLeftCRightO(ctx.timeRange().LS_BRACKET() != null);
        groupByClauseComponent.setUnit(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(0).getText(), true, groupByClauseComponent));
        if (groupByClauseComponent.getUnit() <= 0L) {
            throw new SQLParserException("The second parameter time interval should be a positive integer.");
        }
        if (ctx.DURATION_LITERAL().size() == 2) {
            groupByClauseComponent.setSlidingStep(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(1).getText(), false, groupByClauseComponent));
        } else {
            groupByClauseComponent.setSlidingStep(groupByClauseComponent.getUnit());
            groupByClauseComponent.setSlidingStepByMonth(groupByClauseComponent.isIntervalByMonth());
        }
        this.parseTimeInterval(ctx.timeRange(), groupByClauseComponent);
        if (ctx.LEVEL() != null && ctx.INTEGER_LITERAL() != null) {
            int[] levels = new int[ctx.INTEGER_LITERAL().size()];
            for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
                levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
            }
            groupByClauseComponent.setLevels(levels);
        }
        this.queryOp.setSpecialClauseComponent(groupByClauseComponent);
    }

    private void parseGroupByFillClause(IoTDBSqlParser.GroupByFillClauseContext ctx) {
        GroupByFillClauseComponent groupByFillClauseComponent = new GroupByFillClauseComponent();
        groupByFillClauseComponent.setLeftCRightO(ctx.timeRange().LS_BRACKET() != null);
        groupByFillClauseComponent.setUnit(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(0).getText(), true, groupByFillClauseComponent));
        if (ctx.DURATION_LITERAL().size() == 2) {
            groupByFillClauseComponent.setSlidingStep(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(1).getText(), false, groupByFillClauseComponent));
            if (groupByFillClauseComponent.getSlidingStep() < groupByFillClauseComponent.getUnit()) {
                throw new SQLParserException("The third parameter sliding step shouldn't be smaller than the second parameter time interval.");
            }
        } else {
            groupByFillClauseComponent.setSlidingStep(groupByFillClauseComponent.getUnit());
            groupByFillClauseComponent.setSlidingStepByMonth(groupByFillClauseComponent.isIntervalByMonth());
        }
        this.parseTimeInterval(ctx.timeRange(), groupByFillClauseComponent);
        if (ctx.fillClause().oldTypeClause().size() > 0) {
            List list = ctx.fillClause().oldTypeClause();
            EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
            for (IoTDBSqlParser.OldTypeClauseContext typeClause : list) {
                if (typeClause.ALL() != null) {
                    this.parseAllTypeClause(typeClause, fillTypes);
                    continue;
                }
                this.parsePrimitiveTypeClause(typeClause, fillTypes);
            }
            int usePrevious = 0;
            int useLinear = 0;
            int useValue = 0;
            for (IFill iFill : fillTypes.values()) {
                if (iFill instanceof PreviousFill) {
                    usePrevious = 1;
                }
                if (iFill instanceof LinearFill) {
                    useLinear = 1;
                }
                if (!(iFill instanceof ValueFill)) continue;
                useValue = 1;
            }
            if (usePrevious + useLinear + useValue > 1) {
                throw new SQLParserException("The old type logic could only use one type of fill");
            }
            groupByFillClauseComponent.setFillTypes(fillTypes);
        } else {
            groupByFillClauseComponent.setSingleFill(this.getSingleIFill(ctx.fillClause()));
        }
        this.queryOp.setSpecialClauseComponent(groupByFillClauseComponent);
    }

    public void parseGroupByLevelClause(IoTDBSqlParser.GroupByLevelClauseContext ctx) {
        SpecialClauseComponent groupByLevelClauseComponent = new SpecialClauseComponent();
        int[] levels = new int[ctx.INTEGER_LITERAL().size()];
        for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
            levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
        }
        groupByLevelClauseComponent.setLevels(levels);
        if (ctx.fillClause() != null) {
            this.parseFillClause(ctx.fillClause());
        }
        this.queryOp.setSpecialClauseComponent(groupByLevelClauseComponent);
    }

    public void parseFillClause(IoTDBSqlParser.FillClauseContext ctx) {
        FillClauseComponent fillClauseComponent = new FillClauseComponent();
        if (ctx.oldTypeClause().size() > 0) {
            List list = ctx.oldTypeClause();
            EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
            for (IoTDBSqlParser.OldTypeClauseContext typeClause : list) {
                if (typeClause.ALL() != null) {
                    if (typeClause.linearClause() != null) {
                        throw new SQLParserException("fill all doesn't support linear fill");
                    }
                    this.parseAllTypeClause(typeClause, fillTypes);
                    break;
                }
                this.parsePrimitiveTypeClause(typeClause, fillTypes);
            }
            fillClauseComponent.setFillTypes(fillTypes);
        } else {
            fillClauseComponent.setSingleFill(this.getSingleIFill(ctx));
        }
        this.queryOp.setSpecialClauseComponent(fillClauseComponent);
    }

    private void parseTimeInterval(IoTDBSqlParser.TimeRangeContext timeInterval, GroupByClauseComponent groupByClauseComponent) {
        long currentTime = DatetimeUtils.currentTime();
        long startTime = this.parseTimeValue(timeInterval.timeValue(0), currentTime);
        long endTime = this.parseTimeValue(timeInterval.timeValue(1), currentTime);
        groupByClauseComponent.setStartTime(startTime);
        groupByClauseComponent.setEndTime(endTime);
        if (startTime >= endTime) {
            throw new SQLParserException("Start time should be smaller than endTime in GroupBy");
        }
    }

    private void parseWithoutNullClause(IoTDBSqlParser.WithoutNullClauseContext ctx) {
        SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        List expressionContexts = ctx.expression();
        for (IoTDBSqlParser.ExpressionContext expressionContext : expressionContexts) {
            specialClauseComponent.addWithoutNullColumn(this.parseExpression(expressionContext, true));
        }
        specialClauseComponent.setWithoutAnyNull(ctx.ANY() != null);
        specialClauseComponent.setWithoutAllNull(ctx.ALL() != null);
        this.queryOp.setSpecialClauseComponent(specialClauseComponent);
    }

    private IFill getSingleIFill(IoTDBSqlParser.FillClauseContext ctx) {
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL(0) != null) {
                String beforeStr = ctx.linearClause().DURATION_LITERAL(0).getText();
                String afterStr = ctx.linearClause().DURATION_LITERAL(1).getText();
                return new LinearFill(beforeStr, afterStr);
            }
            return new LinearFill(defaultFillInterval, (long)defaultFillInterval);
        }
        if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                String preRangeStr = ctx.previousClause().DURATION_LITERAL().getText();
                return new PreviousFill(preRangeStr);
            }
            return new PreviousFill(defaultFillInterval);
        }
        if (ctx.specificValueClause() != null) {
            if (ctx.specificValueClause().constant() != null) {
                return new ValueFill(ctx.specificValueClause().constant().getText());
            }
            throw new SQLParserException("fill value cannot be null");
        }
        if (ctx.previousUntilLastClause() != null) {
            if (ctx.previousUntilLastClause().DURATION_LITERAL() != null) {
                String preRangeStr = ctx.previousUntilLastClause().DURATION_LITERAL().getText();
                return new PreviousFill(preRangeStr, true);
            }
            return new PreviousFill(defaultFillInterval, true);
        }
        throw new SQLParserException("unknown single fill type");
    }

    private void parseAllTypeClause(IoTDBSqlParser.OldTypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        String preRangeStr;
        IFill fill;
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL(0) != null) {
                String beforeStr = ctx.linearClause().DURATION_LITERAL(0).getText();
                String afterStr = ctx.linearClause().DURATION_LITERAL(1).getText();
                fill = new LinearFill(beforeStr, afterStr);
            } else {
                fill = new LinearFill(defaultFillInterval, (long)defaultFillInterval);
            }
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                preRangeStr = ctx.previousClause().DURATION_LITERAL().getText();
                fill = new PreviousFill(preRangeStr);
            } else {
                fill = new PreviousFill(defaultFillInterval);
            }
        } else {
            if (ctx.specificValueClause() != null) {
                throw new SQLParserException("fill all doesn't support value fill");
            }
            if (ctx.previousUntilLastClause().DURATION_LITERAL() != null) {
                preRangeStr = ctx.previousUntilLastClause().DURATION_LITERAL().getText();
                fill = new PreviousFill(preRangeStr, true);
            } else {
                fill = new PreviousFill(defaultFillInterval, true);
            }
        }
        for (TSDataType tsDataType : TSDataType.values()) {
            if (tsDataType == TSDataType.VECTOR || fill instanceof LinearFill && (tsDataType == TSDataType.BOOLEAN || tsDataType == TSDataType.TEXT)) continue;
            fillTypes.put(tsDataType, fill.copy());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePrimitiveTypeClause(IoTDBSqlParser.OldTypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        TSDataType dataType = this.parseType(this.parseAttributeValue(ctx.dataType));
        if (dataType == TSDataType.VECTOR) {
            throw new SQLParserException(String.format("type %s cannot use fill function", dataType));
        }
        if (ctx.linearClause() != null && (dataType == TSDataType.TEXT || dataType == TSDataType.BOOLEAN)) {
            throw new SQLParserException(String.format("type %s cannot use %s fill function", dataType, ctx.linearClause().LINEAR().getText()));
        }
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL(0) != null) {
                String beforeRangeStr = ctx.linearClause().DURATION_LITERAL(0).getText();
                String afterRangeStr = ctx.linearClause().DURATION_LITERAL(1).getText();
                LinearFill fill = new LinearFill(beforeRangeStr, afterRangeStr);
                fillTypes.put(dataType, fill);
                return;
            } else {
                fillTypes.put(dataType, new LinearFill(defaultFillInterval, (long)defaultFillInterval));
            }
            return;
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                String beforeStr = ctx.previousClause().DURATION_LITERAL().getText();
                fillTypes.put(dataType, new PreviousFill(beforeStr));
                return;
            } else {
                fillTypes.put(dataType, new PreviousFill(defaultFillInterval));
            }
            return;
        } else if (ctx.specificValueClause() != null) {
            if (ctx.specificValueClause().constant() == null) throw new SQLParserException("fill value cannot be null");
            fillTypes.put(dataType, new ValueFill(ctx.specificValueClause().constant().getText(), dataType));
            return;
        } else if (ctx.previousUntilLastClause().DURATION_LITERAL() != null) {
            String preRangeStr = ctx.previousUntilLastClause().DURATION_LITERAL().getText();
            fillTypes.put(dataType, new PreviousFill(preRangeStr, true));
            return;
        } else {
            fillTypes.put(dataType, new PreviousFill(defaultFillInterval, true));
        }
    }

    private TSDataType parseType(String datatype) {
        try {
            return TSDataType.valueOf((String)datatype.toUpperCase());
        }
        catch (Exception e) {
            throw new SQLParserException("not a valid fill type : " + datatype);
        }
    }

    public Operator visitInsertStatement(IoTDBSqlParser.InsertStatementContext ctx) {
        InsertOperator insertOp = new InsertOperator(24);
        insertOp.setDevice(this.parsePrefixPath(ctx.prefixPath()));
        boolean isTimeDefault = this.parseInsertColumnSpec(ctx.insertColumnsSpec(), insertOp);
        this.parseInsertValuesSpec(ctx.insertValuesSpec(), insertOp, isTimeDefault);
        insertOp.setAligned(ctx.ALIGNED() != null);
        return insertOp;
    }

    private boolean parseInsertColumnSpec(IoTDBSqlParser.InsertColumnsSpecContext ctx, InsertOperator insertOp) {
        ArrayList<String> measurementList = new ArrayList<String>();
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext measurementName : ctx.nodeNameWithoutWildcard()) {
            measurementList.add(this.parseNodeNameWithoutWildCard(measurementName));
        }
        insertOp.setMeasurementList(measurementList.toArray(new String[0]));
        return ctx.TIME() == null && ctx.TIMESTAMP() == null;
    }

    private void parseInsertValuesSpec(IoTDBSqlParser.InsertValuesSpecContext ctx, InsertOperator insertOp, boolean isTimeDefault) {
        List insertMultiValues = ctx.insertMultiValue();
        ArrayList<String[]> valueLists = new ArrayList<String[]>();
        long[] timeArray = new long[insertMultiValues.size()];
        for (int i = 0; i < insertMultiValues.size(); ++i) {
            long timestamp;
            ArrayList<String> valueList = new ArrayList<String>();
            if (((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue() != null) {
                if (isTimeDefault) {
                    if (insertMultiValues.size() != 1) {
                        throw new SQLParserException("need timestamps when insert multi rows");
                    }
                    valueList.add(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue().getText());
                    timestamp = DatetimeUtils.currentTime();
                } else {
                    timestamp = this.parseTimeValue(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue(), DatetimeUtils.currentTime());
                }
            } else {
                if (!isTimeDefault) {
                    throw new SQLParserException("the measurementList's size is not consistent with the valueList's size");
                }
                if (insertMultiValues.size() != 1) {
                    throw new SQLParserException("need timestamps when insert multi rows");
                }
                timestamp = this.parseDateFormat("now()");
            }
            timeArray[i] = timestamp;
            List values = ((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).measurementValue();
            for (IoTDBSqlParser.MeasurementValueContext value : values) {
                for (IoTDBSqlParser.ConstantContext constant : value.constant()) {
                    if (constant.STRING_LITERAL() != null) {
                        valueList.add(this.parseStringLiteralInInsertValue(constant.getText()));
                        continue;
                    }
                    valueList.add(constant.getText());
                }
            }
            valueLists.add(valueList.toArray(new String[0]));
        }
        insertOp.setTimes(timeArray);
        insertOp.setValueLists(valueLists);
    }

    public Operator visitDeleteStatement(IoTDBSqlParser.DeleteStatementContext ctx) {
        DeleteDataOperator deleteDataOp = new DeleteDataOperator(25);
        List prefixPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            deleteDataOp.addPath(this.parsePrefixPath(prefixPath));
        }
        if (ctx.whereClause() != null) {
            WhereComponent whereComponent = this.parseWhereClause(ctx.whereClause());
            Pair<Long, Long> timeInterval = this.parseDeleteTimeInterval(whereComponent.getFilterOperator());
            deleteDataOp.setStartTime((Long)timeInterval.left);
            deleteDataOp.setEndTime((Long)timeInterval.right);
        } else {
            deleteDataOp.setStartTime(Long.MIN_VALUE);
            deleteDataOp.setEndTime(Long.MAX_VALUE);
        }
        return deleteDataOp;
    }

    private Pair<Long, Long> parseDeleteTimeInterval(FilterOperator filterOperator) {
        if (!filterOperator.isLeaf() && filterOperator.getFilterType() != FilterConstant.FilterType.KW_AND) {
            throw new SemanticException(DELETE_RANGE_ERROR_MSG);
        }
        if (filterOperator.isLeaf()) {
            return this.calcOperatorInterval(filterOperator);
        }
        List<FilterOperator> children = filterOperator.getChildren();
        FilterOperator lOperator = children.get(0);
        FilterOperator rOperator = children.get(1);
        if (!lOperator.isLeaf() || !rOperator.isLeaf()) {
            throw new SemanticException(DELETE_RANGE_ERROR_MSG);
        }
        Pair<Long, Long> leftOpInterval = this.calcOperatorInterval(lOperator);
        Pair<Long, Long> rightOpInterval = this.calcOperatorInterval(rOperator);
        Pair parsedInterval = new Pair((Object)Math.max((Long)leftOpInterval.left, (Long)rightOpInterval.left), (Object)Math.min((Long)leftOpInterval.right, (Long)rightOpInterval.right));
        if ((Long)parsedInterval.left > (Long)parsedInterval.right) {
            throw new SQLParserException("Invalid delete range: [" + parsedInterval.left + ", " + parsedInterval.right + "]");
        }
        return parsedInterval;
    }

    public Operator visitCreateUser(IoTDBSqlParser.CreateUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorOperator.setPassWord(this.parseStringLiteral(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitCreateRole(IoTDBSqlParser.CreateRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
        authorOperator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        return authorOperator;
    }

    public Operator visitAlterUser(IoTDBSqlParser.AlterUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorOperator.setNewPassword(this.parseStringLiteral(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitGrantUser(IoTDBSqlParser.GrantUserContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorOperator.setPrivilegeList(privileges);
        authorOperator.setNodeNameList(nodeNameList);
        return authorOperator;
    }

    public Operator visitGrantRole(IoTDBSqlParser.GrantRoleContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
        authorOperator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorOperator.setPrivilegeList(privileges);
        authorOperator.setNodeNameList(nodeNameList);
        return authorOperator;
    }

    public Operator visitGrantRoleToUser(IoTDBSqlParser.GrantRoleToUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER_ROLE);
        authorOperator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        return authorOperator;
    }

    public Operator visitRevokeUser(IoTDBSqlParser.RevokeUserContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER);
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        authorOperator.setPrivilegeList(privileges);
        authorOperator.setNodeNameList(nodeNameList);
        return authorOperator;
    }

    public Operator visitRevokeRole(IoTDBSqlParser.RevokeRoleContext ctx) {
        String[] privileges = this.parsePrivilege(ctx.privileges());
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(this::parsePrefixPath).distinct().collect(Collectors.toList());
        this.checkGrantRevokePrivileges(privileges, nodeNameList);
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE);
        authorOperator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorOperator.setPrivilegeList(privileges);
        authorOperator.setNodeNameList(nodeNameList);
        return authorOperator;
    }

    private void checkGrantRevokePrivileges(String[] privileges, List<PartialPath> nodeNameList) {
        if (nodeNameList.isEmpty()) {
            nodeNameList.addAll(Collections.singletonList(new PartialPath(MetadataConstant.ALL_RESULT_NODES)));
            return;
        }
        boolean pathRelevant = true;
        String errorPrivilegeName = "";
        for (String privilege : privileges) {
            if (PrivilegeType.valueOf((String)privilege.toUpperCase()).isPathRelevant()) continue;
            pathRelevant = false;
            errorPrivilegeName = privilege.toUpperCase();
            break;
        }
        if (!(pathRelevant || nodeNameList.size() == 1 && nodeNameList.contains(new PartialPath(MetadataConstant.ALL_RESULT_NODES)))) {
            throw new SQLParserException(String.format("path independent privilege: [%s] can only be set on path: root.**", errorPrivilegeName));
        }
    }

    public Operator visitRevokeRoleFromUser(IoTDBSqlParser.RevokeRoleFromUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER_ROLE);
        authorOperator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        return authorOperator;
    }

    public Operator visitDropUser(IoTDBSqlParser.DropUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
        authorOperator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        return authorOperator;
    }

    public Operator visitDropRole(IoTDBSqlParser.DropRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
        authorOperator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        return authorOperator;
    }

    public Operator visitListUser(IoTDBSqlParser.ListUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
        if (ctx.roleName != null) {
            operator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        }
        return operator;
    }

    public Operator visitListRole(IoTDBSqlParser.ListRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
        if (ctx.userName != null) {
            operator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        }
        return operator;
    }

    public Operator visitListPrivilegesUser(IoTDBSqlParser.ListPrivilegesUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(this.parseIdentifier(ctx.userName.getText()));
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(prefixPath -> this.parsePrefixPath((IoTDBSqlParser.PrefixPathContext)prefixPath)).collect(Collectors.toList());
        operator.setNodeNameList(nodeNameList);
        return operator;
    }

    public Operator visitListPrivilegesRole(IoTDBSqlParser.ListPrivilegesRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(this.parseIdentifier(ctx.roleName.getText()));
        List<PartialPath> nodeNameList = ctx.prefixPath().stream().map(prefixPath -> this.parsePrefixPath((IoTDBSqlParser.PrefixPathContext)prefixPath)).collect(Collectors.toList());
        operator.setNodeNameList(nodeNameList);
        return operator;
    }

    private String[] parsePrivilege(IoTDBSqlParser.PrivilegesContext ctx) {
        List privilegeList = ctx.privilegeValue();
        ArrayList<String> privileges = new ArrayList<String>();
        for (IoTDBSqlParser.PrivilegeValueContext privilegeValue : privilegeList) {
            privileges.add(privilegeValue.getText());
        }
        return privileges.toArray(new String[0]);
    }

    public Operator visitMerge(IoTDBSqlParser.MergeContext ctx) {
        return new MergeOperator(82);
    }

    public Operator visitFullMerge(IoTDBSqlParser.FullMergeContext ctx) {
        return new MergeOperator(83);
    }

    public Operator visitFlush(IoTDBSqlParser.FlushContext ctx) {
        FlushOperator flushOperator = new FlushOperator(81);
        if (ctx.BOOLEAN_LITERAL() != null) {
            flushOperator.setSeq(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        }
        if (ctx.prefixPath(0) != null) {
            ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
            flushOperator.setStorageGroupList(storageGroups);
        }
        return flushOperator;
    }

    public Operator visitClearCache(IoTDBSqlParser.ClearCacheContext ctx) {
        return new ClearCacheOperator(84);
    }

    public Operator visitSettle(IoTDBSqlParser.SettleContext ctx) {
        SettleOperator settleOperator = new SettleOperator(111);
        if (ctx.prefixPath() != null) {
            PartialPath sgPath = this.parsePrefixPath(ctx.prefixPath());
            settleOperator.setSgPath(sgPath);
            settleOperator.setIsSgPath(true);
        } else {
            String tsFilePath = this.parseStringLiteral(ctx.tsFilePath.getText());
            settleOperator.setTsFilePath(tsFilePath);
            settleOperator.setIsSgPath(false);
        }
        return settleOperator;
    }

    public Operator visitSetSystemStatus(IoTDBSqlParser.SetSystemStatusContext ctx) {
        if (ctx.RUNNING() != null) {
            return new SetSystemModeOperator(110, NodeStatus.Running);
        }
        if (ctx.READONLY() != null) {
            return new SetSystemModeOperator(110, NodeStatus.ReadOnly);
        }
        if (ctx.ERROR() != null) {
            return new SetSystemModeOperator(110, NodeStatus.Error);
        }
        throw new RuntimeException("Unknown system status in set system command.");
    }

    public Operator visitShowVersion(IoTDBSqlParser.ShowVersionContext ctx) {
        return new ShowOperator(72);
    }

    public Operator visitShowFlushInfo(IoTDBSqlParser.ShowFlushInfoContext ctx) {
        return new ShowOperator(67);
    }

    public Operator visitShowLockInfo(IoTDBSqlParser.ShowLockInfoContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowLockInfoOperator(105, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowLockInfoOperator(105, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowQueryResource(IoTDBSqlParser.ShowQueryResourceContext ctx) {
        return new ShowQueryResourceOperate(123);
    }

    public Operator visitShowQueryProcesslist(IoTDBSqlParser.ShowQueryProcesslistContext ctx) {
        return new ShowOperator(97);
    }

    public Operator visitKillQuery(IoTDBSqlParser.KillQueryContext ctx) {
        KillQueryOperator killQueryOperator = new KillQueryOperator(98);
        if (ctx.INTEGER_LITERAL() != null) {
            killQueryOperator.setQueryId(Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        }
        return killQueryOperator;
    }

    public Operator visitGrantWatermarkEmbedding(IoTDBSqlParser.GrantWatermarkEmbeddingContext ctx) {
        List usernameList = ctx.usernameWithRoot();
        ArrayList<String> users = new ArrayList<String>();
        for (IoTDBSqlParser.UsernameWithRootContext username : usernameList) {
            users.add(this.parseIdentifier(username.getText()));
        }
        return new DataAuthOperator(34, users);
    }

    public Operator visitRevokeWatermarkEmbedding(IoTDBSqlParser.RevokeWatermarkEmbeddingContext ctx) {
        List usernameList = ctx.usernameWithRoot();
        ArrayList<String> users = new ArrayList<String>();
        for (IoTDBSqlParser.UsernameWithRootContext username : usernameList) {
            users.add(this.parseIdentifier(username.getText()));
        }
        return new DataAuthOperator(35, users);
    }

    public Operator visitLoadConfiguration(IoTDBSqlParser.LoadConfigurationContext ctx) {
        if (ctx.GLOBAL() != null) {
            return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.GLOBAL);
        }
        return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.LOCAL);
    }

    public Operator visitLoadTimeseries(IoTDBSqlParser.LoadTimeseriesContext ctx) {
        if (ctx.prefixPath().nodeName().size() < 3) {
            throw new SQLParserException("data load command: child count < 3\n");
        }
        String csvPath = ctx.fileName.getText();
        StringContainer sc = new StringContainer(".");
        List nodeNames = ctx.prefixPath().nodeName();
        sc.addTail(new String[]{ctx.prefixPath().ROOT().getText()});
        for (IoTDBSqlParser.NodeNameContext nodeName : nodeNames) {
            sc.addTail(new String[]{this.parseNodeName(nodeName)});
        }
        return new LoadDataOperator(45, this.parseFilePath(csvPath), sc.toString());
    }

    public Operator visitLoadFile(IoTDBSqlParser.LoadFileContext ctx) {
        LoadFilesOperator loadFilesOperator = new LoadFilesOperator(new File(this.parseFilePath(ctx.fileName.getText())), true, IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel(), true);
        if (ctx.loadFilesClause() != null) {
            this.parseLoadFiles(loadFilesOperator, ctx.loadFilesClause());
        }
        return loadFilesOperator;
    }

    private void parseLoadFiles(LoadFilesOperator operator, IoTDBSqlParser.LoadFilesClauseContext ctx) {
        if (ctx.AUTOREGISTER() != null) {
            operator.setAutoCreateSchema(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        } else if (ctx.SGLEVEL() != null) {
            operator.setSgLevel(Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        } else if (ctx.VERIFY() != null) {
            operator.setVerifyMetadata(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        } else {
            throw new SQLParserException(String.format("load tsfile format %s error, please input AUTOREGISTER | SGLEVEL | VERIFY.", ctx.getText()));
        }
        if (ctx.loadFilesClause() != null) {
            this.parseLoadFiles(operator, ctx.loadFilesClause());
        }
    }

    public Operator visitRemoveFile(IoTDBSqlParser.RemoveFileContext ctx) {
        return new RemoveFileOperator(new File(this.parseFilePath(ctx.fileName.getText())));
    }

    public Operator visitUnloadFile(IoTDBSqlParser.UnloadFileContext ctx) {
        return new UnloadFileOperator(new File(this.parseFilePath(ctx.srcFileName.getText())), new File(this.parseFilePath(ctx.dstFileDir.getText())));
    }

    public Operator visitCreatePipeSink(IoTDBSqlParser.CreatePipeSinkContext ctx) {
        CreatePipeSinkOperator operator = new CreatePipeSinkOperator(this.parseIdentifier(ctx.pipeSinkName.getText()), this.parseIdentifier(ctx.pipeSinkType.getText()));
        if (ctx.syncAttributeClauses() != null) {
            operator.setPipeSinkAttributes(this.parseSyncAttributeClauses(ctx.syncAttributeClauses()));
        }
        return operator;
    }

    private Map<String, String> parseSyncAttributeClauses(IoTDBSqlParser.SyncAttributeClausesContext ctx) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (IoTDBSqlParser.AttributePairContext attributePair : ctx.attributePair()) {
            attributes.put(this.parseAttributeKey(attributePair.attributeKey()), this.parseAttributeValue(attributePair.attributeValue()));
        }
        return attributes;
    }

    public Operator visitDropPipeSink(IoTDBSqlParser.DropPipeSinkContext ctx) {
        DropPipeSinkOperator operator = new DropPipeSinkOperator(StringEscapeUtils.unescapeJava((String)ctx.pipeSinkName.getText()));
        return operator;
    }

    public Operator visitShowPipeSink(IoTDBSqlParser.ShowPipeSinkContext ctx) {
        ShowPipeSinkOperator operator = new ShowPipeSinkOperator();
        if (ctx.pipeSinkName != null) {
            operator.setPipeSinkName(StringEscapeUtils.unescapeJava((String)ctx.pipeSinkName.getText()));
        }
        return operator;
    }

    public Operator visitShowPipeSinkType(IoTDBSqlParser.ShowPipeSinkTypeContext ctx) {
        ShowPipeSinkTypeOperator operator = new ShowPipeSinkTypeOperator();
        return operator;
    }

    public Operator visitCreatePipe(IoTDBSqlParser.CreatePipeContext ctx) throws SQLParserException {
        CreatePipeOperator operator = new CreatePipeOperator(StringEscapeUtils.unescapeJava((String)ctx.pipeName.getText()), StringEscapeUtils.unescapeJava((String)ctx.pipeSinkName.getText()));
        if (ctx.selectStatement() != null) {
            this.parseSelectStatementForPipe(ctx.selectStatement(), operator);
        }
        if (ctx.syncAttributeClauses() != null) {
            operator.setPipeAttributes(this.parseSyncAttributeClauses(ctx.syncAttributeClauses()));
        }
        return operator;
    }

    public Operator visitShowPipe(IoTDBSqlParser.ShowPipeContext ctx) {
        ShowPipeOperator operator = new ShowPipeOperator();
        if (ctx.pipeName != null) {
            operator.setPipeName(StringEscapeUtils.unescapeJava((String)ctx.pipeName.getText()));
        }
        return operator;
    }

    public Operator visitStopPipe(IoTDBSqlParser.StopPipeContext ctx) {
        return new StopPipeOperator(StringEscapeUtils.unescapeJava((String)ctx.pipeName.getText()));
    }

    public Operator visitStartPipe(IoTDBSqlParser.StartPipeContext ctx) {
        return new StartPipeOperator(StringEscapeUtils.unescapeJava((String)ctx.pipeName.getText()));
    }

    public Operator visitDropPipe(IoTDBSqlParser.DropPipeContext ctx) {
        return new DropPipeOperator(StringEscapeUtils.unescapeJava((String)ctx.pipeName.getText()));
    }

    private void parseSelectStatementForPipe(IoTDBSqlParser.SelectStatementContext ctx, CreatePipeOperator operator) throws SQLParserException {
        if (ctx.TRACING() != null || ctx.intoClause() != null || ctx.specialClause() != null) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.SelectClauseContext selectCtx = ctx.selectClause();
        if (selectCtx.LAST() != null || selectCtx.resultColumn().size() != 1) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.ResultColumnContext resultColumnCtx = selectCtx.resultColumn(0);
        if (resultColumnCtx.AS() != null || !"**".equals(resultColumnCtx.expression().getText())) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.FromClauseContext fromCtx = ctx.fromClause();
        if (fromCtx.prefixPath().size() != 1 || !"root".equals(fromCtx.prefixPath(0).getText())) {
            throw new SQLParserException("Not support for this sql in pipe.");
        }
        IoTDBSqlParser.WhereClauseContext whereCtx = ctx.whereClause();
        if (whereCtx != null) {
            Expression predicate = this.parseExpression(whereCtx.expression(), whereCtx.expression().OPERATOR_NOT() == null);
            if (!(predicate instanceof GreaterThanExpression) && !(predicate instanceof GreaterEqualExpression)) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            Expression left = ((BinaryExpression)predicate).getLeftExpression();
            Expression right = ((BinaryExpression)predicate).getRightExpression();
            if (!SQLConstant.isReservedPath(this.parsePathFromExpression(left))) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            if (!(right instanceof ConstantOperand)) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            if (((ConstantOperand)right).getDataType() != TSDataType.INT64) {
                throw new SQLParserException("Not support for this sql in pipe.");
            }
            long startTime = Long.parseLong(((ConstantOperand)right).getValueString());
            operator.setStartTime(startTime);
        }
    }

    private PartialPath parseFullPath(IoTDBSqlParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = this.parseNodeNameWithoutWildCard(nodeNameWithoutStar);
        }
        return new PartialPath(path);
    }

    private PartialPath parseFullPathInSelectInto(IoTDBSqlParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = this.parseNodeNameWithoutWildCardInSelectInto(nodeNameWithoutStar);
        }
        return new PartialPath(path);
    }

    private PartialPath parseFullPathInExpression(IoTDBSqlParser.FullPathInExpressionContext ctx, boolean inWithoutNull) throws SQLParserException {
        String[] path;
        List nodeNames = ctx.nodeName();
        int size = nodeNames.size();
        if (ctx.ROOT() != null && !inWithoutNull) {
            throw new SQLParserException("Path can not start with root in select clause.");
        }
        if (ctx.ROOT() != null) {
            path = new String[size + 1];
            path[0] = ctx.ROOT().getText();
            for (int i = 0; i < nodeNames.size(); ++i) {
                path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
            }
        } else {
            path = new String[size];
            for (int i = 0; i < nodeNames.size(); ++i) {
                path[i] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
            }
        }
        return new PartialPath(path);
    }

    private PartialPath parsePrefixPath(IoTDBSqlParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private PartialPath parseSuffixPath(IoTDBSqlParser.SuffixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private PartialPath convertConstantToPath(String src) throws IllegalPathException {
        return new PartialPath(src);
    }

    private String parseNodeName(IoTDBSqlParser.NodeNameContext ctx) {
        return this.parseNodeString(ctx.getText());
    }

    private String parseNodeNameWithoutWildCard(IoTDBSqlParser.NodeNameWithoutWildcardContext ctx) {
        return this.parseNodeString(ctx.getText());
    }

    private String parseNodeNameWithoutWildCardInSelectInto(IoTDBSqlParser.NodeNameWithoutWildcardContext ctx) {
        String nodeName = ctx.getText();
        if (nodeName.equals("*") || nodeName.equals("**")) {
            return nodeName;
        }
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            String unWrapped = nodeName.substring(1, nodeName.length() - 1);
            if (StringUtils.isNumeric((CharSequence)unWrapped) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(unWrapped).matches()) {
                return nodeName;
            }
            return unWrapped;
        }
        if (!NODE_NAME_IN_SELECT_INTO_PATTERN.matcher(nodeName).matches()) {
            throw new SQLParserException(String.format("%s is illegal, unquoted node name in select into clause can only consist of digits, characters, $, { and }", nodeName));
        }
        return nodeName;
    }

    private String parseNodeString(String nodeName) {
        if (nodeName.equals("*") || nodeName.equals("**")) {
            return nodeName;
        }
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            String unWrapped = nodeName.substring(1, nodeName.length() - 1);
            if (PathUtils.isRealNumber((String)unWrapped) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(unWrapped).matches()) {
                return nodeName;
            }
            return unWrapped;
        }
        this.checkNodeName(nodeName);
        return nodeName;
    }

    private void checkNodeName(String src) {
        if (!TsFileConstant.NODE_NAME_PATTERN.matcher(src).matches()) {
            throw new SQLParserException(String.format("%s is illegal, unquoted node name can only consist of digits, characters and underscore, or start or end with wildcard", src));
        }
    }

    private void checkIdentifier(String src) {
        if (!TsFileConstant.IDENTIFIER_PATTERN.matcher(src).matches()) {
            throw new SQLParserException(String.format("%s is illegal, unquoted identifier can only consist of digits, characters and underscore", src));
        }
    }

    private String parseAlias(IoTDBSqlParser.AliasContext ctx) {
        String alias = ctx.constant() != null ? this.parseStringLiteral(ctx.constant().getText()) : this.parseIdentifier(ctx.identifier().getText());
        return alias;
    }

    public long parseDateFormat(String timestampStr) throws SQLParserException {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return DatetimeUtils.currentTime();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    public long parseDateFormat(String timestampStr, long currentTime) throws SQLParserException {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return currentTime;
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx) {
        long time = this.parseDateFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx, long currentTime) {
        long time = this.parseDateFormat(ctx.getChild(0).getText(), currentTime);
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private long parseTimeValue(IoTDBSqlParser.TimeValueContext ctx, long currentTime) {
        if (ctx.INTEGER_LITERAL() != null) {
            if (ctx.MINUS() != null) {
                return -Long.parseLong(ctx.INTEGER_LITERAL().getText());
            }
            return Long.parseLong(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.dateExpression() != null) {
            return this.parseDateExpression(ctx.dateExpression(), currentTime);
        }
        return this.parseDateFormat(ctx.datetimeLiteral().getText(), currentTime);
    }

    private Expression parseExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull, boolean isQueryFilter) {
        if (context.unaryInBracket != null) {
            return this.parseExpression(context.unaryInBracket, inWithoutNull);
        }
        if (context.expressionAfterUnaryOperator != null) {
            if (context.MINUS() != null) {
                return new NegationExpression(this.parseExpression(context.expressionAfterUnaryOperator, inWithoutNull));
            }
            if (context.OPERATOR_NOT() != null) {
                return new LogicNotExpression(this.parseExpression(context.expressionAfterUnaryOperator, inWithoutNull));
            }
            return this.parseExpression(context.expressionAfterUnaryOperator, inWithoutNull);
        }
        if (context.leftExpression != null && context.rightExpression != null) {
            Expression leftExpression = this.parseExpression(context.leftExpression, inWithoutNull);
            Expression rightExpression = this.parseExpression(context.rightExpression, inWithoutNull);
            if (context.STAR() != null) {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            if (context.DIV() != null) {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            if (context.MOD() != null) {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            if (context.PLUS() != null) {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            if (context.MINUS() != null) {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GT() != null) {
                return new GreaterThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GTE() != null) {
                return new GreaterEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LT() != null) {
                return new LessThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LTE() != null) {
                return new LessEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_DEQ() != null || context.OPERATOR_SEQ() != null) {
                return new EqualToExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_NEQ() != null) {
                return new NonEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_AND() != null) {
                return new LogicAndExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_OR() != null) {
                return new LogicOrExpression(leftExpression, rightExpression);
            }
            throw new UnsupportedOperationException();
        }
        if (context.unaryBeforeRegularOrLikeExpression != null) {
            if (context.REGEXP() != null) {
                return this.parseRegularExpression(context, inWithoutNull, isQueryFilter);
            }
            if (context.LIKE() != null) {
                return this.parseLikeExpression(context, inWithoutNull, isQueryFilter);
            }
            throw new UnsupportedOperationException();
        }
        if (context.firstExpression != null && context.secondExpression != null && context.thirdExpression != null) {
            Expression firstExpression = this.parseExpression(context.firstExpression, inWithoutNull);
            Expression secondExpression = this.parseExpression(context.secondExpression, inWithoutNull);
            Expression thirdExpression = this.parseExpression(context.thirdExpression, inWithoutNull);
            if (context.OPERATOR_BETWEEN() != null) {
                return new BetweenExpression(firstExpression, secondExpression, thirdExpression, context.OPERATOR_NOT() != null);
            }
        }
        if (context.unaryBeforeInExpression != null) {
            return this.parseInExpression(context, inWithoutNull);
        }
        if (context.functionName() != null) {
            return this.parseFunctionExpression(context, inWithoutNull);
        }
        if (context.fullPathInExpression() != null) {
            return new TimeSeriesOperand(this.parseFullPathInExpression(context.fullPathInExpression(), inWithoutNull));
        }
        if (context.time != null) {
            return new TimestampOperand();
        }
        if (context.constant() != null && !context.constant().isEmpty()) {
            return this.parseConstantOperand(context.constant(0));
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        return this.parseExpression(context, inWithoutNull, false);
    }

    private Expression parseFunctionExpression(IoTDBSqlParser.ExpressionContext functionClause, boolean inWithoutNull) {
        FunctionExpression functionExpression = new FunctionExpression(this.parseIdentifier(functionClause.functionName().getText()));
        boolean hasNonPureConstantSubExpression = false;
        for (IoTDBSqlParser.ExpressionContext expression : functionClause.expression()) {
            Expression subexpression = this.parseExpression(expression, inWithoutNull);
            if (!subexpression.isConstantOperand()) {
                hasNonPureConstantSubExpression = true;
            }
            if (subexpression instanceof EqualToExpression && ((EqualToExpression)subexpression).getLeftExpression().isConstantOperand() && ((EqualToExpression)subexpression).getRightExpression().isConstantOperand()) {
                functionExpression.addAttribute(((ConstantOperand)((EqualToExpression)subexpression).getLeftExpression()).getValueString(), ((ConstantOperand)((EqualToExpression)subexpression).getRightExpression()).getValueString());
                continue;
            }
            functionExpression.addExpression(subexpression);
        }
        if (!hasNonPureConstantSubExpression) {
            throw new SQLParserException("Invalid function expression, all the arguments are constant operands: " + functionClause.getText());
        }
        return functionExpression;
    }

    private Expression parseRegularExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull, boolean isQueryFilter) {
        if (isQueryFilter) {
            return new RegularExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, inWithoutNull), context.STRING_LITERAL().getText());
        }
        return new RegularExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, inWithoutNull), this.parseStringLiteralInLikeOrRegular(context.STRING_LITERAL().getText()));
    }

    private Expression parseLikeExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull, boolean isQueryFilter) {
        if (isQueryFilter) {
            return new LikeExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, inWithoutNull), context.STRING_LITERAL().getText());
        }
        return new LikeExpression(this.parseExpression(context.unaryBeforeRegularOrLikeExpression, inWithoutNull), this.parseStringLiteralInLikeOrRegular(context.STRING_LITERAL().getText()));
    }

    private Expression parseInExpression(IoTDBSqlParser.ExpressionContext context, boolean inWithoutNull) {
        Expression childExpression = this.parseExpression(context.unaryBeforeInExpression, inWithoutNull);
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (IoTDBSqlParser.ConstantContext constantContext : context.constant()) {
            values.add(this.parseConstant(constantContext));
        }
        return new InExpression(childExpression, context.OPERATOR_NOT() != null, values);
    }

    private String parseConstant(IoTDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.BOOLEAN_LITERAL() != null || constantContext.INTEGER_LITERAL() != null || constantContext.realLiteral() != null) {
            return text;
        }
        if (constantContext.STRING_LITERAL() != null) {
            return this.parseStringLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return String.valueOf(this.parseDateExpression(constantContext.dateExpression()));
        }
        throw new IllegalArgumentException("Unsupported constant operand: " + text);
    }

    public void parseSelectClause(IoTDBSqlParser.SelectClauseContext ctx) {
        SelectComponent selectComponent = new SelectComponent(this.zoneId);
        if (ctx.LAST() != null) {
            this.queryOp = new LastQueryOperator(this.queryOp);
        }
        HashSet<String> aliasSet = new HashSet<String>();
        for (IoTDBSqlParser.ResultColumnContext resultColumnContext : ctx.resultColumn()) {
            ResultColumn resultColumn = this.parseResultColumn(resultColumnContext);
            if (resultColumn.hasAlias()) {
                aliasSet.add(resultColumn.getAlias());
            }
            selectComponent.addResultColumn(resultColumn);
        }
        if (!this.hasDecidedQueryType()) {
            if (selectComponent.hasUserDefinedAggregationFunction()) {
                this.queryOp = new UDAFQueryOperator(new AggregationQueryOperator(this.queryOp));
            } else if (selectComponent.hasPlainAggregationFunction()) {
                this.queryOp = new AggregationQueryOperator(this.queryOp);
            } else if (selectComponent.hasTimeSeriesGeneratingFunction()) {
                this.queryOp = new UDTFQueryOperator(this.queryOp);
            }
        } else if (selectComponent.hasUserDefinedAggregationFunction()) {
            this.queryOp = new UDAFQueryOperator((AggregationQueryOperator)this.queryOp);
        }
        this.queryOp.setAliasSet(aliasSet);
        this.queryOp.setSelectComponent(selectComponent);
    }

    private ResultColumn parseResultColumn(IoTDBSqlParser.ResultColumnContext resultColumnContext) {
        Expression expression = this.parseExpression(resultColumnContext.expression(), false);
        if (expression.isConstantOperand()) {
            throw new SQLParserException("Constant operand is not allowed: " + expression);
        }
        String alias = null;
        if (resultColumnContext.AS() != null) {
            alias = this.parseAlias(resultColumnContext.alias());
        }
        return new ResultColumn(expression, alias);
    }

    public void parseFromClause(IoTDBSqlParser.FromClauseContext ctx) {
        FromComponent fromComponent = new FromComponent();
        List prefixFromPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            PartialPath path = this.parsePrefixPath(prefixFromPath);
            fromComponent.addPrefixTablePath(path);
        }
        this.queryOp.setFromComponent(fromComponent);
    }

    public WhereComponent parseWhereClause(IoTDBSqlParser.WhereClauseContext ctx) {
        Expression predicate = this.parseExpression(ctx.expression(), ctx.expression().OPERATOR_NOT() == null, true);
        return new WhereComponent(this.convertExpressionToFilter(predicate));
    }

    private FilterOperator convertExpressionToFilter(Expression predicate) {
        FilterOperator filter;
        if (predicate instanceof LogicAndExpression) {
            filter = new FilterOperator(FilterConstant.FilterType.KW_AND);
            filter.addChildOperator(this.convertExpressionToFilter(((BinaryExpression)predicate).getLeftExpression()));
            filter.addChildOperator(this.convertExpressionToFilter(((BinaryExpression)predicate).getRightExpression()));
        } else if (predicate instanceof LogicOrExpression) {
            filter = new FilterOperator(FilterConstant.FilterType.KW_OR);
            filter.addChildOperator(this.convertExpressionToFilter(((BinaryExpression)predicate).getLeftExpression()));
            filter.addChildOperator(this.convertExpressionToFilter(((BinaryExpression)predicate).getRightExpression()));
        } else if (predicate instanceof LogicNotExpression) {
            filter = new FilterOperator(FilterConstant.FilterType.KW_NOT);
            filter.addChildOperator(this.convertExpressionToFilter(((LogicNotExpression)predicate).getExpression()));
        } else if (predicate instanceof LikeExpression) {
            filter = new LikeOperator(FilterConstant.FilterType.LIKE, this.parsePathFromExpression(((LikeExpression)predicate).getExpression()), ((LikeExpression)predicate).getPatternString());
        } else if (predicate instanceof RegularExpression) {
            filter = new RegexpOperator(FilterConstant.FilterType.REGEXP, this.parsePathFromExpression(((RegularExpression)predicate).getExpression()), ((RegularExpression)predicate).getPatternString());
        } else if (predicate instanceof BetweenExpression) {
            filter = new FilterOperator(FilterConstant.FilterType.KW_AND);
            PartialPath partialPath = this.parsePathFromExpression(((TernaryExpression)predicate).getFirstExpression());
            filter.addChildOperator(new BasicFunctionOperator(FilterConstant.FilterType.GREATERTHANOREQUALTO, partialPath, this.parseValueFromExpression(((TernaryExpression)predicate).getSecondExpression())));
            filter.addChildOperator(new BasicFunctionOperator(FilterConstant.FilterType.LESSTHANOREQUALTO, partialPath, this.parseValueFromExpression(((TernaryExpression)predicate).getThirdExpression())));
            if (((BetweenExpression)predicate).isNotBetween()) {
                FilterOperator temp = new FilterOperator(FilterConstant.FilterType.KW_NOT);
                temp.addChildOperator(filter);
                filter = temp;
            }
        } else if (predicate instanceof InExpression) {
            filter = new InOperator(FilterConstant.FilterType.IN, this.parsePathFromExpression(((InExpression)predicate).getExpression()), ((InExpression)predicate).isNotIn(), ((InExpression)predicate).getValues());
        } else if (FilterConstant.ExpressionToFilterType.containsKey((Object)predicate.getExpressionType())) {
            filter = new BasicFunctionOperator(FilterConstant.ExpressionToFilterType.get((Object)predicate.getExpressionType()), this.parsePathFromExpression(((BinaryExpression)predicate).getLeftExpression()), this.parseValueFromExpression(((BinaryExpression)predicate).getRightExpression()));
        } else {
            throw new IllegalArgumentException("Unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
        }
        return filter;
    }

    private PartialPath parsePathFromExpression(Expression expression) {
        if (expression instanceof TimeSeriesOperand) {
            return ((TimeSeriesOperand)expression).getPath();
        }
        if (expression instanceof TimestampOperand) {
            return SQLConstant.TIME_PATH;
        }
        throw new IllegalArgumentException("Unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    private String parseValueFromExpression(Expression expression) {
        if (!(expression instanceof ConstantOperand)) {
            throw new IllegalArgumentException("Unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
        }
        return ((ConstantOperand)expression).getValueString();
    }

    public void parseTagClause(IoTDBSqlParser.TagClauseContext ctx, Operator operator) {
        Map<String, String> tags = this.extractMap(ctx.attributePair(), ctx.attributePair(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setTags(tags);
        } else if (operator instanceof CreateAlignedTimeSeriesOperator) {
            ((CreateAlignedTimeSeriesOperator)operator).addTagsList(tags);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setTagsMap(tags);
        }
    }

    public void parseAttributeClause(IoTDBSqlParser.AttributeClauseContext ctx, Operator operator) {
        Map<String, String> attributes = this.extractMap(ctx.attributePair(), ctx.attributePair(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setAttributes(attributes);
        } else if (operator instanceof CreateAlignedTimeSeriesOperator) {
            ((CreateAlignedTimeSeriesOperator)operator).addAttributesList(attributes);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setAttributesMap(attributes);
        }
    }

    private void parseLimitClause(IoTDBSqlParser.LimitClauseContext ctx, Operator operator) {
        int limit;
        try {
            limit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. LIMIT <N>: N should be Int32.");
        }
        if (limit <= 0) {
            throw new SQLParserException("LIMIT <N>: N should be greater than 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setLimit(limit);
        } else if (operator instanceof ShowDevicesOperator) {
            ((ShowDevicesOperator)operator).setLimit(limit);
        } else {
            SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
            if (specialClauseComponent == null) {
                specialClauseComponent = new SpecialClauseComponent();
            }
            specialClauseComponent.setRowLimit(limit);
            this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        }
        if (ctx.offsetClause() != null) {
            this.parseOffsetClause(ctx.offsetClause(), operator);
        }
    }

    private void parseOffsetClause(IoTDBSqlParser.OffsetClauseContext ctx, Operator operator) {
        int offset;
        try {
            offset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int32.");
        }
        if (offset < 0) {
            throw new SQLParserException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setOffset(offset);
        } else if (operator instanceof ShowDevicesOperator) {
            ((ShowDevicesOperator)operator).setOffset(offset);
        } else {
            SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
            if (specialClauseComponent == null) {
                specialClauseComponent = new SpecialClauseComponent();
            }
            specialClauseComponent.setRowOffset(offset);
            this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        }
    }

    private void parseSlimitClause(IoTDBSqlParser.SlimitClauseContext ctx) {
        int slimit;
        try {
            slimit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SQLParserException("SLIMIT <SN>: SN should be greater than 0.");
        }
        SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        specialClauseComponent.setSeriesLimit(slimit);
        this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        if (ctx.soffsetClause() != null) {
            this.parseSoffsetClause(ctx.soffsetClause(), this.queryOp);
        }
    }

    public void parseSoffsetClause(IoTDBSqlParser.SoffsetClauseContext ctx, QueryOperator queryOp) {
        int soffset;
        try {
            soffset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SQLParserException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        SpecialClauseComponent specialClauseComponent = queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        specialClauseComponent.setSeriesOffset(soffset);
        queryOp.setSpecialClauseComponent(specialClauseComponent);
    }

    private boolean hasDecidedQueryType() {
        return this.queryOp instanceof GroupByQueryOperator || this.queryOp instanceof FillQueryOperator || this.queryOp instanceof LastQueryOperator || this.queryOp instanceof AggregationQueryOperator || this.queryOp instanceof UDTFQueryOperator || this.queryOp instanceof UDAFQueryOperator;
    }

    private String parseStringLiteral(String src) {
        if (2 <= src.length()) {
            String unWrappedString = src.substring(1, src.length() - 1).replace("\\\"", "\"").replace("\\'", "'");
            if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
                String replaced = unWrappedString.replace("\"\"", "\"");
                return replaced.length() == 0 ? "" : replaced;
            }
            if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
                String replaced = unWrappedString.replace("''", "'");
                return replaced.length() == 0 ? "" : replaced;
            }
        }
        return src;
    }

    private String parseStringLiteralInInsertValue(String src) {
        if (2 <= src.length() && (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"' || src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'')) {
            return "'" + this.parseStringLiteral(src) + "'";
        }
        return src;
    }

    private String parseStringLiteralInLikeOrRegular(String src) {
        if (2 <= src.length()) {
            String unescapeString = StringEscapeUtils.unescapeJava((String)src.substring(1, src.length() - 1));
            if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
                String replaced = unescapeString.replace("\"\"", "\"");
                return replaced.length() == 0 ? "" : replaced;
            }
            if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
                String replaced = unescapeString.replace("''", "'");
                return replaced.length() == 0 ? "" : replaced;
            }
        }
        return src;
    }

    private String parseIdentifier(String src) {
        if (src.startsWith("`") && src.endsWith("`")) {
            return src.substring(1, src.length() - 1).replace("``", "`");
        }
        this.checkIdentifier(src);
        return src;
    }

    public String parseFilePath(String src) {
        return src.substring(1, src.length() - 1);
    }

    private long parseTimeUnitOrSlidingStep(String durationStr, boolean isParsingTimeUnit, GroupByClauseComponent groupByComponent) {
        if (durationStr.toLowerCase().contains("mo")) {
            if (isParsingTimeUnit) {
                groupByComponent.setIntervalByMonth(true);
            } else {
                groupByComponent.setSlidingStepByMonth(true);
            }
        }
        return DatetimeUtils.convertDurationStrToLong(durationStr);
    }

    private Expression parseConstantOperand(IoTDBSqlParser.ConstantContext constantContext) {
        try {
            String text = constantContext.getText();
            if (this.clientVersion.equals((Object)IoTDBConstant.ClientVersion.V_0_13)) {
                if (constantContext.BOOLEAN_LITERAL() != null) {
                    return new ConstantOperand(TSDataType.BOOLEAN, text);
                }
                if (constantContext.STRING_LITERAL() != null) {
                    return new ConstantOperand(TSDataType.TEXT, this.parseStringLiteral(text));
                }
                if (constantContext.INTEGER_LITERAL() != null) {
                    return new ConstantOperand(TSDataType.INT64, text);
                }
                if (constantContext.realLiteral() != null) {
                    return this.parseRealLiteral(text);
                }
                if (constantContext.dateExpression() != null) {
                    return new ConstantOperand(TSDataType.INT64, String.valueOf(this.parseDateExpression(constantContext.dateExpression())));
                }
                throw new SQLParserException("Unsupported constant operand: " + text);
            }
            if (this.clientVersion.equals((Object)IoTDBConstant.ClientVersion.V_0_12)) {
                return new TimeSeriesOperand(this.convertConstantToPath(text));
            }
            throw new UnsupportedOperationException();
        }
        catch (IllegalPathException e) {
            throw new SQLParserException(e.getMessage());
        }
    }

    private Expression parseRealLiteral(String value) {
        return new ConstantOperand(CONFIG.getFloatingStringInferType().equals((Object)TSDataType.DOUBLE) ? TSDataType.DOUBLE : TSDataType.FLOAT, value);
    }

    private void setMap(IoTDBSqlParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List tagsList = ctx.attributePair();
        if (ctx.attributePair(0) != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : tagsList) {
                String value = this.parseAttributeValue(attributePair.attributeValue());
                alterMap.put(this.parseAttributeKey(attributePair.attributeKey()), value);
            }
        }
    }

    private Map<String, String> extractMap(List<IoTDBSqlParser.AttributePairContext> attributePair2, IoTDBSqlParser.AttributePairContext attributePair3) {
        HashMap<String, String> tags = new HashMap<String, String>(attributePair2.size());
        if (attributePair3 != null) {
            for (IoTDBSqlParser.AttributePairContext attributePair : attributePair2) {
                tags.put(this.parseAttributeKey(attributePair.attributeKey()), this.parseAttributeValue(attributePair.attributeValue()));
            }
        }
        return tags;
    }

    private String parseAttributeKey(IoTDBSqlParser.AttributeKeyContext ctx) {
        if (ctx.constant() != null) {
            return this.parseStringLiteral(ctx.getText());
        }
        return this.parseIdentifier(ctx.getText());
    }

    private String parseAttributeValue(IoTDBSqlParser.AttributeValueContext ctx) {
        if (ctx.constant() != null) {
            return this.parseStringLiteral(ctx.getText());
        }
        return this.parseIdentifier(ctx.getText());
    }

    private Pair<Long, Long> calcOperatorInterval(FilterOperator filterOperator) {
        if (filterOperator.getSinglePath() != null && !"time".equals(filterOperator.getSinglePath().getMeasurement())) {
            throw new SemanticException(DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG);
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        switch (filterOperator.getFilterType()) {
            case LESSTHAN: {
                return new Pair((Object)Long.MIN_VALUE, (Object)(time - 1L));
            }
            case LESSTHANOREQUALTO: {
                return new Pair((Object)Long.MIN_VALUE, (Object)time);
            }
            case GREATERTHAN: {
                return new Pair((Object)(time + 1L), (Object)Long.MAX_VALUE);
            }
            case GREATERTHANOREQUALTO: {
                return new Pair((Object)time, (Object)Long.MAX_VALUE);
            }
            case EQUAL: {
                return new Pair((Object)time, (Object)time);
            }
        }
        throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
    }
}

