/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.basic;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.tracing.TracingManager;
import org.apache.iotdb.db.service.basic.QueryFrequencyRecorder;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProvider.class);
    public static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"IoTDB_AUDIT_LOGGER");
    public static final Logger SLOW_SQL_LOGGER = LoggerFactory.getLogger((String)"SLOW_SQL");
    public static final TSProtocolVersion CURRENT_RPC_VERSION = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    public static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    public static SessionManager SESSION_MANAGER = SessionManager.getInstance();
    public static final QueryTimeManager QUERY_TIME_MANAGER = QueryTimeManager.getInstance();
    public static final TracingManager TRACING_MANAGER = TracingManager.getInstance();
    public static final QueryFrequencyRecorder QUERY_FREQUENCY_RECORDER = new QueryFrequencyRecorder(CONFIG);
    private final Planner planner = new Planner();
    protected final IPlanExecutor executor;

    public Planner getPlanner() {
        return this.planner;
    }

    public IPlanExecutor getExecutor() {
        return this.executor;
    }

    public ServiceProvider(PlanExecutor executor) throws QueryProcessException {
        this.executor = executor;
    }

    public abstract QueryContext genQueryContext(long var1, boolean var3, long var4, String var6, long var7);

    public abstract boolean executeNonQuery(PhysicalPlan var1) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException;

    public QueryDataSet createQueryDataSet(QueryContext context, PhysicalPlan physicalPlan, int fetchSize) throws QueryProcessException, QueryFilterOptimizationException, StorageEngineException, IOException, MetadataException, SQLException, TException, InterruptedException {
        QueryDataSet queryDataSet = this.executor.processQuery(physicalPlan, context);
        queryDataSet.setFetchSize(fetchSize);
        SESSION_MANAGER.setDataset(context.getQueryId(), queryDataSet);
        return queryDataSet;
    }
}

