/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.sync.SyncConstant;
import org.apache.iotdb.commons.sync.SyncPathUtil;
import org.apache.iotdb.confignode.rpc.thrift.TPipeInfo;
import org.apache.iotdb.db.exception.sync.PipeException;
import org.apache.iotdb.db.exception.sync.PipeSinkException;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPipePlan;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.sync.common.ISyncInfoFetcher;
import org.apache.iotdb.db.sync.common.LocalSyncInfoFetcher;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.externalpipe.ExternalPipeStatus;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.sync.sender.pipe.ExternalPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.IoTDBPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeInfo;
import org.apache.iotdb.db.sync.sender.pipe.PipeMessage;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.db.sync.transport.client.SenderManager;
import org.apache.iotdb.db.sync.transport.server.ReceiverManager;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(SyncService.class);
    private Pipe runningPipe;
    private ExtPipePluginManager extPipePluginManager;
    private ISyncInfoFetcher syncInfoFetcher = LocalSyncInfoFetcher.getInstance();
    private SenderManager senderManager;
    private final ReceiverManager receiverManager = new ReceiverManager();

    private SyncService() {
    }

    public static SyncService getInstance() {
        return SyncServiceHolder.INSTANCE;
    }

    public TSStatus handshake(TSyncIdentityInfo identityInfo) {
        return this.receiverManager.handshake(identityInfo);
    }

    public TSStatus transportFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return this.receiverManager.transportFile(metaInfo, buff);
    }

    public TSStatus transportPipeData(ByteBuffer buff) throws TException {
        return this.receiverManager.transportPipeData(buff);
    }

    public void handleClientExit() {
        this.receiverManager.handleClientExit();
    }

    public PipeSink getPipeSink(String name) {
        return this.syncInfoFetcher.getPipeSink(name);
    }

    public void addPipeSink(CreatePipeSinkPlan plan) throws PipeSinkException {
        TSStatus status = this.syncInfoFetcher.addPipeSink(plan);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public void addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) throws PipeSinkException {
        TSStatus status = this.syncInfoFetcher.addPipeSink(createPipeSinkStatement);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public void dropPipeSink(String name) throws PipeSinkException {
        TSStatus status = this.syncInfoFetcher.dropPipeSink(name);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public List<PipeSink> getAllPipeSink() {
        return this.syncInfoFetcher.getAllPipeSinks();
    }

    public synchronized void addPipe(CreatePipePlan plan) throws PipeException {
        long currentTime = DatetimeUtils.currentTime();
        if (plan.getDataStartTimestamp() > currentTime) {
            throw new PipeException(String.format("Start time %s is later than current time %s, this is not supported yet.", DatetimeUtils.convertLongToDate(plan.getDataStartTimestamp()), DatetimeUtils.convertLongToDate(currentTime)));
        }
        TSStatus status = this.syncInfoFetcher.addPipe(plan, currentTime);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
        PipeSink runningPipeSink = this.getPipeSink(plan.getPipeSinkName());
        this.runningPipe = SyncPipeUtil.parseCreatePipePlanAsPipe(plan, runningPipeSink, currentTime);
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
            try {
                this.senderManager = new SenderManager(this.runningPipe, (IoTDBPipeSink)runningPipeSink);
            }
            catch (ClassCastException e) {
                logger.error(String.format("Cast Class to %s error when create pipe %s.", IoTDBPipeSink.class.getName(), plan.getPipeName()), (Throwable)e);
                this.runningPipe = null;
                throw new PipeException(String.format("Wrong pipeSink type %s for create pipe %s", new Object[]{runningPipeSink.getType(), runningPipeSink.getPipeSinkName()}));
            }
        } else {
            this.startExternalPipeManager(false);
        }
    }

    public synchronized void addPipe(CreatePipeStatement statement) throws PipeException {
        long currentTime = DatetimeUtils.currentTime();
        if (statement.getStartTime() > currentTime) {
            throw new PipeException(String.format("Start time %s is later than current time %s, this is not supported yet.", DatetimeUtils.convertLongToDate(statement.getStartTime()), DatetimeUtils.convertLongToDate(currentTime)));
        }
        TSStatus status = this.syncInfoFetcher.addPipe(statement, currentTime);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
        PipeSink runningPipeSink = this.getPipeSink(statement.getPipeSinkName());
        this.runningPipe = SyncPipeUtil.parseCreatePipePlanAsPipe(statement, runningPipeSink, currentTime);
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
            try {
                this.senderManager = new SenderManager(this.runningPipe, (IoTDBPipeSink)runningPipeSink);
            }
            catch (ClassCastException e) {
                logger.error(String.format("Cast Class to %s error when create pipe %s.", IoTDBPipeSink.class.getName(), statement.getPipeName()), (Throwable)e);
                this.runningPipe = null;
                throw new PipeException(String.format("Wrong pipeSink type %s for create pipe %s", new Object[]{runningPipeSink.getType(), runningPipeSink.getPipeSinkName()}));
            }
        } else {
            this.startExternalPipeManager(false);
        }
    }

    public synchronized void stopPipe(String pipeName) throws PipeException {
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getStatus() == Pipe.PipeStatus.RUNNING) {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                this.runningPipe.stop();
                this.senderManager.stop();
            } else {
                if (this.extPipePluginManager != null) {
                    try {
                        String extPipeSinkTypeName = ((ExternalPipeSink)this.runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                        this.extPipePluginManager.stopExtPipe(extPipeSinkTypeName);
                    }
                    catch (Exception e) {
                        throw new PipeException("Failed to stop externalPipeProcessor. " + e.getMessage());
                    }
                }
                this.runningPipe.stop();
            }
        }
        this.syncInfoFetcher.stopPipe(pipeName);
    }

    public synchronized void startPipe(String pipeName) throws PipeException {
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getStatus() == Pipe.PipeStatus.STOP) {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                this.runningPipe.start();
                this.senderManager.start();
            } else {
                this.runningPipe.start();
                this.startExternalPipeManager(true);
            }
        }
        this.syncInfoFetcher.startPipe(pipeName);
    }

    public synchronized void dropPipe(String pipeName) throws PipeException {
        this.checkRunningPipeExistAndName(pipeName);
        try {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                if (!this.senderManager.close()) {
                    throw new PipeException(String.format("Close pipe %s transport error after %s %s, please try again.", this.runningPipe.getName(), SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS.name()));
                }
                this.runningPipe.drop();
            } else {
                if (this.extPipePluginManager != null) {
                    String extPipeSinkTypeName = ((ExternalPipeSink)this.runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                    this.extPipePluginManager.dropExtPipe(extPipeSinkTypeName);
                    this.extPipePluginManager = null;
                }
                this.runningPipe.drop();
            }
            this.syncInfoFetcher.dropPipe(pipeName);
        }
        catch (InterruptedException e) {
            logger.warn(String.format("Interrupted when waiting for clear transport %s.", this.runningPipe.getName()), (Throwable)e);
            throw new PipeException("Drop error, be interrupted, please try again.");
        }
    }

    public List<PipeInfo> getAllPipeInfos() {
        return this.syncInfoFetcher.getAllPipeInfos();
    }

    private void checkRunningPipeExistAndName(String pipeName) throws PipeException {
        if (this.runningPipe == null || this.runningPipe.getStatus() == Pipe.PipeStatus.DROP) {
            throw new PipeException("There is no existing pipe.");
        }
        if (!this.runningPipe.getName().equals(pipeName)) {
            throw new PipeException(String.format("Pipe %s is %s, please retry after drop it.", new Object[]{this.runningPipe.getName(), this.runningPipe.getStatus()}));
        }
    }

    public synchronized void receiveMsg(PipeMessage.MsgType type, String message) {
        if (this.runningPipe == null || this.runningPipe.getStatus() == Pipe.PipeStatus.DROP) {
            logger.info(String.format("No running pipe for receiving msg %s.", message));
            return;
        }
        switch (type) {
            case ERROR: {
                logger.error(String.format("%s from receiver: %s", type.name(), message));
                try {
                    this.stopPipe(this.runningPipe.getName());
                }
                catch (PipeException e) {
                    logger.error(String.format("Stop pipe %s when meeting error in sender service.", this.runningPipe.getName()), (Throwable)((Object)e));
                }
            }
            case WARN: {
                logger.warn(String.format("%s from receiver: %s", type.name(), message));
                TSStatus status = this.syncInfoFetcher.recordMsg(this.runningPipe.getName(), this.runningPipe.getCreateTime(), new PipeMessage(type, message));
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                logger.warn(String.format("Failed to record message: [%s] %s", type.name(), message));
            }
        }
    }

    public List<TPipeInfo> showPipe(String pipeName) {
        TPipeInfo tPipeInfo;
        boolean showAll = StringUtils.isEmpty((CharSequence)pipeName);
        ArrayList<TPipeInfo> list = new ArrayList<TPipeInfo>();
        for (PipeInfo pipe : SyncService.getInstance().getAllPipeInfos()) {
            if (!showAll && !pipeName.equals(pipe.getPipeName())) continue;
            tPipeInfo = new TPipeInfo(pipe.getCreateTime(), pipe.getPipeName(), "sender", pipe.getPipeSinkName(), pipe.getStatus().name(), "");
            list.add(tPipeInfo);
        }
        for (TSyncIdentityInfo identityInfo : this.receiverManager.getAllTSyncIdentityInfos()) {
            if (!showAll && !pipeName.equals(identityInfo.getPipeName())) continue;
            tPipeInfo = new TPipeInfo(identityInfo.getCreateTime(), identityInfo.getPipeName(), "receiver", identityInfo.getAddress(), Pipe.PipeStatus.RUNNING.name(), "");
            list.add(tPipeInfo);
        }
        return list;
    }

    public void showPipe(ShowPipePlan plan, ListDataSet listDataSet) {
        boolean showAll = "".equals(plan.getPipeName());
        for (PipeInfo pipe : SyncService.getInstance().getAllPipeInfos()) {
            String extPipeType;
            ExternalPipeStatus externalPipeStatus;
            ExtPipePluginManager extPipePluginManager;
            if (!showAll && !plan.getPipeName().equals(pipe.getPipeName())) continue;
            RowRecord record = new RowRecord(0L);
            record.addField((Object)Binary.valueOf((String)DatetimeUtils.convertLongToDate(pipe.getCreateTime())), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)pipe.getPipeName()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)"sender"), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)pipe.getPipeSinkName()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)pipe.getStatus().name()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)this.syncInfoFetcher.getPipeMsg(pipe.getPipeName(), pipe.getCreateTime())), TSDataType.TEXT);
            boolean needSetFields = true;
            PipeSink pipeSink = this.syncInfoFetcher.getPipeSink(pipe.getPipeSinkName());
            if (pipeSink.getType() == PipeSink.PipeSinkType.ExternalPipe && (extPipePluginManager = SyncService.getInstance().getExternalPipeManager()) != null && (externalPipeStatus = extPipePluginManager.getExternalPipeStatus(extPipeType = ((ExternalPipeSink)pipeSink).getExtPipeSinkTypeName())) != null) {
                record.addField((Object)Binary.valueOf((String)externalPipeStatus.getWriterInvocationFailures().toString()), TSDataType.TEXT);
                record.addField((Object)Binary.valueOf((String)externalPipeStatus.getWriterStatuses().toString()), TSDataType.TEXT);
                needSetFields = false;
            }
            if (needSetFields) {
                record.addField((Object)Binary.valueOf((String)"N/A"), TSDataType.TEXT);
                record.addField((Object)Binary.valueOf((String)"N/A"), TSDataType.TEXT);
            }
            listDataSet.putRecord(record);
        }
        List<TSyncIdentityInfo> identityInfoList = this.receiverManager.getAllTSyncIdentityInfos();
        for (TSyncIdentityInfo identityInfo : identityInfoList) {
            RowRecord record = new RowRecord(0L);
            record.addField((Object)Binary.valueOf((String)DatetimeUtils.convertLongToDate(identityInfo.getCreateTime())), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)identityInfo.getPipeName()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)"receiver"), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)identityInfo.getAddress()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)Pipe.PipeStatus.RUNNING.name()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)""), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)"N/A"), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)"N/A"), TSDataType.TEXT);
            listDataSet.putRecord(record);
        }
    }

    private void startExternalPipeManager(boolean startExtPipe) throws PipeException {
        if (!(this.runningPipe instanceof TsFilePipe)) {
            logger.error("startExternalPipeManager(), runningPipe is not TsFilePipe. " + this.runningPipe);
            return;
        }
        PipeSink pipeSink = this.runningPipe.getPipeSink();
        if (!(pipeSink instanceof ExternalPipeSink)) {
            logger.error("startExternalPipeManager(), pipeSink is not ExternalPipeSink." + pipeSink);
            return;
        }
        String extPipeSinkTypeName = ((ExternalPipeSink)pipeSink).getExtPipeSinkTypeName();
        IExternalPipeSinkWriterFactory externalPipeSinkWriterFactory = ExtPipePluginRegister.getInstance().getWriteFactory(extPipeSinkTypeName);
        if (externalPipeSinkWriterFactory == null) {
            logger.error(String.format("startExternalPipeManager(), can not found ExternalPipe plugin for %s.", extPipeSinkTypeName));
            throw new PipeException("Can not found ExternalPipe plugin for " + extPipeSinkTypeName + ".");
        }
        if (this.extPipePluginManager == null) {
            this.extPipePluginManager = new ExtPipePluginManager((TsFilePipe)this.runningPipe);
        }
        if (startExtPipe) {
            try {
                this.extPipePluginManager.startExtPipe(extPipeSinkTypeName, ((ExternalPipeSink)pipeSink).getSinkParams());
            }
            catch (IOException e) {
                logger.error("Failed to start External Pipe: {}.", (Object)extPipeSinkTypeName, (Object)e);
                throw new PipeException("Failed to start External Pipe: " + extPipeSinkTypeName + ". " + e.getMessage());
            }
        }
    }

    public ExtPipePluginManager getExternalPipeManager() {
        return this.extPipePluginManager;
    }

    public void start() throws StartupException {
        ExtPipePluginRegister extPipePluginRegister = ExtPipePluginRegister.getInstance();
        if (extPipePluginRegister == null) {
            throw new StartupException("Load ExternalPipe Plugin error.");
        }
        logger.info("Load {} ExternalPipe Plugin: {}", (Object)extPipePluginRegister.getAllPluginName().size(), extPipePluginRegister.getAllPluginName());
        File senderLog = new File(SyncPathUtil.getSysDir(), "syncService.log");
        if (senderLog.exists()) {
            try {
                this.recover();
            }
            catch (Exception e) {
                logger.error("Recover from disk error.", (Throwable)e);
                throw new StartupException((Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.runningPipe != null && !Pipe.PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            try {
                this.runningPipe.stop();
                this.senderManager.stop();
            }
            catch (PipeException e) {
                logger.warn(String.format("Stop pipe %s error when stop Sender Service.", this.runningPipe.getName()), (Throwable)((Object)e));
            }
        }
    }

    public void shutdown(long milliseconds) throws ShutdownException {
        if (this.runningPipe != null && !Pipe.PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            try {
                this.runningPipe.stop();
                this.senderManager.close();
                this.runningPipe.close();
            }
            catch (InterruptedException | PipeException e) {
                logger.warn(String.format("Stop pipe %s error when shutdown Sender Service.", this.runningPipe.getName()), (Throwable)e);
                throw new ShutdownException((Throwable)e);
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.SYNC_SERVICE;
    }

    private void recover() throws IOException, PipeException, StartupException {
        PipeInfo runningPipeInfo = this.syncInfoFetcher.getRunningPipeInfo();
        if (runningPipeInfo == null || Pipe.PipeStatus.DROP.equals((Object)runningPipeInfo.getStatus())) {
            return;
        }
        this.runningPipe = SyncPipeUtil.parsePipeInfoAsPipe(runningPipeInfo, this.syncInfoFetcher.getPipeSink(runningPipeInfo.getPipeSinkName()));
        switch (runningPipeInfo.getStatus()) {
            case RUNNING: {
                this.runningPipe.start();
                break;
            }
            case STOP: {
                this.runningPipe.stop();
                break;
            }
            case DROP: {
                this.runningPipe.drop();
                break;
            }
            default: {
                throw new IOException(String.format("Can not recognize running pipe status %s.", new Object[]{runningPipeInfo.getStatus()}));
            }
        }
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
            this.senderManager = new SenderManager(this.runningPipe, (IoTDBPipeSink)this.runningPipe.getPipeSink());
            if (Pipe.PipeStatus.RUNNING.equals((Object)this.runningPipe.getStatus())) {
                this.senderManager.start();
            }
        } else {
            this.startExternalPipeManager(this.runningPipe.getStatus() == Pipe.PipeStatus.RUNNING);
        }
    }

    public List<ISyncManager> getOrCreateSyncManager(String dataRegionId) {
        ArrayList<ISyncManager> syncManagerList = new ArrayList<ISyncManager>();
        if (this.runningPipe != null) {
            syncManagerList.add(this.runningPipe.getOrCreateSyncManager(dataRegionId));
        }
        return syncManagerList;
    }

    public void deleteSyncManager(String dataRegionId) {
        if (this.runningPipe != null) {
            this.runningPipe.deleteSyncManager(dataRegionId);
        }
    }

    public SenderManager getSenderManager() {
        return this.senderManager;
    }

    private static class SyncServiceHolder {
        private static final SyncService INSTANCE = new SyncService();

        private SyncServiceHolder() {
        }
    }
}

