/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.common;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.exception.sync.PipeException;
import org.apache.iotdb.db.exception.sync.PipeSinkException;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.common.ISyncInfoFetcher;
import org.apache.iotdb.db.sync.common.SyncInfo;
import org.apache.iotdb.db.sync.sender.pipe.PipeInfo;
import org.apache.iotdb.db.sync.sender.pipe.PipeMessage;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncInfoFetcher
implements ISyncInfoFetcher {
    private static final Logger logger = LoggerFactory.getLogger(LocalSyncInfoFetcher.class);
    private SyncInfo syncInfo = new SyncInfo();

    private LocalSyncInfoFetcher() {
    }

    @Override
    public TSStatus addPipeSink(CreatePipeSinkPlan plan) {
        try {
            this.syncInfo.addPipeSink(plan);
        }
        catch (IOException | PipeSinkException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        try {
            this.syncInfo.addPipeSink(createPipeSinkStatement);
        }
        catch (IOException | PipeSinkException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus dropPipeSink(String name) {
        try {
            this.syncInfo.dropPipeSink(name);
        }
        catch (IOException | PipeSinkException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public PipeSink getPipeSink(String name) {
        return this.syncInfo.getPipeSink(name);
    }

    @Override
    public List<PipeSink> getAllPipeSinks() {
        return this.syncInfo.getAllPipeSink();
    }

    @Override
    public TSStatus addPipe(CreatePipePlan plan, long createTime) {
        try {
            this.syncInfo.addPipe(plan, createTime);
        }
        catch (IOException | PipeException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus addPipe(CreatePipeStatement createPipeStatement, long createTime) {
        try {
            this.syncInfo.addPipe(createPipeStatement, createTime);
        }
        catch (IOException | PipeException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus stopPipe(String pipeName) {
        try {
            this.syncInfo.operatePipe(pipeName, StatementType.STOP_PIPE);
        }
        catch (IOException | PipeException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus startPipe(String pipeName) {
        try {
            this.syncInfo.operatePipe(pipeName, StatementType.START_PIPE);
        }
        catch (IOException | PipeException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus dropPipe(String pipeName) {
        try {
            this.syncInfo.operatePipe(pipeName, StatementType.DROP_PIPE);
        }
        catch (IOException | PipeException e) {
            RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)((Throwable)e).getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public List<PipeInfo> getAllPipeInfos() {
        return this.syncInfo.getAllPipeInfos();
    }

    @Override
    public PipeInfo getRunningPipeInfo() {
        return this.syncInfo.getRunningPipeInfo();
    }

    @Override
    public String getPipeMsg(String pipeName, long createTime) {
        return this.syncInfo.getPipeMessage(pipeName, createTime, false).getMsg();
    }

    @Override
    public TSStatus recordMsg(String pipeName, long createTime, PipeMessage pipeMessage) {
        this.syncInfo.writePipeMessage(pipeName, createTime, pipeMessage);
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public static LocalSyncInfoFetcher getInstance() {
        return LocalSyncInfoFetcherHolder.INSTANCE;
    }

    public void reset() {
        this.syncInfo = new SyncInfo();
    }

    private static class LocalSyncInfoFetcherHolder {
        private static final LocalSyncInfoFetcher INSTANCE = new LocalSyncInfoFetcher();

        private LocalSyncInfoFetcherHolder() {
        }
    }
}

