/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import java.io.File;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sync.PipeDataLoadException;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileLoader
implements ILoader {
    private static final Logger logger = LoggerFactory.getLogger(TsFileLoader.class);
    private static PlanExecutor planExecutor;
    private final File tsFile;

    public TsFileLoader(File tsFile) {
        this.tsFile = tsFile;
    }

    @Override
    public void load() throws PipeDataLoadException {
        try {
            OperateFilePlan plan = new OperateFilePlan(this.tsFile, Operator.OperatorType.LOAD_FILES, true, IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel(), true);
            planExecutor.processNonQuery(plan);
        }
        catch (Exception e) {
            throw new PipeDataLoadException(e.getMessage());
        }
    }

    static {
        try {
            planExecutor = new PlanExecutor();
        }
        catch (QueryProcessException e) {
            logger.error(e.getMessage());
        }
    }
}

