/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.pipe;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.exception.sync.PipeSinkException;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

public class IoTDBPipeSink
implements PipeSink {
    private final PipeSink.PipeSinkType pipeSinkType;
    private String name;
    private String ip = "127.0.0.1";
    private int port = 6667;

    public IoTDBPipeSink(String name) {
        this.name = name;
        this.pipeSinkType = PipeSink.PipeSinkType.IoTDB;
    }

    @Override
    public void setAttribute(List<Pair<String, String>> params) throws PipeSinkException {
        for (Pair<String, String> pair : params) {
            String attr = (String)pair.left;
            String value = (String)pair.right;
            if ((attr = attr.toLowerCase()).equals("ip")) {
                this.ip = value;
                continue;
            }
            if (attr.equals("port")) {
                try {
                    this.port = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new PipeSinkException(attr, value, TSDataType.INT32.name());
                }
            }
            throw new PipeSinkException("There is No attribute " + attr + " in " + (Object)((Object)PipeSink.PipeSinkType.IoTDB) + " pipeSink.");
        }
    }

    @Override
    public void setAttribute(Map<String, String> params) throws PipeSinkException {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String attr = entry.getKey();
            String value = entry.getValue();
            if ((attr = attr.toLowerCase()).equals("ip")) {
                this.ip = value;
                continue;
            }
            if (attr.equals("port")) {
                try {
                    this.port = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new PipeSinkException(attr, value, TSDataType.INT32.name());
                }
            }
            throw new PipeSinkException("There is No attribute " + attr + " in " + (Object)((Object)PipeSink.PipeSinkType.IoTDB) + " pipeSink.");
        }
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String getPipeSinkName() {
        return this.name;
    }

    @Override
    public PipeSink.PipeSinkType getType() {
        return this.pipeSinkType;
    }

    @Override
    public String showAllAttributes() {
        return String.format("ip='%s',port=%d", this.ip, this.port);
    }

    public String toString() {
        return "IoTDBPipeSink{pipeSinkType=" + (Object)((Object)this.pipeSinkType) + ", name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoTDBPipeSink pipeSink = (IoTDBPipeSink)o;
        return this.port == pipeSink.port && this.pipeSinkType == pipeSink.pipeSinkType && Objects.equals(this.name, pipeSink.name) && Objects.equals(this.ip, pipeSink.ip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pipeSinkType, this.name, this.ip, this.port});
    }
}

