/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.client;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientPoolProperty;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.client.sync.SyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;

public class DataNodeClientPoolFactory {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();

    private DataNodeClientPoolFactory() {
    }

    public static class ClusterDeletionConfigNodeClientPoolFactory
    implements IClientPoolFactory<PartitionRegionId, ConfigNodeClient> {
        public KeyedObjectPool<PartitionRegionId, ConfigNodeClient> createClientPool(ClientManager<PartitionRegionId, ConfigNodeClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ConfigNodeClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS() * 10).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager() / 10 > 0 ? conf.getSelectorNumOfClientManager() / 10 : 1).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class ConfigNodeClientPoolFactory
    implements IClientPoolFactory<PartitionRegionId, ConfigNodeClient> {
        public KeyedObjectPool<PartitionRegionId, ConfigNodeClient> createClientPool(ClientManager<PartitionRegionId, ConfigNodeClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ConfigNodeClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class AsyncDataNodeMPPDataExchangeServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> {
        public KeyedObjectPool<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeMPPDataExchangeServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_MPP_DATA_EXCHANGE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class SyncDataNodeMPPDataExchangeServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> {
        public KeyedObjectPool<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataNodeMPPDataExchangeServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class SyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeInternalServiceClient> {
        public KeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeInternalServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataNodeInternalServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().setMaxIdleClientForEachNode(conf.getCoreConnectionForInternalService()).setMaxTotalClientForEachNode(conf.getMaxConnectionForInternalService()).build().getConfig());
        }
    }

    public static class AsyncConfigNodeIServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncConfigNodeIServiceClient> {
        public KeyedObjectPool<TEndPoint, AsyncConfigNodeIServiceClient> createClientPool(ClientManager<TEndPoint, AsyncConfigNodeIServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncConfigNodeIServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_CONFIGNODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setMaxIdleClientForEachNode(conf.getCoreConnectionForInternalService()).setMaxTotalClientForEachNode(conf.getMaxConnectionForInternalService()).build().getConfig());
        }
    }

    public static class SyncConfigNodeIServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncConfigNodeIServiceClient> {
        public KeyedObjectPool<TEndPoint, SyncConfigNodeIServiceClient> createClientPool(ClientManager<TEndPoint, SyncConfigNodeIServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncConfigNodeIServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }
}

