/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.DataRegionStateMachine;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public class DataRegionConsensusImpl {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    private static IConsensus INSTANCE = null;

    private DataRegionConsensusImpl() {
    }

    public static IConsensus getInstance() {
        return INSTANCE;
    }

    public static synchronized IConsensus setupAndGetInstance() {
        if (INSTANCE == null) {
            INSTANCE = (IConsensus)ConsensusFactory.getConsensusImpl((String)conf.getDataRegionConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(conf.getDataNodeId()).setThisNode(new TEndPoint(conf.getInternalAddress(), conf.getDataRegionConsensusPort())).setStorageDir(conf.getDataRegionConsensusDir()).setMultiLeaderConfig(MultiLeaderConfig.newBuilder().setRpc(MultiLeaderConfig.RPC.newBuilder().setConnectionTimeoutInMs(conf.getConnectionTimeoutInMS()).setRpcSelectorThreadNum(conf.getRpcSelectorThreadNum()).setRpcMinConcurrentClientNum(conf.getRpcMinConcurrentClientNum()).setRpcMaxConcurrentClientNum(conf.getRpcMaxConcurrentClientNum()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfClientManager(conf.getSelectorNumOfClientManager()).setThriftServerAwaitTimeForStopService(conf.getThriftServerAwaitTimeForStopService()).setThriftMaxFrameSize(conf.getThriftMaxFrameSize()).build()).setReplication(MultiLeaderConfig.Replication.newBuilder().setWalThrottleThreshold(conf.getThrottleThreshold()).setAllocateMemoryForConsensus(conf.getAllocateMemoryForConsensus()).build()).build()).setRatisConfig(RatisConfig.newBuilder().setSnapshot(RatisConfig.Snapshot.newBuilder().setCreationGap(1L).setAutoTriggerThreshold(conf.getDataRatisConsensusSnapshotTriggerThreshold()).build()).setLog(RatisConfig.Log.newBuilder().setUnsafeFlushEnabled(conf.isDataRatisConsensusLogUnsafeFlushEnable()).setSegmentSizeMax(SizeInBytes.valueOf((long)conf.getDataRatisConsensusLogSegmentSizeMax())).build()).setGrpc(RatisConfig.Grpc.newBuilder().setFlowControlWindow(SizeInBytes.valueOf((long)conf.getDataRatisConsensusGrpcFlowControlWindow())).build()).setRpc(RatisConfig.Rpc.newBuilder().setTimeoutMin(TimeDuration.valueOf((long)conf.getDataRatisConsensusLeaderElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setTimeoutMax(TimeDuration.valueOf((long)conf.getDataRatisConsensusLeaderElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).setLeaderLogAppender(RatisConfig.LeaderLogAppender.newBuilder().setBufferByteLimit(conf.getDataRatisConsensusLogAppenderBufferSizeMax()).build()).build()).build(), gid -> new DataRegionStateMachine(StorageEngineV2.getInstance().getDataRegion((DataRegionId)gid))).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", conf.getDataRegionConsensusProtocolClass())));
        }
        return INSTANCE;
    }
}

