/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.dataregion.StorageGroupManager;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.StorageEngineFailureException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.ThreadUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.db.wal.exception.WALException;
import org.apache.iotdb.db.wal.recover.WALRecoverManager;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEngine
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(StorageEngine.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long TTL_CHECK_INTERVAL = 60000L;
    private static long timePartitionInterval = -1L;
    private static boolean enablePartition = config.isEnablePartition();
    private final boolean enableMemControl = config.isEnableMemControl();
    private final String systemDir = FilePathUtils.regularizePath((String)config.getSystemDir()) + "storage_groups";
    private final ConcurrentHashMap<PartialPath, StorageGroupManager> processorMap = new ConcurrentHashMap();
    private AtomicBoolean isAllSgReady = new AtomicBoolean(false);
    private ScheduledExecutorService ttlCheckThread;
    private ScheduledExecutorService seqMemtableTimedFlushCheckThread;
    private ScheduledExecutorService unseqMemtableTimedFlushCheckThread;
    private TsFileFlushPolicy fileFlushPolicy = new TsFileFlushPolicy.DirectFlushPolicy();
    private ExecutorService recoveryThreadPool;
    private List<CloseFileListener> customCloseFileListeners = new ArrayList<CloseFileListener>();
    private List<FlushListener> customFlushListeners = new ArrayList<FlushListener>();

    private StorageEngine() {
    }

    public static StorageEngine getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static void initTimePartition() {
        timePartitionInterval = IoTDBDescriptor.getInstance().getConfig().getTimePartitionIntervalForStorage();
    }

    public static long getTimePartitionInterval() {
        if (timePartitionInterval == -1L) {
            StorageEngine.initTimePartition();
        }
        return timePartitionInterval;
    }

    public static void setTimePartitionInterval(long timePartitionInterval) {
        StorageEngine.timePartitionInterval = timePartitionInterval;
    }

    public static long getTimePartition(long time) {
        if (timePartitionInterval == -1L) {
            StorageEngine.initTimePartition();
        }
        return enablePartition ? time / timePartitionInterval : 0L;
    }

    public static boolean isEnablePartition() {
        return enablePartition;
    }

    public static void setEnablePartition(boolean enablePartition) {
        StorageEngine.enablePartition = enablePartition;
    }

    public static void blockInsertionIfReject(TsFileProcessor tsFileProcessor) throws WriteProcessRejectException {
        long startTime = System.currentTimeMillis();
        while (SystemInfo.getInstance().isRejected() && (tsFileProcessor == null || !tsFileProcessor.shouldFlush())) {
            try {
                TimeUnit.MILLISECONDS.sleep(config.getCheckPeriodWhenInsertBlocked());
                if (System.currentTimeMillis() - startTime <= (long)config.getMaxWaitingTimeWhenInsertBlocked()) continue;
                throw new WriteProcessRejectException("System rejected over " + (System.currentTimeMillis() - startTime) + "ms");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isAllSgReady() {
        return this.isAllSgReady.get();
    }

    public void setAllSgReady(boolean allSgReady) {
        this.isAllSgReady.set(allSgReady);
    }

    public void recover() {
        this.setAllSgReady(false);
        this.recoveryThreadPool = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.DATA_REGION_RECOVER_SERVICE.getName());
        List<IStorageGroupMNode> sgNodes = IoTDB.schemaProcessor.getAllStorageGroupNodes();
        WALRecoverManager.getInstance().setAllDataRegionScannedLatch(new CountDownLatch(sgNodes.size() * config.getDataRegionNum()));
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        for (IStorageGroupMNode storageGroup : sgNodes) {
            StorageGroupManager storageGroupManager = this.processorMap.computeIfAbsent(storageGroup.getPartialPath(), id -> new StorageGroupManager(true));
            storageGroupManager.asyncRecover(storageGroup, this.recoveryThreadPool, futures);
        }
        try {
            WALRecoverManager.getInstance().recover();
        }
        catch (WALException e) {
            logger.error("Fail to recover wal.", (Throwable)((Object)e));
        }
        Thread recoverEndTrigger = new Thread(() -> {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
                }
            }
            this.recoveryThreadPool.shutdown();
            this.setAllSgReady(true);
        });
        recoverEndTrigger.start();
    }

    public void start() {
        if (!enablePartition) {
            timePartitionInterval = Long.MAX_VALUE;
        } else {
            StorageEngine.initTimePartition();
        }
        try {
            FileUtils.forceMkdir((File)SystemFileFactory.INSTANCE.getFile(this.systemDir));
        }
        catch (IOException e) {
            throw new StorageEngineFailureException(e);
        }
        UpgradeUtils.recoverUpgrade();
        this.recover();
        this.ttlCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"TTL-Check");
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.ttlCheckThread, this::checkTTL, (long)60000L, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        logger.info("start ttl check thread successfully.");
        this.startTimedService();
    }

    private void checkTTL() {
        try {
            for (StorageGroupManager processor : this.processorMap.values()) {
                processor.checkTTL();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            logger.error("An error occurred when checking TTL", (Throwable)e);
        }
    }

    private void startTimedService() {
        if (config.isEnableTimedFlushSeqMemtable()) {
            this.seqMemtableTimedFlushCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.TIMED_FlUSH_SEQ_MEMTABLE.getName());
            ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.seqMemtableTimedFlushCheckThread, this::timedFlushSeqMemTable, (long)config.getSeqMemtableFlushCheckInterval(), (long)config.getSeqMemtableFlushCheckInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
            logger.info("start sequence memtable timed flush check thread successfully.");
        }
        if (config.isEnableTimedFlushUnseqMemtable()) {
            this.unseqMemtableTimedFlushCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.TIMED_FlUSH_UNSEQ_MEMTABLE.getName());
            ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.unseqMemtableTimedFlushCheckThread, this::timedFlushUnseqMemTable, (long)config.getUnseqMemtableFlushCheckInterval(), (long)config.getUnseqMemtableFlushCheckInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
            logger.info("start unsequence memtable timed flush check thread successfully.");
        }
    }

    private void timedFlushSeqMemTable() {
        for (StorageGroupManager processor : this.processorMap.values()) {
            processor.timedFlushSeqMemTable();
        }
    }

    private void timedFlushUnseqMemTable() {
        for (StorageGroupManager processor : this.processorMap.values()) {
            processor.timedFlushUnseqMemTable();
        }
    }

    public void stop() {
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.stopSchedulerPool();
        }
        this.syncCloseAllProcessor();
        ThreadUtils.stopThreadPool(this.ttlCheckThread, ThreadName.TTL_CHECK_SERVICE);
        ThreadUtils.stopThreadPool(this.seqMemtableTimedFlushCheckThread, ThreadName.TIMED_FlUSH_SEQ_MEMTABLE);
        ThreadUtils.stopThreadPool(this.unseqMemtableTimedFlushCheckThread, ThreadName.TIMED_FlUSH_UNSEQ_MEMTABLE);
        this.recoveryThreadPool.shutdownNow();
        this.processorMap.clear();
    }

    public void shutdown(long milliseconds) throws ShutdownException {
        try {
            for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
                storageGroupManager.stopSchedulerPool();
            }
            this.forceCloseAllProcessor();
        }
        catch (TsFileProcessorException e) {
            throw new ShutdownException((Throwable)((Object)e));
        }
        this.shutdownTimedService(this.ttlCheckThread, "TTlCheckThread");
        this.shutdownTimedService(this.seqMemtableTimedFlushCheckThread, "SeqMemtableTimedFlushCheckThread");
        this.shutdownTimedService(this.unseqMemtableTimedFlushCheckThread, "UnseqMemtableTimedFlushCheckThread");
        this.recoveryThreadPool.shutdownNow();
        this.processorMap.clear();
    }

    private void shutdownTimedService(ScheduledExecutorService pool, String poolName) {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 30s", (Object)poolName);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void rebootTimedService() throws ShutdownException {
        logger.info("Start rebooting all timed service.");
        this.stopTimedServiceAndThrow(this.seqMemtableTimedFlushCheckThread, "SeqMemtableTimedFlushCheckThread");
        this.stopTimedServiceAndThrow(this.unseqMemtableTimedFlushCheckThread, "UnseqMemtableTimedFlushCheckThread");
        logger.info("Stop all timed service successfully, and now restart them.");
        this.startTimedService();
        logger.info("Reboot all timed service successfully");
    }

    private void stopTimedServiceAndThrow(ScheduledExecutorService pool, String poolName) throws ShutdownException {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 30s", (Object)poolName);
                throw new ShutdownException((Throwable)e);
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.STORAGE_ENGINE_SERVICE;
    }

    public DataRegion getProcessorDirectly(PartialPath path) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(path);
            PartialPath storageGroupPath = storageGroupMNode.getPartialPath();
            return this.getStorageGroupProcessorByPath(storageGroupPath, storageGroupMNode);
        }
        catch (MetadataException | DataRegionException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
    }

    public DataRegion getProcessorDirectly(PartialPath path, int dataRegionId) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(path);
            return this.getStorageGroupProcessorById(dataRegionId, storageGroupMNode);
        }
        catch (MetadataException | DataRegionException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
    }

    public DataRegion getProcessor(PartialPath path) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(path);
            return this.getStorageGroupProcessorByPath(path, storageGroupMNode);
        }
        catch (MetadataException | DataRegionException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
    }

    public DataRegion getProcessorByDataRegionId(PartialPath path, int dataRegionId) throws StorageEngineException {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(path);
            return this.getStorageGroupManager(storageGroupMNode).getProcessor(storageGroupMNode, dataRegionId);
        }
        catch (MetadataException | DataRegionException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
    }

    public List<String> getLockInfo(List<PartialPath> pathList) throws StorageEngineException {
        try {
            ArrayList<String> lockHolderList = new ArrayList<String>(pathList.size());
            for (PartialPath path : pathList) {
                IStorageGroupMNode storageGroupMNode = IoTDB.schemaProcessor.getStorageGroupNodeByPath(path);
                DataRegion dataRegion = this.getStorageGroupProcessorByPath(path, storageGroupMNode);
                lockHolderList.add(dataRegion.getInsertWriteLockHolder());
            }
            return lockHolderList;
        }
        catch (MetadataException | DataRegionException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
    }

    private DataRegion getStorageGroupProcessorByPath(PartialPath devicePath, IStorageGroupMNode storageGroupMNode) throws DataRegionException, StorageEngineException {
        return this.getStorageGroupManager(storageGroupMNode).getProcessor(devicePath, storageGroupMNode);
    }

    private DataRegion getStorageGroupProcessorById(int dataRegionId, IStorageGroupMNode storageGroupMNode) throws DataRegionException, StorageEngineException {
        return this.getStorageGroupManager(storageGroupMNode).getProcessor(dataRegionId, storageGroupMNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageGroupManager getStorageGroupManager(IStorageGroupMNode storageGroupMNode) {
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupMNode.getPartialPath());
        if (storageGroupManager == null) {
            StorageEngine storageEngine = this;
            synchronized (storageEngine) {
                storageGroupManager = this.processorMap.get(storageGroupMNode.getPartialPath());
                if (storageGroupManager == null) {
                    storageGroupManager = new StorageGroupManager();
                    this.processorMap.put(storageGroupMNode.getPartialPath(), storageGroupManager);
                }
            }
        }
        return storageGroupManager;
    }

    public DataRegion buildNewStorageGroupProcessor(PartialPath logicalStorageGroupName, IStorageGroupMNode storageGroupMNode, String virtualStorageGroupId) throws DataRegionException {
        logger.info("construct a processor instance, the storage group is {}, Thread is {}", (Object)logicalStorageGroupName, (Object)Thread.currentThread().getId());
        DataRegion processor = new DataRegion(this.systemDir + File.separator + logicalStorageGroupName, virtualStorageGroupId, this.fileFlushPolicy, storageGroupMNode.getFullPath());
        processor.setDataTTLWithTimePrecisionCheck(storageGroupMNode.getDataTTL());
        processor.setCustomFlushListeners(this.customFlushListeners);
        processor.setCustomCloseFileListeners(this.customCloseFileListeners);
        return processor;
    }

    public synchronized void reset() {
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.reset();
        }
    }

    public void insert(InsertRowPlan insertRowPlan) throws StorageEngineException, MetadataException {
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject(null);
            }
            catch (WriteProcessException e) {
                throw new StorageEngineException(e);
            }
        }
        DataRegion dataRegion = this.getProcessor(insertRowPlan.getDevicePath());
        this.getSeriesSchemas(insertRowPlan, dataRegion);
        try {
            insertRowPlan.transferType();
        }
        catch (QueryProcessException e) {
            throw new StorageEngineException(e);
        }
        try {
            dataRegion.insert(insertRowPlan);
        }
        catch (WriteProcessException e) {
            throw new StorageEngineException(e);
        }
    }

    public void insert(InsertRowsOfOneDevicePlan insertRowsOfOneDevicePlan) throws StorageEngineException, MetadataException {
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject(null);
            }
            catch (WriteProcessException e) {
                throw new StorageEngineException(e);
            }
        }
        DataRegion dataRegion = this.getProcessor(insertRowsOfOneDevicePlan.getDevicePath());
        for (InsertRowPlan plan : insertRowsOfOneDevicePlan.getRowPlans()) {
            plan.setMeasurementMNodes(new IMeasurementMNode[plan.getMeasurements().length]);
            this.getSeriesSchemas(plan, dataRegion);
        }
        try {
            dataRegion.insert(insertRowsOfOneDevicePlan);
        }
        catch (WriteProcessException e) {
            throw new StorageEngineException(e);
        }
    }

    public void insertTablet(InsertTabletPlan insertTabletPlan) throws StorageEngineException, BatchProcessException, MetadataException {
        DataRegion dataRegion;
        if (this.enableMemControl) {
            try {
                StorageEngine.blockInsertionIfReject(null);
            }
            catch (WriteProcessRejectException e) {
                Object[] results = new TSStatus[insertTabletPlan.getRowCount()];
                Arrays.fill(results, RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT));
                throw new BatchProcessException((TSStatus[])results);
            }
        }
        try {
            dataRegion = this.getProcessor(insertTabletPlan.getDevicePath());
        }
        catch (StorageEngineException e) {
            throw new StorageEngineException(String.format("Get StorageGroupProcessor of device %s failed", insertTabletPlan.getDevicePath()), (Throwable)((Object)e));
        }
        this.getSeriesSchemas(insertTabletPlan, dataRegion);
        dataRegion.insertTablet(insertTabletPlan);
    }

    public void syncCloseAllProcessor() {
        logger.info("Start closing all storage group processor");
        for (StorageGroupManager processor : this.processorMap.values()) {
            processor.syncCloseAllWorkingTsFileProcessors();
        }
    }

    public void forceCloseAllProcessor() throws TsFileProcessorException {
        logger.info("Start force closing all storage group processor");
        for (StorageGroupManager processor : this.processorMap.values()) {
            processor.forceCloseAllWorkingTsFileProcessors();
        }
    }

    public void closeStorageGroupProcessor(PartialPath storageGroupPath, boolean isSeq, boolean isSync) {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            return;
        }
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupPath);
        storageGroupManager.closeStorageGroupProcessor(isSeq, isSync);
    }

    public void closeStorageGroupProcessor(PartialPath storageGroupPath, long partitionId, boolean isSeq, boolean isSync) throws StorageGroupNotSetException {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            throw new StorageGroupNotSetException(storageGroupPath.getFullPath());
        }
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroupPath);
        storageGroupManager.closeStorageGroupProcessor(partitionId, isSeq, isSync);
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex, DataRegion.TimePartitionFilter timePartitionFilter) throws StorageEngineException {
        try {
            List<PartialPath> sgPaths = IoTDB.schemaProcessor.getBelongedStorageGroups(path);
            for (PartialPath storageGroupPath : sgPaths) {
                if (!this.processorMap.containsKey(storageGroupPath)) continue;
                List possiblePaths = path.alterPrefixPath(storageGroupPath);
                for (PartialPath possiblePath : possiblePaths) {
                    this.processorMap.get(storageGroupPath).delete(possiblePath, startTime, endTime, planIndex, timePartitionFilter);
                }
            }
        }
        catch (IOException | MetadataException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public void deleteTimeseries(PartialPath path, long planIndex, DataRegion.TimePartitionFilter timePartitionFilter) throws StorageEngineException {
        try {
            List<PartialPath> sgPaths = IoTDB.schemaProcessor.getBelongedStorageGroups(path);
            for (PartialPath storageGroupPath : sgPaths) {
                if (!this.processorMap.containsKey(storageGroupPath)) continue;
                List possiblePaths = path.alterPrefixPath(storageGroupPath);
                for (PartialPath possiblePath : possiblePaths) {
                    this.processorMap.get(storageGroupPath).delete(possiblePath, Long.MIN_VALUE, Long.MAX_VALUE, planIndex, timePartitionFilter);
                }
            }
        }
        catch (IOException | MetadataException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public int countUpgradeFiles() {
        int totalUpgradeFileNum = 0;
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            totalUpgradeFileNum += storageGroupManager.countUpgradeFiles();
        }
        return totalUpgradeFileNum;
    }

    public void upgradeAll() throws StorageEngineException {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new StorageEngineException("Current system mode is read only, does not support file upgrade");
        }
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.upgradeAll();
        }
    }

    public void getResourcesToBeSettled(PartialPath sgPath, List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) throws StorageEngineException {
        StorageGroupManager storageGroupManager = this.processorMap.get(sgPath);
        if (storageGroupManager == null) {
            throw new StorageEngineException("The Storage Group " + sgPath.toString() + " is not existed.");
        }
        if (!storageGroupManager.getIsSettling().compareAndSet(false, true)) {
            throw new StorageEngineException("Storage Group " + sgPath.getFullPath() + " is already being settled now.");
        }
        storageGroupManager.getResourcesToBeSettled(seqResourcesToBeSettled, unseqResourcesToBeSettled, tsFilePaths);
    }

    public void setSettling(PartialPath sgPath, boolean isSettling) {
        if (this.processorMap.get(sgPath) == null) {
            return;
        }
        this.processorMap.get(sgPath).setSettling(isSettling);
    }

    public void mergeAll() throws StorageEngineException {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new StorageEngineException("Current system mode is read only, does not support merge");
        }
        for (StorageGroupManager storageGroupManager : this.processorMap.values()) {
            storageGroupManager.mergeAll();
        }
    }

    public void deleteAllDataFilesInOneStorageGroup(PartialPath storageGroupPath) {
        if (this.processorMap.containsKey(storageGroupPath)) {
            this.syncDeleteDataFiles(storageGroupPath);
        }
    }

    private void syncDeleteDataFiles(PartialPath storageGroupPath) {
        logger.info("Force to delete the data in storage group processor {}", (Object)storageGroupPath);
        this.processorMap.get(storageGroupPath).syncDeleteDataFiles();
    }

    public synchronized boolean deleteAll() {
        logger.info("Start deleting all storage groups' timeseries");
        this.syncCloseAllProcessor();
        for (PartialPath storageGroup : IoTDB.schemaProcessor.getAllStorageGroupPaths()) {
            this.deleteAllDataFilesInOneStorageGroup(storageGroup);
        }
        this.processorMap.clear();
        return true;
    }

    public void setTTL(PartialPath storageGroup, long dataTTL) {
        if (!this.processorMap.containsKey(storageGroup)) {
            return;
        }
        this.processorMap.get(storageGroup).setTTL(dataTTL);
    }

    public void deleteStorageGroup(PartialPath storageGroupPath) {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            return;
        }
        this.abortCompactionTaskForStorageGroup(storageGroupPath);
        this.deleteAllDataFilesInOneStorageGroup(storageGroupPath);
        StorageGroupManager storageGroupManager = this.processorMap.remove(storageGroupPath);
        storageGroupManager.deleteStorageGroupSystemFolder(this.systemDir);
        storageGroupManager.stopSchedulerPool();
    }

    private void abortCompactionTaskForStorageGroup(PartialPath storageGroupPath) {
        if (!this.processorMap.containsKey(storageGroupPath)) {
            return;
        }
        StorageGroupManager manager = this.processorMap.get(storageGroupPath);
        manager.setAllowCompaction(false);
        manager.abortCompaction();
    }

    public void loadNewTsFile(TsFileResource newTsFileResource, boolean deleteOriginFile) throws LoadFileException, StorageEngineException, MetadataException {
        Set<String> deviceSet = newTsFileResource.getDevices();
        if (deviceSet == null || deviceSet.isEmpty()) {
            throw new StorageEngineException("The TsFile is empty, cannot be loaded.");
        }
        String device = deviceSet.iterator().next();
        PartialPath devicePath = new PartialPath(device);
        PartialPath storageGroupPath = IoTDB.schemaProcessor.getBelongedStorageGroup(devicePath);
        this.getProcessorDirectly(storageGroupPath).loadNewTsFile(newTsFileResource, deleteOriginFile);
    }

    public boolean deleteTsfile(File deletedTsfile) throws StorageEngineException, IllegalPathException {
        return this.getProcessorDirectly(new PartialPath(this.getSgByEngineFile(deletedTsfile, true)), this.getDataRegionIdByEngineFile(deletedTsfile, true)).deleteTsfile(deletedTsfile);
    }

    public boolean unloadTsfile(File tsfileToBeUnloaded, File targetDir) throws StorageEngineException, IllegalPathException {
        return this.getProcessorDirectly(new PartialPath(this.getSgByEngineFile(tsfileToBeUnloaded, true)), this.getDataRegionIdByEngineFile(tsfileToBeUnloaded, true)).unloadTsfile(tsfileToBeUnloaded, targetDir);
    }

    public String getSgByEngineFile(File file, boolean needCheck) throws IllegalPathException {
        if (needCheck) {
            File dataDir = file.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            if (dataDir.exists()) {
                String[] dataDirs;
                for (String dir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
                    try {
                        if (!Files.isSameFile(Paths.get(dir, new String[0]), dataDir.toPath())) continue;
                        return file.getParentFile().getParentFile().getParentFile().getName();
                    }
                    catch (IOException e) {
                        throw new IllegalPathException(file.getAbsolutePath(), e.getMessage());
                    }
                }
            }
            throw new IllegalPathException(file.getAbsolutePath(), "it's not an internal tsfile.");
        }
        return file.getParentFile().getParentFile().getParentFile().getName();
    }

    public int getDataRegionIdByEngineFile(File file, boolean needCheck) throws IllegalPathException {
        if (needCheck) {
            File dataDir = file.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            if (dataDir.exists()) {
                String[] dataDirs;
                for (String dir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
                    try {
                        if (!Files.isSameFile(Paths.get(dir, new String[0]), dataDir.toPath())) continue;
                        return Integer.parseInt(file.getParentFile().getParentFile().getName());
                    }
                    catch (IOException e) {
                        throw new IllegalPathException(file.getAbsolutePath(), e.getMessage());
                    }
                }
            }
            throw new IllegalPathException(file.getAbsolutePath(), "it's not an internal tsfile.");
        }
        return Integer.parseInt(file.getParentFile().getParentFile().getName());
    }

    public Map<PartialPath, Map<Long, List<TsFileResource>>> getAllClosedStorageGroupTsFile() {
        HashMap<PartialPath, Map<Long, List<TsFileResource>>> ret = new HashMap<PartialPath, Map<Long, List<TsFileResource>>>();
        for (Map.Entry<PartialPath, StorageGroupManager> entry : this.processorMap.entrySet()) {
            entry.getValue().getAllClosedStorageGroupTsFile(entry.getKey(), ret);
        }
        return ret;
    }

    public void setFileFlushPolicy(TsFileFlushPolicy fileFlushPolicy) {
        this.fileFlushPolicy = fileFlushPolicy;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, PartialPath storageGroup, long partitionNum) {
        StorageGroupManager storageGroupManager = this.processorMap.get(storageGroup);
        if (storageGroupManager == null) {
            return false;
        }
        Iterator<String> partialPathIterator = tsFileResource.getDevices().iterator();
        try {
            return this.getProcessor(new PartialPath(partialPathIterator.next())).isFileAlreadyExist(tsFileResource, partitionNum);
        }
        catch (IllegalPathException | StorageEngineException e) {
            logger.error("can't find processor with: " + tsFileResource, (Throwable)e);
            return false;
        }
    }

    public void setPartitionVersionToMax(PartialPath storageGroup, long partitionId, long newMaxVersion) {
        this.processorMap.get(storageGroup).setPartitionVersionToMax(partitionId, newMaxVersion);
    }

    public void removePartitions(PartialPath storageGroupPath, DataRegion.TimePartitionFilter filter) {
        if (this.processorMap.get(storageGroupPath) != null) {
            this.processorMap.get(storageGroupPath).removePartitions(filter);
        }
    }

    public Map<PartialPath, StorageGroupManager> getProcessorMap() {
        return this.processorMap;
    }

    public Map<String, List<Pair<Long, Boolean>>> getWorkingStorageGroupPartitions() {
        ConcurrentHashMap<String, List<Pair<Long, Boolean>>> res = new ConcurrentHashMap<String, List<Pair<Long, Boolean>>>();
        for (Map.Entry<PartialPath, StorageGroupManager> entry : this.processorMap.entrySet()) {
            entry.getValue().getWorkingStorageGroupPartitions(entry.getKey().getFullPath(), res);
        }
        return res;
    }

    public void registerFlushListener(FlushListener listener) {
        this.customFlushListeners.add(listener);
    }

    public void registerCloseFileListener(CloseFileListener listener) {
        this.customCloseFileListeners.add(listener);
    }

    public Pair<List<DataRegion>, Map<DataRegion, List<PartialPath>>> mergeLock(List<PartialPath> pathList) throws StorageEngineException {
        HashMap<DataRegion, List> map = new HashMap<DataRegion, List>();
        for (PartialPath path : pathList) {
            map.computeIfAbsent(this.getProcessor(path.getDevicePath()), key -> new ArrayList()).add(path);
        }
        List<DataRegion> list = map.keySet().stream().sorted(Comparator.comparing(DataRegion::getDataRegionId)).collect(Collectors.toList());
        list.forEach(DataRegion::readLock);
        return new Pair(list, map);
    }

    public void mergeUnLock(List<DataRegion> list) {
        list.forEach(DataRegion::readUnlock);
    }

    public String getStorageGroupPath(PartialPath path) throws StorageEngineException {
        PartialPath deviceId = path.getDevicePath();
        DataRegion storageGroupProcessor = this.getProcessor(deviceId);
        return storageGroupProcessor.getStorageGroupName() + File.separator + storageGroupProcessor.getDataRegionId();
    }

    protected void getSeriesSchemas(InsertPlan insertPlan, DataRegion processor) throws StorageEngineException, MetadataException {
        try {
            if (config.isEnableIDTable()) {
                processor.getIdTable().getSeriesSchemas(insertPlan);
            } else {
                IoTDB.schemaProcessor.getSeriesSchemasAndReadLockDevice(insertPlan);
                insertPlan.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(insertPlan.getDevicePath()));
            }
        }
        catch (IOException e) {
            throw new StorageEngineException(e);
        }
    }

    static class InstanceHolder {
        private static final StorageEngine INSTANCE = new StorageEngine();

        private InstanceHolder() {
        }
    }
}

