/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.inner.IInnerSeqSpaceSelector;
import org.apache.iotdb.db.engine.compaction.inner.IInnerUnseqSpaceSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeTieredCompactionSelector
implements IInnerSeqSpaceSelector,
IInnerUnseqSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String storageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected List<TsFileResource> tsFileResources;
    protected boolean sequence;
    protected TsFileManager tsFileManager;
    protected boolean hasNextTimePartition;

    public SizeTieredCompactionSelector(String storageGroupName, String dataRegionId, long timePartition, boolean sequence, TsFileManager tsFileManager) {
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.sequence = sequence;
        this.tsFileManager = tsFileManager;
        this.hasNextTimePartition = tsFileManager.hasNextTimePartition(timePartition, sequence);
    }

    @Override
    public List<List<TsFileResource>> selectInnerSpaceTask(List<TsFileResource> tsFileResources) {
        this.tsFileResources = tsFileResources;
        PriorityQueue<Pair<List<TsFileResource>, Long>> taskPriorityQueue = new PriorityQueue<Pair<List<TsFileResource>, Long>>(new SizeTieredCompactionTaskComparator());
        try {
            int maxLevel = this.searchMaxFileLevel();
            for (int currentLevel = 0; currentLevel <= maxLevel && this.selectLevelTask(currentLevel, taskPriorityQueue); ++currentLevel) {
            }
            LinkedList<List<TsFileResource>> taskList = new LinkedList<List<TsFileResource>>();
            while (taskPriorityQueue.size() > 0) {
                List resources = (List)taskPriorityQueue.poll().left;
                taskList.add(resources);
            }
            return taskList;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs while selecting files", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean selectLevelTask(int level, PriorityQueue<Pair<List<TsFileResource>, Long>> taskPriorityQueue) throws IOException {
        boolean shouldContinueToSearch = true;
        ArrayList<TsFileResource> selectedFileList = new ArrayList<TsFileResource>();
        long selectedFileSize = 0L;
        long targetCompactionFileSize = config.getTargetCompactionFileSize();
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() != level || currentFile.getStatus() != TsFileResourceStatus.CLOSED) {
                selectedFileList.clear();
                selectedFileSize = 0L;
                continue;
            }
            LOGGER.debug("Current File is {}, size is {}", (Object)currentFile, (Object)currentFile.getTsFileSize());
            selectedFileList.add(currentFile);
            LOGGER.debug("Add tsfile {}, current select file num is {}, size is {}", new Object[]{currentFile, selectedFileList.size(), selectedFileSize += currentFile.getTsFileSize()});
            if (selectedFileSize < targetCompactionFileSize && selectedFileList.size() < config.getMaxInnerCompactionCandidateFileNum()) continue;
            if (selectedFileList.size() > 1) {
                taskPriorityQueue.add((Pair<List<TsFileResource>, Long>)new Pair(new ArrayList(selectedFileList), (Object)selectedFileSize));
            }
            selectedFileList = new ArrayList();
            selectedFileSize = 0L;
            shouldContinueToSearch = false;
        }
        if (this.hasNextTimePartition && selectedFileList.size() > 1) {
            taskPriorityQueue.add((Pair<List<TsFileResource>, Long>)new Pair(new ArrayList(selectedFileList), (Object)selectedFileSize));
            shouldContinueToSearch = false;
        }
        return shouldContinueToSearch;
    }

    private int searchMaxFileLevel() throws IOException {
        int maxLevel = -1;
        for (TsFileResource currentFile : this.tsFileResources) {
            TsFileNameGenerator.TsFileName currentName = TsFileNameGenerator.getTsFileName(currentFile.getTsFile().getName());
            if (currentName.getInnerCompactionCnt() <= maxLevel) continue;
            maxLevel = currentName.getInnerCompactionCnt();
        }
        return maxLevel;
    }

    private class SizeTieredCompactionTaskComparator
    implements Comparator<Pair<List<TsFileResource>, Long>> {
        private SizeTieredCompactionTaskComparator() {
        }

        @Override
        public int compare(Pair<List<TsFileResource>, Long> o1, Pair<List<TsFileResource>, Long> o2) {
            TsFileResource resourceOfO1 = (TsFileResource)((List)o1.left).get(0);
            TsFileResource resourceOfO2 = (TsFileResource)((List)o2.left).get(0);
            try {
                TsFileNameGenerator.TsFileName fileNameOfO1 = TsFileNameGenerator.getTsFileName(resourceOfO1.getTsFile().getName());
                TsFileNameGenerator.TsFileName fileNameOfO2 = TsFileNameGenerator.getTsFileName(resourceOfO2.getTsFile().getName());
                if (fileNameOfO1.getInnerCompactionCnt() != fileNameOfO2.getInnerCompactionCnt()) {
                    return fileNameOfO2.getInnerCompactionCnt() - fileNameOfO1.getInnerCompactionCnt();
                }
                return (int)(fileNameOfO2.getVersion() - fileNameOfO1.getVersion());
            }
            catch (IOException e) {
                return 0;
            }
        }
    }
}

