/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegmentedPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SegmentedPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.pagemgr.IPageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageManager
implements IPageManager {
    protected static final Logger logger = LoggerFactory.getLogger(PageManager.class);
    protected final Map<Integer, ISchemaPage> pageInstCache = Collections.synchronizedMap(new LinkedHashMap(SchemaFileConfig.PAGE_CACHE_SIZE, 1.0f, true));
    protected final Map<Integer, ISchemaPage> dirtyPages = new ConcurrentHashMap<Integer, ISchemaPage>();
    protected final ReentrantLock evictLock = new ReentrantLock();
    protected final PageLocks pageLocks = new PageLocks();
    protected final AtomicInteger lastPageIndex;
    protected int[] treeTrace;
    private final FileChannel channel;

    PageManager(FileChannel channel, int lpi) throws IOException, MetadataException {
        this.lastPageIndex = lpi >= 0 ? new AtomicInteger(lpi) : new AtomicInteger(0);
        this.treeTrace = new int[16];
        this.channel = channel;
        if (lpi < 0) {
            ISegmentedPage rootPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), 0);
            rootPage.allocNewSegment((short)16350);
            this.pageInstCache.put(rootPage.getPageIndex(), rootPage);
            this.markDirty(rootPage);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeNewChildren(IMNode node) throws MetadataException, IOException {
        long curSegAddr = SchemaFile.getNodeAddress(node);
        int secIdxEntrance = -1;
        for (Map.Entry entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getNewChildBuffer().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            int subIndex;
            String alias;
            IMNode child = (IMNode)entry.getValue();
            if (!child.isMeasurement()) {
                alias = null;
                if (SchemaFile.getNodeAddress(child) >= 0L) throw new MetadataException("A child in newChildBuffer shall not have segmentAddress.");
                short estSegSize = PageManager.estimateSegmentSize(child);
                long glbIndex = this.preAllocateSegment(estSegSize);
                SchemaFile.setNodeAddress(child, glbIndex);
            } else {
                alias = child.getAsMeasurementMNode().getAlias() == null ? null : child.getAsMeasurementMNode().getAlias();
            }
            ByteBuffer childBuffer = RecordUtils.node2Buffer(child);
            long actualAddress = this.getTargetSegmentAddress(curSegAddr, (String)entry.getKey());
            ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(actualAddress));
            try {
                curPage.getAsSegmentedPage().write(SchemaFile.getSegIndex(actualAddress), (String)entry.getKey(), childBuffer);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
                subIndex = this.subIndexRootPage(curSegAddr);
                if (alias == null || subIndex < 0) continue;
                this.insertSubIndexEntry(subIndex, alias, (String)entry.getKey());
            }
            catch (SchemaPageOverflowException e) {
                if (curPage.getAsSegmentedPage().getSegmentSize(SchemaFile.getSegIndex(actualAddress)) == 16350) {
                    this.multiPageInsertOverflowOperation(curPage, (String)entry.getKey(), childBuffer);
                    subIndex = this.subIndexRootPage(curSegAddr);
                    if (node.isEntity() && subIndex < 0) {
                        this.buildSubIndex(node);
                        continue;
                    }
                    if (alias == null) continue;
                    this.insertSubIndexEntry(subIndex, alias, (String)entry.getKey());
                    continue;
                }
                short actSegId = SchemaFile.getSegIndex(actualAddress);
                short newSegSize = PageManager.reEstimateSegSize(curPage.getAsSegmentedPage().getSegmentSize(actSegId) + childBuffer.capacity());
                ISegmentedPage newPage = this.getMinApplSegmentedPageInMem(newSegSize);
                curSegAddr = newPage.transplantSegment(curPage.getAsSegmentedPage(), actSegId, newSegSize);
                newPage.write(SchemaFile.getSegIndex(curSegAddr), (String)entry.getKey(), childBuffer);
                curPage.getAsSegmentedPage().deleteSegment(actSegId);
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord(node.getParent(), node.getName(), curSegAddr);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
            }
        }
    }

    @Override
    public void writeUpdatedChildren(IMNode node) throws MetadataException, IOException {
        boolean removeOldSubEntry = false;
        boolean insertNewSubEntry = false;
        long curSegAddr = SchemaFile.getNodeAddress(node);
        for (Map.Entry<String, IMNode> entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getUpdatedChildBuffer().entrySet()) {
            int subIndex;
            IMNode oldChild;
            IMNode child = entry.getValue();
            long actualAddress = this.getTargetSegmentAddress(curSegAddr, entry.getKey());
            ByteBuffer childBuffer = RecordUtils.node2Buffer(child);
            ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(actualAddress));
            if (curPage.getAsSegmentedPage().read(SchemaFile.getSegIndex(actualAddress), entry.getKey()) == null) {
                throw new MetadataException(String.format("Node[%s] has no child[%s] in schema file.", node.getName(), entry.getKey()));
            }
            String alias = child.isMeasurement() && child.getAsMeasurementMNode().getAlias() != null ? child.getAsMeasurementMNode().getAlias() : null;
            String oldAlias = node.isEntity() ? ((oldChild = curPage.getAsSegmentedPage().read(SchemaFile.getSegIndex(actualAddress), entry.getKey())).isMeasurement() ? oldChild.getAsMeasurementMNode().getAlias() : null) : null;
            if (alias == null && oldAlias != null) {
                removeOldSubEntry = true;
                insertNewSubEntry = false;
            } else if (alias != null && oldAlias == null) {
                removeOldSubEntry = false;
                insertNewSubEntry = true;
            } else if (alias != null && alias.compareTo(oldAlias) != 0) {
                removeOldSubEntry = true;
                insertNewSubEntry = true;
            } else {
                removeOldSubEntry = false;
                insertNewSubEntry = false;
            }
            try {
                curPage.getAsSegmentedPage().update(SchemaFile.getSegIndex(actualAddress), entry.getKey(), childBuffer);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
                subIndex = this.subIndexRootPage(curSegAddr);
                if (subIndex < 0) continue;
                if (removeOldSubEntry) {
                    this.removeSubIndexEntry(subIndex, oldAlias);
                }
                if (!insertNewSubEntry) continue;
                this.insertSubIndexEntry(subIndex, alias, entry.getKey());
            }
            catch (SchemaPageOverflowException e) {
                if (curPage.getAsSegmentedPage().getSegmentSize(SchemaFile.getSegIndex(actualAddress)) == 16350) {
                    this.multiPageUpdateOverflowOperation(curPage, entry.getKey(), childBuffer);
                    subIndex = this.subIndexRootPage(curSegAddr);
                    if (node.isEntity() && subIndex < 0) {
                        this.buildSubIndex(node);
                        continue;
                    }
                    if (!insertNewSubEntry && !removeOldSubEntry) continue;
                    if (removeOldSubEntry) {
                        this.removeSubIndexEntry(subIndex, oldAlias);
                    }
                    if (!insertNewSubEntry) continue;
                    this.insertSubIndexEntry(subIndex, alias, entry.getKey());
                    continue;
                }
                short actSegId = SchemaFile.getSegIndex(actualAddress);
                short newSegSiz = PageManager.reEstimateSegSize(curPage.getAsSegmentedPage().getSegmentSize(actSegId) + childBuffer.capacity());
                ISegmentedPage newPage = this.getMinApplSegmentedPageInMem(newSegSiz);
                curSegAddr = newPage.transplantSegment(curPage.getAsSegmentedPage(), actSegId, newSegSiz);
                curPage.getAsSegmentedPage().deleteSegment(actSegId);
                newPage.update(SchemaFile.getSegIndex(curSegAddr), entry.getKey(), childBuffer);
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord(node.getParent(), node.getName(), curSegAddr);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
            }
        }
    }

    protected abstract long getTargetSegmentAddress(long var1, String var3) throws IOException, MetadataException;

    protected abstract void multiPageInsertOverflowOperation(ISchemaPage var1, String var2, ByteBuffer var3) throws MetadataException, IOException;

    protected abstract void multiPageUpdateOverflowOperation(ISchemaPage var1, String var2, ByteBuffer var3) throws MetadataException, IOException;

    protected abstract void buildSubIndex(IMNode var1) throws MetadataException, IOException;

    protected abstract void insertSubIndexEntry(int var1, String var2, String var3) throws MetadataException, IOException;

    protected abstract void removeSubIndexEntry(int var1, String var2) throws MetadataException, IOException;

    protected abstract String searchSubIndexAlias(int var1, String var2) throws MetadataException, IOException;

    @Override
    public int getLastPageIndex() {
        return this.lastPageIndex.get();
    }

    @Override
    public void flushDirtyPages() throws IOException {
        for (ISchemaPage page : this.dirtyPages.values()) {
            page.flushPageToChannel(this.channel);
        }
        this.dirtyPages.clear();
    }

    @Override
    public void clear() throws IOException, MetadataException {
        this.dirtyPages.clear();
        this.pageInstCache.clear();
        this.lastPageIndex.set(0);
    }

    @Override
    public StringBuilder inspect(StringBuilder builder) throws IOException, MetadataException {
        for (int i = 0; i <= this.lastPageIndex.get(); ++i) {
            builder.append(String.format("---------------------\n%s\n", this.getPageInstance(i).inspect()));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISchemaPage getPageInstance(int pageIdx) throws IOException, MetadataException {
        if (pageIdx > this.lastPageIndex.get()) {
            throw new MetadataException(String.format("Page index %d out of range.", pageIdx));
        }
        this.pageLocks.readLock(pageIdx);
        try {
            if (this.dirtyPages.containsKey(pageIdx)) {
                ISchemaPage iSchemaPage = this.dirtyPages.get(pageIdx);
                return iSchemaPage;
            }
            if (this.pageInstCache.containsKey(pageIdx)) {
                ISchemaPage iSchemaPage = this.pageInstCache.get(pageIdx);
                return iSchemaPage;
            }
        }
        finally {
            this.pageLocks.readUnlock(pageIdx);
        }
        try {
            this.pageLocks.writeLock(pageIdx);
            ByteBuffer newBuf = ByteBuffer.allocate(16384);
            this.loadFromFile(newBuf, pageIdx);
            ISchemaPage iSchemaPage = this.addPageToCache(pageIdx, ISchemaPage.loadSchemaPage(newBuf));
            return iSchemaPage;
        }
        finally {
            this.pageLocks.writeUnlock(pageIdx);
        }
    }

    @Deprecated
    private long preAllocateSegment(short size) throws IOException, MetadataException {
        ISegmentedPage page = this.getMinApplSegmentedPageInMem(size);
        return SchemaFile.getGlobalIndex(page.getPageIndex(), page.allocNewSegment(size));
    }

    protected ISchemaPage replacePageInCache(ISchemaPage page) {
        this.markDirty(page);
        return this.addPageToCache(page.getPageIndex(), page);
    }

    protected ISegmentedPage getMinApplSegmentedPageInMem(short size) {
        for (Map.Entry<Integer, ISchemaPage> entry : this.dirtyPages.entrySet()) {
            if (entry.getValue().getAsSegmentedPage() == null || !entry.getValue().isCapableForSize(size)) continue;
            return this.dirtyPages.get(entry.getKey()).getAsSegmentedPage();
        }
        for (Map.Entry<Integer, ISchemaPage> entry : this.pageInstCache.entrySet()) {
            if (entry.getValue().getAsSegmentedPage() == null || !entry.getValue().isCapableForSize(size)) continue;
            this.markDirty(entry.getValue());
            return this.pageInstCache.get(entry.getKey()).getAsSegmentedPage();
        }
        return this.allocateNewSegmentedPage().getAsSegmentedPage();
    }

    protected synchronized ISchemaPage allocateNewSegmentedPage() {
        this.lastPageIndex.incrementAndGet();
        ISegmentedPage newPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), this.lastPageIndex.get());
        this.markDirty(newPage);
        return this.addPageToCache(newPage.getPageIndex(), newPage);
    }

    protected synchronized ISchemaPage registerAsNewPage(ISchemaPage page) {
        page.setPageIndex(this.lastPageIndex.incrementAndGet());
        this.markDirty(page);
        return this.addPageToCache(page.getPageIndex(), page);
    }

    protected void markDirty(ISchemaPage page) {
        page.markDirty();
        this.dirtyPages.put(page.getPageIndex(), page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISchemaPage addPageToCache(int pageIndex, ISchemaPage page) {
        this.pageInstCache.put(pageIndex, page);
        if (this.evictLock.tryLock()) {
            try {
                if (this.pageInstCache.size() > SchemaFileConfig.PAGE_CACHE_SIZE) {
                    int removeCnt = (int)(0.2 * (double)this.pageInstCache.size()) > 0 ? (int)(0.2 * (double)this.pageInstCache.size()) : 1;
                    List<Integer> rmvIds = new ArrayList<Integer>(this.pageInstCache.keySet()).subList(0, removeCnt);
                    for (Integer id : rmvIds) {
                        if (!this.pageLocks.findLock(id).writeLock().tryLock()) continue;
                        try {
                            this.pageInstCache.remove(id);
                        }
                        finally {
                            this.pageLocks.findLock(id).writeLock().unlock();
                        }
                    }
                }
            }
            finally {
                this.evictLock.unlock();
            }
        }
        return page;
    }

    private int loadFromFile(ByteBuffer dst, int pageIndex) throws IOException {
        dst.clear();
        return this.channel.read(dst, PageManager.getPageAddress(pageIndex));
    }

    private void updateParentalRecord(IMNode parent, String key, long newSegAddr) throws IOException, MetadataException {
        if (parent == null || parent.getChild(key).isStorageGroup()) {
            throw new MetadataException("Root page shall not be migrated.");
        }
        long parSegAddr = parent.getParent() == null ? 0L : SchemaFile.getNodeAddress(parent);
        parSegAddr = this.getTargetSegmentAddress(parSegAddr, key);
        ISchemaPage page = this.getPageInstance(SchemaFile.getPageIndex(parSegAddr));
        ((SegmentedPage)page).updateRecordSegAddr(SchemaFile.getSegIndex(parSegAddr), key, newSegAddr);
        this.markDirty(page);
    }

    private int subIndexRootPage(long addr) throws IOException, MetadataException {
        return this.getPageInstance(SchemaFile.getPageIndex(addr)).getSubIndex();
    }

    private static long getPageAddress(int pageIndex) {
        return (0xFFFFFFFFL & (long)pageIndex) * 16384L + (long)SchemaFileConfig.FILE_HEADER_SIZE;
    }

    private static short estimateSegmentSize(IMNode node) {
        int childNum = node.getChildren().size();
        int tier = SchemaFileConfig.SEG_SIZE_LST.length;
        for (int i = 1; i < SchemaFileConfig.SEG_SIZE_METRIC.length + 1; ++i) {
            if (childNum <= SchemaFileConfig.SEG_SIZE_METRIC[i - 1]) continue;
            return SchemaFileConfig.SEG_SIZE_LST[tier - i] > SchemaFileConfig.SEG_MIN_SIZ ? SchemaFileConfig.SEG_SIZE_LST[tier - i] : SchemaFileConfig.SEG_MIN_SIZ;
        }
        int totalSize = 25;
        for (IMNode child : node.getChildren().values()) {
            totalSize += child.getName().getBytes().length;
            totalSize += 6;
            if (child.isMeasurement()) {
                totalSize += child.getAsMeasurementMNode().getAlias() == null ? 4 : child.getAsMeasurementMNode().getAlias().getBytes().length + 4;
                totalSize += 24;
                continue;
            }
            totalSize += 16;
        }
        return (short)totalSize > SchemaFileConfig.SEG_MIN_SIZ ? (short)totalSize : SchemaFileConfig.SEG_MIN_SIZ;
    }

    private static short reEstimateSegSize(int expSize) throws MetadataException {
        if (expSize > 16350) {
            throw new MetadataException("Single record larger than half page is not supported in SchemaFile now.");
        }
        for (short size : SchemaFileConfig.SEG_SIZE_LST) {
            if (expSize >= size) continue;
            return size;
        }
        return 16350;
    }

    public long getTargetSegmentAddressOnTest(long curSegAddr, String recKey) throws IOException, MetadataException {
        return this.getTargetSegmentAddress(curSegAddr, recKey);
    }

    public ISchemaPage getPageInstanceOnTest(int pageIdx) throws IOException, MetadataException {
        return this.getPageInstance(pageIdx);
    }

    private static class PageLocks {
        private static final int NUM_OF_LOCKS = 1039;
        private final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[1039];

        protected PageLocks() {
            for (int i = 0; i < 1039; ++i) {
                this.locks[i] = new ReentrantReadWriteLock();
            }
        }

        public void readLock(int hash) {
            this.findLock(hash).readLock().lock();
        }

        public void readUnlock(int hash) {
            this.findLock(hash).readLock().unlock();
        }

        public void writeLock(int hash) {
            this.findLock(hash).writeLock().lock();
        }

        public void writeUnlock(int hash) {
            this.findLock(hash).writeLock().unlock();
        }

        private ReentrantReadWriteLock findLock(int hash) {
            return this.locks[hash % 1039];
        }
    }
}

