/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mtree.store.disk.MTreeFlushTaskManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.MTreeReleaseTaskManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.MemManagerHolder;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;
import org.apache.iotdb.db.metadata.rescon.SchemaStatisticsManager;
import org.apache.iotdb.db.metadata.rescon.SchemaStatisticsManagerMetrics;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.service.metrics.MetricService;

public class SchemaResourceManager {
    private SchemaResourceManager() {
    }

    public static void initSchemaResource() {
        MetricService.getInstance().addMetricSet(new SchemaStatisticsManagerMetrics(SchemaStatisticsManager.getInstance()));
        MemoryStatistics.getInstance().init();
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode().equals(SchemaEngineMode.Schema_File.toString())) {
            SchemaResourceManager.initSchemaFileModeResource();
        }
    }

    public static void clearSchemaResource() {
        SchemaStatisticsManager.getInstance().clear();
        MemoryStatistics.getInstance().clear();
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode().equals(SchemaEngineMode.Schema_File.toString())) {
            SchemaResourceManager.clearSchemaFileModeResource();
        }
    }

    private static void initSchemaFileModeResource() {
        MemManagerHolder.initMemManagerInstance();
        MemManagerHolder.getMemManagerInstance().init();
        MTreeFlushTaskManager.getInstance().init();
        MTreeReleaseTaskManager.getInstance().init();
    }

    private static void clearSchemaFileModeResource() {
        MemManagerHolder.getMemManagerInstance().clear();
        MTreeReleaseTaskManager.getInstance().clear();
        MTreeFlushTaskManager.getInstance().clear();
    }
}

