/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import org.apache.iotdb.db.mpp.aggregation.FirstValueAccumulator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class FirstValueDescAccumulator
extends FirstValueAccumulator {
    public FirstValueDescAccumulator(TSDataType seriesDataType) {
        super(seriesDataType);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    protected int addIntInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateIntFirstValue(column[2].getInt(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    @Override
    protected int addLongInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateLongFirstValue(column[2].getLong(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    @Override
    protected int addFloatInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateFloatFirstValue(column[2].getFloat(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    @Override
    protected int addDoubleInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateDoubleFirstValue(column[2].getDouble(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    @Override
    protected int addBooleanInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateBooleanFirstValue(column[2].getBoolean(i), column[1].getLong(i));
        }
        return curPositionCount;
    }

    @Override
    protected int addBinaryInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.updateBinaryFirstValue(column[2].getBinary(i), column[1].getLong(i));
        }
        return curPositionCount;
    }
}

