/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class LastQueryCollectOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private int currentIndex;

    public LastQueryCollectOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.currentIndex = 0;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.currentIndex < this.inputOperatorsCount) {
            return this.children.get(this.currentIndex).isBlocked();
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public TsBlock next() {
        if (this.children.get(this.currentIndex).hasNext()) {
            return this.children.get(this.currentIndex).next();
        }
        ++this.currentIndex;
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.inputOperatorsCount;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        for (Operator child : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemory());
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateRetainedSizeAfterCallingNext());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnMemory = 0L;
        for (Operator child : this.children) {
            maxReturnMemory = Math.max(maxReturnMemory, child.calculateMaxReturnSize());
        }
        return maxReturnMemory;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long sum = 0L;
        for (Operator operator : this.children) {
            sum += operator.calculateRetainedSizeAfterCallingNext();
        }
        return sum;
    }
}

