/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class UpdateLastCacheOperator
implements ProcessOperator {
    private static final TsBlock LAST_QUERY_EMPTY_TSBLOCK = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT)).build();
    private final OperatorContext operatorContext;
    private final Operator child;
    private final MeasurementPath fullPath;
    private final String dataType;
    private final DataNodeSchemaCache lastCache;
    private final boolean needUpdateCache;
    private final TsBlockBuilder tsBlockBuilder;

    public UpdateLastCacheOperator(OperatorContext operatorContext, Operator child, MeasurementPath fullPath, TSDataType dataType, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.fullPath = fullPath;
        this.dataType = dataType.name();
        this.lastCache = dataNodeSchemaCache;
        this.needUpdateCache = needUpdateCache;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder(1);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        TsBlock res = this.child.next();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        Preconditions.checkArgument((res.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"last query result should only have one record");
        if (res.getColumn(0).isNull(0)) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        long lastTime = res.getColumn(0).getLong(0);
        TsPrimitiveType lastValue = res.getColumn(1).getTsPrimitiveType(0);
        if (this.needUpdateCache) {
            TimeValuePair timeValuePair = new TimeValuePair(lastTime, lastValue);
            this.lastCache.updateLastCache(this.fullPath, timeValuePair, false, (Long)Long.MIN_VALUE);
        }
        this.tsBlockBuilder.reset();
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, this.fullPath.getFullPath(), lastValue.getStringValue(), this.dataType);
        return this.tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return this.child.hasNext();
    }

    @Override
    public boolean isFinished() {
        return this.child.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }
}

