/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.ITemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class ClusterSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final DataNodeSchemaCache schemaCache = DataNodeSchemaCache.getInstance();
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();

    public static ClusterSchemaFetcher getInstance() {
        return ClusterSchemaFetcherHolder.INSTANCE;
    }

    private ClusterSchemaFetcher() {
    }

    @Override
    public ClusterSchemaTree fetchSchema(PathPatternTree patternTree) {
        return this.fetchSchema(patternTree, false);
    }

    @Override
    public ClusterSchemaTree fetchSchemaWithTags(PathPatternTree patternTree) {
        return this.fetchSchema(patternTree, true);
    }

    private ClusterSchemaTree fetchSchema(PathPatternTree patternTree, boolean withTags) {
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        patternTree.constructTree();
        for (PartialPath pattern : patternTree.getAllPathPatterns()) {
            templateMap.putAll(this.templateManager.checkAllRelatedTemplate(pattern));
        }
        return this.executeSchemaFetchQuery(new SchemaFetchStatement(patternTree, templateMap, withTags));
    }

    private ClusterSchemaTree executeSchemaFetchQuery(SchemaFetchStatement schemaFetchStatement) {
        long queryId = SessionManager.getInstance().requestQueryId(false);
        try {
            ExecutionResult executionResult = this.coordinator.execute(schemaFetchStatement, queryId, null, "", ClusterPartitionFetcher.getInstance(), this, this.config.getQueryTimeoutThreshold());
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(String.format("cannot fetch schema, status is: %s, msg is: %s", executionResult.status.getCode(), executionResult.status.getMessage()));
            }
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ClusterSchemaTree result = new ClusterSchemaTree();
                ArrayList<String> storageGroupList = new ArrayList<String>();
                while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                    }
                    catch (IoTDBException e) {
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        this.parseFetchedData(column.getBinary(i), result, storageGroupList);
                    }
                }
                result.setStorageGroups(storageGroupList);
                ClusterSchemaTree clusterSchemaTree = result;
                threadName.close();
                return clusterSchemaTree;
            }
            catch (Throwable throwable) {
                try {
                    threadName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.coordinator.removeQueryExecution(queryId);
        }
    }

    private void parseFetchedData(Binary data, ClusterSchemaTree resultSchemaTree, List<String> storageGroupList) {
        block5: {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getValues());
            try {
                byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
                if (type == 0) {
                    int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
                    for (int i = 0; i < size; ++i) {
                        storageGroupList.add(ReadWriteIOUtils.readString((InputStream)inputStream));
                    }
                    break block5;
                }
                if (type == 1) {
                    resultSchemaTree.mergeSchemaTree(ClusterSchemaTree.deserialize(inputStream));
                    break block5;
                }
                throw new RuntimeException(new MetadataException("Failed to fetch schema because of unrecognized data"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISchemaTree fetchSchemaWithAutoCreate(PartialPath devicePath, String[] measurements, Function<Integer, TSDataType> getDataType, boolean isAligned) {
        this.schemaCache.takeReadLock();
        try {
            ClusterSchemaTree schemaTree = this.schemaCache.get(devicePath, measurements);
            List<Integer> indexOfMissingMeasurements = this.checkMissingMeasurements(schemaTree, devicePath, measurements);
            if (indexOfMissingMeasurements.isEmpty()) {
                ClusterSchemaTree clusterSchemaTree = schemaTree;
                return clusterSchemaTree;
            }
            PathPatternTree patternTree = new PathPatternTree();
            for (int index : indexOfMissingMeasurements) {
                patternTree.appendFullPath(devicePath, measurements[index]);
            }
            ClusterSchemaTree remoteSchemaTree = this.fetchSchema(patternTree);
            if (!remoteSchemaTree.isEmpty()) {
                schemaTree.mergeSchemaTree(remoteSchemaTree);
                this.schemaCache.put(remoteSchemaTree);
            }
            if (!this.config.isAutoCreateSchemaEnabled()) {
                ClusterSchemaTree index = schemaTree;
                return index;
            }
            ClusterSchemaTree missingSchemaTree = this.checkAndAutoCreateMissingMeasurements(remoteSchemaTree, devicePath, indexOfMissingMeasurements, measurements, getDataType, null, null, isAligned);
            schemaTree.mergeSchemaTree(missingSchemaTree);
            this.schemaCache.put(missingSchemaTree);
            ClusterSchemaTree clusterSchemaTree = schemaTree;
            return clusterSchemaTree;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<Boolean> isAlignedList) {
        return this.fetchSchemaListWithAutoCreate(devicePathList, measurementsList, tsDataTypesList, null, null, isAlignedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList) {
        this.schemaCache.takeReadLock();
        try {
            Object indexOfMissingMeasurements;
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            PathPatternTree patternTree = new PathPatternTree();
            ArrayList<Object> indexOfMissingMeasurementsList = new ArrayList<Object>(devicePathList.size());
            for (int i = 0; i < devicePathList.size(); ++i) {
                schemaTree.mergeSchemaTree(this.schemaCache.get(devicePathList.get(i), measurementsList.get(i)));
                indexOfMissingMeasurements = this.checkMissingMeasurements(schemaTree, devicePathList.get(i), measurementsList.get(i));
                indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
                Iterator iterator = indexOfMissingMeasurements.iterator();
                while (iterator.hasNext()) {
                    int index2 = (Integer)iterator.next();
                    patternTree.appendFullPath(devicePathList.get(i), measurementsList.get(i)[index2]);
                }
            }
            if (patternTree.isEmpty()) {
                ClusterSchemaTree i = schemaTree;
                return i;
            }
            ClusterSchemaTree remoteSchemaTree = this.fetchSchema(patternTree);
            if (!remoteSchemaTree.isEmpty()) {
                schemaTree.mergeSchemaTree(remoteSchemaTree);
                this.schemaCache.put(remoteSchemaTree);
            }
            if (!this.config.isAutoCreateSchemaEnabled()) {
                indexOfMissingMeasurements = schemaTree;
                return indexOfMissingMeasurements;
            }
            for (int i = 0; i < devicePathList.size(); ++i) {
                int finalI = i;
                ClusterSchemaTree missingSchemaTree = this.checkAndAutoCreateMissingMeasurements(schemaTree, devicePathList.get(i), (List)indexOfMissingMeasurementsList.get(i), measurementsList.get(i), index -> ((TSDataType[])tsDataTypesList.get(finalI))[index], encodingsList == null ? null : encodingsList.get(i), compressionTypesList == null ? null : compressionTypesList.get(i), isAlignedList.get(i));
                schemaTree.mergeSchemaTree(missingSchemaTree);
                this.schemaCache.put(missingSchemaTree);
            }
            ClusterSchemaTree clusterSchemaTree = schemaTree;
            return clusterSchemaTree;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetInfo(PartialPath path) {
        return this.templateManager.checkTemplateSetInfo(path);
    }

    @Override
    public Map<Integer, Template> checkAllRelatedTemplate(PartialPath pathPattern) {
        return this.templateManager.checkAllRelatedTemplate(pathPattern);
    }

    @Override
    public Pair<Template, List<PartialPath>> getAllPathsSetTemplate(String templateName) {
        return this.templateManager.getAllPathsSetTemplate(templateName);
    }

    private ClusterSchemaTree checkAndAutoCreateMissingMeasurements(ClusterSchemaTree schemaTree, PartialPath devicePath, List<Integer> indexOfMissingMeasurements, String[] measurements, Function<Integer, TSDataType> getDataType, TSEncoding[] encodings, CompressionType[] compressionTypes, boolean isAligned) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, indexOfMissingMeasurements.stream().map(index -> measurements[index]).collect(Collectors.toList()));
        if (deviceSchemaInfo != null) {
            List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
            int removedCount = 0;
            int size = schemaList.size();
            for (int i = 0; i < size; ++i) {
                if (schemaList.get(i) == null) continue;
                indexOfMissingMeasurements.remove(i - removedCount);
                ++removedCount;
            }
        }
        ClusterSchemaTree reFetchedSchemaTree = new ClusterSchemaTree();
        if (indexOfMissingMeasurements.isEmpty()) {
            return reFetchedSchemaTree;
        }
        Pair<Template, PartialPath> templateInfo = this.templateManager.checkTemplateSetInfo(devicePath);
        if (templateInfo != null) {
            Template template = (Template)templateInfo.left;
            boolean shouldActivateTemplate = false;
            for (int index2 : indexOfMissingMeasurements) {
                if (!template.hasSchema(measurements[index2])) continue;
                shouldActivateTemplate = true;
                break;
            }
            if (shouldActivateTemplate) {
                this.internalActivateTemplate(devicePath);
                ArrayList<Integer> recheckedIndexOfMissingMeasurements = new ArrayList<Integer>();
                for (int i = 0; i < indexOfMissingMeasurements.size(); ++i) {
                    if (template.hasSchema(measurements[i])) continue;
                    recheckedIndexOfMissingMeasurements.add(indexOfMissingMeasurements.get(i));
                }
                indexOfMissingMeasurements = recheckedIndexOfMissingMeasurements;
                for (Map.Entry<String, IMeasurementSchema> entry : template.getSchemaMap().entrySet()) {
                    schemaTree.appendSingleMeasurement(devicePath.concatNode(entry.getKey()), (MeasurementSchema)entry.getValue(), null, null, template.isDirectAligned());
                }
                if (indexOfMissingMeasurements.isEmpty()) {
                    return schemaTree;
                }
            }
        }
        ArrayList<String> missingMeasurements = new ArrayList<String>(indexOfMissingMeasurements.size());
        ArrayList<TSDataType> dataTypesOfMissingMeasurement = new ArrayList<TSDataType>(indexOfMissingMeasurements.size());
        ArrayList<TSEncoding> encodingsOfMissingMeasurement = new ArrayList<TSEncoding>(indexOfMissingMeasurements.size());
        ArrayList<CompressionType> compressionTypesOfMissingMeasurement = new ArrayList<CompressionType>(indexOfMissingMeasurements.size());
        indexOfMissingMeasurements.forEach(index -> {
            TSDataType tsDataType = (TSDataType)getDataType.apply((Integer)index);
            missingMeasurements.add(measurements[index]);
            dataTypesOfMissingMeasurement.add(tsDataType);
            encodingsOfMissingMeasurement.add(encodings == null ? EncodingInferenceUtils.getDefaultEncoding(tsDataType) : encodings[index]);
            compressionTypesOfMissingMeasurement.add(compressionTypes == null ? TSFileDescriptor.getInstance().getConfig().getCompressor() : compressionTypes[index]);
        });
        schemaTree.mergeSchemaTree(this.internalCreateTimeseries(devicePath, missingMeasurements, dataTypesOfMissingMeasurement, encodingsOfMissingMeasurement, compressionTypesOfMissingMeasurement, isAligned));
        return schemaTree;
    }

    private List<Integer> checkMissingMeasurements(ISchemaTree schemaTree, PartialPath devicePath, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, Arrays.asList(measurements));
        if (deviceSchemaInfo == null) {
            return IntStream.range(0, measurements.length).boxed().collect(Collectors.toList());
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        for (int i = 0; i < measurements.length; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(i);
        }
        return indexOfMissingMeasurements;
    }

    private ClusterSchemaTree internalCreateTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> tsDataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) {
        List<MeasurementPath> measurementPathList = this.executeInternalCreateTimeseriesStatement(new InternalCreateTimeSeriesStatement(devicePath, measurements, tsDataTypes, encodings, compressors, isAligned));
        Set alreadyExistingMeasurementIndexSet = measurementPathList.stream().map(o -> measurements.indexOf(o.getMeasurement())).collect(Collectors.toSet());
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        schemaTree.appendMeasurementPaths(measurementPathList);
        int size = measurements.size();
        for (int i = 0; i < size; ++i) {
            if (alreadyExistingMeasurementIndexSet.contains(i)) continue;
            schemaTree.appendSingleMeasurement(devicePath.concatNode(measurements.get(i)), new MeasurementSchema(measurements.get(i), tsDataTypes.get(i), encodings.get(i), compressors.get(i)), null, null, isAligned);
        }
        this.schemaCache.put(schemaTree);
        return schemaTree;
    }

    private List<MeasurementPath> executeInternalCreateTimeseriesStatement(InternalCreateTimeSeriesStatement statement) {
        ExecutionResult executionResult = this.executeStatement(statement);
        int statusCode = executionResult.status.getCode();
        if (statusCode == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return Collections.emptyList();
        }
        ArrayList<String> failedCreationList = new ArrayList<String>();
        ArrayList<MeasurementPath> alreadyExistingMeasurements = new ArrayList<MeasurementPath>();
        for (TSStatus subStatus : executionResult.status.subStatus) {
            if (subStatus.code == TSStatusCode.MEASUREMENT_ALREADY_EXIST.getStatusCode()) {
                alreadyExistingMeasurements.add(MeasurementPath.parseDataFromString((String)subStatus.getMessage()));
                continue;
            }
            failedCreationList.add(subStatus.message);
        }
        if (!failedCreationList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String message : failedCreationList) {
                stringBuilder.append(message).append("\n");
            }
            throw new RuntimeException(String.format("Failed to auto create schema\n %s", stringBuilder));
        }
        return alreadyExistingMeasurements;
    }

    public void internalActivateTemplate(PartialPath devicePath) {
        ExecutionResult executionResult = this.executeStatement(new ActivateTemplateStatement(devicePath));
        TSStatus status = executionResult.status;
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            throw new RuntimeException(new IoTDBException(status.getMessage(), status.getCode()));
        }
    }

    private ExecutionResult executeStatement(Statement statement) {
        long queryId = SessionManager.getInstance().requestQueryId(false);
        return this.coordinator.execute(statement, queryId, null, "", ClusterPartitionFetcher.getInstance(), this, this.config.getQueryTimeoutThreshold());
    }

    @Override
    public void invalidAllCache() {
        DataNodeSchemaCache.getInstance().cleanUp();
    }

    private static final class ClusterSchemaFetcherHolder {
        private static final ClusterSchemaFetcher INSTANCE = new ClusterSchemaFetcher();

        private ClusterSchemaFetcherHolder() {
        }
    }
}

