/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.PathNumOverLimitException;

public class ColumnPaginationController {
    private int curLimit = IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum() + 1;
    private int curOffset;
    private int consumed = 0;
    private final boolean isDisabled;

    public ColumnPaginationController(int seriesLimit, int seriesOffset, boolean isDisabled) {
        this.curLimit = seriesLimit == 0 ? this.curLimit : Math.min(seriesLimit, this.curLimit);
        this.curOffset = seriesOffset;
        this.isDisabled = isDisabled;
    }

    public boolean hasCurOffset() {
        if (this.isDisabled) {
            return false;
        }
        return this.curOffset != 0;
    }

    public boolean hasCurLimit() {
        if (this.isDisabled) {
            return true;
        }
        return this.curLimit != 0;
    }

    public void consumeOffset() {
        if (this.isDisabled) {
            return;
        }
        --this.curOffset;
    }

    public void consumeLimit() {
        ++this.consumed;
        if (this.consumed > IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum()) {
            throw new PathNumOverLimitException();
        }
        if (this.isDisabled) {
            return;
        }
        --this.curLimit;
    }
}

