/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.ternary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class TernaryExpression
extends Expression {
    protected final Expression firstExpression;
    protected final Expression secondExpression;
    protected final Expression thirdExpression;

    public Expression getFirstExpression() {
        return this.firstExpression;
    }

    public Expression getSecondExpression() {
        return this.secondExpression;
    }

    public Expression getThirdExpression() {
        return this.thirdExpression;
    }

    protected TernaryExpression(Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        this.firstExpression = firstExpression;
        this.secondExpression = secondExpression;
        this.thirdExpression = thirdExpression;
    }

    protected TernaryExpression(ByteBuffer byteBuffer) {
        this.firstExpression = Expression.deserialize(byteBuffer);
        this.secondExpression = Expression.deserialize(byteBuffer);
        this.thirdExpression = Expression.deserialize(byteBuffer);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTernaryExpression(this, context);
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.firstExpression.isConstantOperand() && this.secondExpression.isConstantOperand() && this.thirdExpression.isConstantOperand();
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public boolean isUserDefinedAggregationFunctionExpression() {
        return this.firstExpression.isBuiltInAggregationFunctionExpression() || this.secondExpression.isBuiltInAggregationFunctionExpression() || this.thirdExpression.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.firstExpression, this.secondExpression, this.thirdExpression);
    }

    @Override
    public final void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList<Expression> firstExpressions = new ArrayList<Expression>();
        this.firstExpression.concat(prefixPaths, firstExpressions);
        ArrayList<Expression> secondExpressions = new ArrayList<Expression>();
        this.secondExpression.concat(prefixPaths, secondExpressions);
        ArrayList<Expression> thirdExpressions = new ArrayList<Expression>();
        this.secondExpression.concat(prefixPaths, thirdExpressions);
        this.reconstruct(firstExpressions, secondExpressions, thirdExpressions, resultExpressions);
    }

    @Override
    public final void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        ArrayList<Expression> firstExpressions = new ArrayList<Expression>();
        this.firstExpression.removeWildcards(wildcardsRemover, firstExpressions);
        ArrayList<Expression> secondExpressions = new ArrayList<Expression>();
        this.secondExpression.removeWildcards(wildcardsRemover, secondExpressions);
        ArrayList<Expression> thirdExpressions = new ArrayList<Expression>();
        this.thirdExpression.removeWildcards(wildcardsRemover, secondExpressions);
        this.reconstruct(firstExpressions, secondExpressions, thirdExpressions, resultExpressions);
    }

    private void reconstruct(List<Expression> firstExpressions, List<Expression> secondExpressions, List<Expression> thirdExpressions, List<Expression> resultExpressions) {
        for (Expression fe : firstExpressions) {
            for (Expression se : secondExpressions) {
                block8: for (Expression te : thirdExpressions) {
                    switch (this.operator()) {
                        case "between": {
                            resultExpressions.add(new BetweenExpression(fe, se, te));
                            continue block8;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        this.firstExpression.collectPaths(pathSet);
        this.secondExpression.collectPaths(pathSet);
        this.thirdExpression.collectPaths(pathSet);
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        return this.firstExpression.isMappable(expressionTypes) && this.secondExpression.isMappable(expressionTypes) && this.thirdExpression.isMappable(expressionTypes);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.firstExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.secondExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.thirdExpression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
        this.firstExpression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        this.secondExpression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        this.thirdExpression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        this.inputColumnIndex = udtfPlan.getReaderIndexByExpressionName(this.toString());
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.firstExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        this.secondExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        this.thirdExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        String digest = this.toString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.firstExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.secondExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.thirdExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    protected abstract String operator();

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.firstExpression, byteBuffer);
        Expression.serialize(this.secondExpression, byteBuffer);
        Expression.serialize(this.thirdExpression, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.firstExpression, stream);
        Expression.serialize(this.secondExpression, stream);
        Expression.serialize(this.thirdExpression, stream);
    }
}

