/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class LastQueryScanNode
extends SeriesSourceNode {
    public static final List<String> LAST_QUERY_HEADER_COLUMNS = ImmutableList.of((Object)"timeseries", (Object)"value", (Object)"dataType");
    private final MeasurementPath seriesPath;
    private TRegionReplicaSet regionReplicaSet;

    public LastQueryScanNode(PlanNodeId id, MeasurementPath seriesPath) {
        super(id);
        this.seriesPath = seriesPath;
    }

    public LastQueryScanNode(PlanNodeId id, MeasurementPath seriesPath, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.seriesPath = seriesPath;
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public MeasurementPath getSeriesPath() {
        return this.seriesPath;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new LastQueryScanNode(this.getPlanNodeId(), this.seriesPath, this.regionReplicaSet);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LAST_QUERY_HEADER_COLUMNS;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQueryScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryScanNode that = (LastQueryScanNode)o;
        return Objects.equals(this.seriesPath, that.seriesPath) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seriesPath, this.regionReplicaSet);
    }

    public String toString() {
        return String.format("LastQueryScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY_SCAN.serialize(byteBuffer);
        this.seriesPath.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY_SCAN.serialize(stream);
        this.seriesPath.serialize((OutputStream)stream);
    }

    public static LastQueryScanNode deserialize(ByteBuffer byteBuffer) {
        MeasurementPath partialPath = (MeasurementPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryScanNode(planNodeId, partialPath);
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.seriesPath;
    }

    @Override
    public Filter getPartitionTimeFilter() {
        return null;
    }
}

