/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SeriesScanNode
extends SeriesSourceNode {
    private final MeasurementPath seriesPath;
    private Ordering scanOrder = Ordering.ASC;
    @Nullable
    private Filter timeFilter;
    @Nullable
    private Filter valueFilter;
    private int limit;
    private int offset;
    private TRegionReplicaSet regionReplicaSet;

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath) {
        super(id);
        this.seriesPath = seriesPath;
    }

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath, Ordering scanOrder) {
        this(id, seriesPath);
        this.scanOrder = scanOrder;
    }

    public SeriesScanNode(PlanNodeId id, MeasurementPath seriesPath, Ordering scanOrder, @Nullable Filter timeFilter, @Nullable Filter valueFilter, int limit, int offset, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, seriesPath, scanOrder);
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        this.limit = limit;
        this.offset = offset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet dataRegion) {
        this.regionReplicaSet = dataRegion;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public void setScanOrder(Ordering scanOrder) {
        this.scanOrder = scanOrder;
    }

    public MeasurementPath getSeriesPath() {
        return this.seriesPath;
    }

    @Nullable
    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(@Nullable Filter timeFilter) {
        this.timeFilter = timeFilter;
    }

    @Nullable
    public Filter getValueFilter() {
        return this.valueFilter;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new SeriesScanNode(this.getPlanNodeId(), this.getSeriesPath(), this.getScanOrder(), this.getTimeFilter(), this.getValueFilter(), this.getLimit(), this.getOffset(), this.regionReplicaSet);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ImmutableList.of((Object)this.seriesPath.getFullPath());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSeriesScan(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SERIES_SCAN.serialize(byteBuffer);
        this.seriesPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.timeFilter.serialize(byteBuffer);
        }
        if (this.valueFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.valueFilter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.offset, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SERIES_SCAN.serialize(stream);
        this.seriesPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.timeFilter.serialize(stream);
        }
        if (this.valueFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.valueFilter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.offset, (OutputStream)stream);
    }

    public static SeriesScanNode deserialize(ByteBuffer byteBuffer) {
        MeasurementPath partialPath = (MeasurementPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Filter timeFilter = null;
        if (isNull == 1) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Filter valueFilter = null;
        if (isNull == 1) {
            valueFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        int limit = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int offset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SeriesScanNode(planNodeId, partialPath, scanOrder, timeFilter, valueFilter, limit, offset, null);
    }

    public String toString() {
        return String.format("SeriesScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeriesScanNode that = (SeriesScanNode)o;
        return this.limit == that.limit && this.offset == that.offset && this.seriesPath.equals((Object)that.seriesPath) && this.scanOrder == that.scanOrder && Objects.equals(this.timeFilter, that.timeFilter) && Objects.equals(this.valueFilter, that.valueFilter) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.seriesPath, this.scanOrder, this.timeFilter, this.valueFilter, this.limit, this.offset, this.regionReplicaSet});
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.seriesPath;
    }

    @Override
    public Filter getPartitionTimeFilter() {
        return this.timeFilter;
    }
}

