/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;

public class CrossSeriesAggregationDescriptor
extends AggregationDescriptor {
    private final Expression outputExpression;

    public CrossSeriesAggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions, Expression outputExpression) {
        super(aggregationFuncName, step, inputExpressions);
        this.outputExpression = outputExpression;
    }

    public CrossSeriesAggregationDescriptor(AggregationDescriptor aggregationDescriptor, Expression outputExpression) {
        super(aggregationDescriptor);
        this.outputExpression = outputExpression;
    }

    public Expression getOutputExpression() {
        return this.outputExpression;
    }

    @Override
    public String getParametersString() {
        return this.outputExpression.getExpressionString();
    }

    @Override
    public Map<String, Expression> getInputColumnCandidateMap() {
        Map<String, Expression> inputColumnNameToExpressionMap = super.getInputColumnCandidateMap();
        List<String> outputColumnNames = this.getOutputColumnNames();
        for (String outputColumnName : outputColumnNames) {
            inputColumnNameToExpressionMap.put(outputColumnName, this.outputExpression);
        }
        return inputColumnNameToExpressionMap;
    }

    @Override
    public CrossSeriesAggregationDescriptor deepClone() {
        return new CrossSeriesAggregationDescriptor(this.getAggregationFuncName(), this.getStep(), this.getInputExpressions(), this.getOutputExpression());
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        Expression.serialize(this.outputExpression, byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        Expression.serialize(this.outputExpression, stream);
    }

    public static CrossSeriesAggregationDescriptor deserialize(ByteBuffer byteBuffer) {
        AggregationDescriptor aggregationDescriptor = AggregationDescriptor.deserialize(byteBuffer);
        Expression outputExpression = Expression.deserialize(byteBuffer);
        return new CrossSeriesAggregationDescriptor(aggregationDescriptor, outputExpression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CrossSeriesAggregationDescriptor that = (CrossSeriesAggregationDescriptor)o;
        return Objects.equals(this.outputExpression, that.outputExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outputExpression);
    }
}

