/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.intermediate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowReader;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableRowRecordListBackedMultiColumnRow;
import org.apache.iotdb.db.mpp.transformation.dag.adapter.ElasticSerializableRowRecordListBackedMultiColumnWindow;
import org.apache.iotdb.db.mpp.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.util.InputRowUtils;
import org.apache.iotdb.db.mpp.transformation.dag.util.LayerCacheUtils;
import org.apache.iotdb.db.mpp.transformation.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInputColumnIntermediateLayer
extends IntermediateLayer
implements IUDFInputDataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiInputColumnIntermediateLayer.class);
    private final LayerPointReader[] layerPointReaders;
    private final TSDataType[] dataTypes;
    private final TimeSelector timeHeap;
    private final boolean[] shouldMoveNext;
    private boolean isFirstIteration = true;
    private Object[] cachedRow = null;

    public MultiInputColumnIntermediateLayer(Expression expression, long queryId, float memoryBudgetInMB, List<LayerPointReader> parentLayerPointReaders) {
        super(expression, queryId, memoryBudgetInMB);
        this.layerPointReaders = parentLayerPointReaders.toArray(new LayerPointReader[0]);
        this.dataTypes = new TSDataType[this.layerPointReaders.length];
        for (int i = 0; i < this.layerPointReaders.length; ++i) {
            this.dataTypes[i] = this.layerPointReaders[i].getDataType();
        }
        this.timeHeap = new TimeSelector(this.layerPointReaders.length << 1, true);
        this.shouldMoveNext = new boolean[this.dataTypes.length];
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return Arrays.asList(this.dataTypes);
    }

    @Override
    public boolean hasNextRowInObjects() throws IOException {
        if (this.cachedRow != null) {
            return true;
        }
        if (this.isFirstIteration) {
            for (LayerPointReader reader : this.layerPointReaders) {
                if (reader.isConstantPointReader()) continue;
                try {
                    if (!reader.next()) continue;
                    this.timeHeap.add(reader.currentTime());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            this.isFirstIteration = false;
        }
        if (this.timeHeap.isEmpty()) {
            return false;
        }
        long minTime = this.timeHeap.pollFirst();
        int columnLength = this.layerPointReaders.length;
        this.cachedRow = new Object[columnLength + 1];
        this.cachedRow[columnLength] = minTime;
        try {
            for (int i = 0; i < columnLength; ++i) {
                LayerPointReader reader = this.layerPointReaders[i];
                if (!reader.next() || !reader.isConstantPointReader() && reader.currentTime() != minTime) continue;
                if (!reader.isCurrentNull()) {
                    switch (reader.getDataType()) {
                        case INT32: {
                            this.cachedRow[i] = reader.currentInt();
                            break;
                        }
                        case INT64: {
                            this.cachedRow[i] = reader.currentLong();
                            break;
                        }
                        case FLOAT: {
                            this.cachedRow[i] = Float.valueOf(reader.currentFloat());
                            break;
                        }
                        case DOUBLE: {
                            this.cachedRow[i] = reader.currentDouble();
                            break;
                        }
                        case BOOLEAN: {
                            this.cachedRow[i] = reader.currentBoolean();
                            break;
                        }
                        case TEXT: {
                            this.cachedRow[i] = reader.currentBinary();
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException("Unsupported data type.");
                        }
                    }
                }
                reader.readyForNext();
                if (reader.isConstantPointReader() || !reader.next()) continue;
                this.timeHeap.add(reader.currentTime());
            }
        }
        catch (QueryProcessException e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    @Override
    public YieldableState canYieldNextRowInObjects() throws IOException {
        YieldableState yieldableState;
        if (this.cachedRow != null) {
            return YieldableState.YIELDABLE;
        }
        if (this.isFirstIteration) {
            for (LayerPointReader reader : this.layerPointReaders) {
                if (reader.isConstantPointReader()) continue;
                try {
                    yieldableState = reader.yield();
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.YIELDABLE) continue;
                    this.timeHeap.add(reader.currentTime());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            this.isFirstIteration = false;
        } else {
            int columnLength = this.layerPointReaders.length;
            for (int i = 0; i < columnLength; ++i) {
                if (!this.shouldMoveNext[i]) continue;
                this.layerPointReaders[i].readyForNext();
                this.shouldMoveNext[i] = false;
            }
            for (LayerPointReader layerPointReader : this.layerPointReaders) {
                try {
                    if (layerPointReader.isConstantPointReader()) continue;
                    yieldableState = layerPointReader.yield();
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.YIELDABLE) continue;
                    this.timeHeap.add(layerPointReader.currentTime());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        if (this.timeHeap.isEmpty()) {
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        long minTime = this.timeHeap.pollFirst();
        int columnLength = this.layerPointReaders.length;
        Object[] row = new Object[columnLength + 1];
        row[columnLength] = minTime;
        try {
            for (int i = 0; i < columnLength; ++i) {
                LayerPointReader reader = this.layerPointReaders[i];
                YieldableState yieldableState2 = reader.yield();
                if (yieldableState2 == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                    for (int j = 0; j <= i; ++j) {
                        this.shouldMoveNext[j] = false;
                    }
                    return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                }
                if (yieldableState2 == YieldableState.NOT_YIELDABLE_NO_MORE_DATA || !reader.isConstantPointReader() && reader.currentTime() != minTime) continue;
                if (!reader.isCurrentNull()) {
                    switch (reader.getDataType()) {
                        case INT32: {
                            row[i] = reader.currentInt();
                            break;
                        }
                        case INT64: {
                            row[i] = reader.currentLong();
                            break;
                        }
                        case FLOAT: {
                            row[i] = Float.valueOf(reader.currentFloat());
                            break;
                        }
                        case DOUBLE: {
                            row[i] = reader.currentDouble();
                            break;
                        }
                        case BOOLEAN: {
                            row[i] = reader.currentBoolean();
                            break;
                        }
                        case TEXT: {
                            row[i] = reader.currentBinary();
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException("Unsupported data type.");
                        }
                    }
                }
                this.shouldMoveNext[i] = true;
            }
            this.cachedRow = row;
        }
        catch (QueryProcessException e) {
            throw new IOException(e.getMessage());
        }
        return YieldableState.YIELDABLE;
    }

    @Override
    public Object[] nextRowInObjects() {
        Object[] returnedRow = this.cachedRow;
        this.cachedRow = null;
        return returnedRow;
    }

    @Override
    public LayerPointReader constructPointReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LayerRowReader constructRowReader() {
        return new LayerRowReader(){
            private final ElasticSerializableRowRecordListBackedMultiColumnRow row;
            private boolean hasCached;
            private boolean currentNull;
            {
                this.row = new ElasticSerializableRowRecordListBackedMultiColumnRow(MultiInputColumnIntermediateLayer.this.dataTypes);
                this.hasCached = false;
                this.currentNull = false;
            }

            @Override
            public YieldableState yield() throws IOException {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                YieldableState yieldableState = MultiInputColumnIntermediateLayer.this.canYieldNextRowInObjects();
                if (yieldableState != YieldableState.YIELDABLE) {
                    return yieldableState;
                }
                Object[] rowRecords = MultiInputColumnIntermediateLayer.this.nextRowInObjects();
                this.currentNull = InputRowUtils.isAllNull(rowRecords);
                this.row.setRowRecord(rowRecords);
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException {
                if (this.hasCached) {
                    return true;
                }
                if (!MultiInputColumnIntermediateLayer.this.hasNextRowInObjects()) {
                    return false;
                }
                Object[] rowRecords = MultiInputColumnIntermediateLayer.this.nextRowInObjects();
                this.currentNull = InputRowUtils.isAllNull(rowRecords);
                this.row.setRowRecord(rowRecords);
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.currentNull = false;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public long currentTime() {
                return this.row.getTime();
            }

            @Override
            public Row currentRow() {
                return this.row;
            }

            @Override
            public boolean isCurrentNull() {
                return this.currentNull;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, final float memoryBudgetInMB) throws QueryProcessException {
        final MultiInputColumnIntermediateLayer udfInputDataSet = this;
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final ElasticSerializableRowRecordList rowRecordList;
            private final ElasticSerializableRowRecordListBackedMultiColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.rowRecordList = new ElasticSerializableRowRecordList(MultiInputColumnIntermediateLayer.this.dataTypes, MultiInputColumnIntermediateLayer.this.queryId, memoryBudgetInMB, 2);
                this.window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(this.rowRecordList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public YieldableState yield() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("MultiInputColumnIntermediateLayer$LayerRowWindowReader: index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                int rowsToBeCollected = endIndex - this.rowRecordList.size();
                if (0 < rowsToBeCollected) {
                    YieldableState yieldableState = LayerCacheUtils.yieldRows(udfInputDataSet, this.rowRecordList, rowsToBeCollected);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        this.beginIndex -= this.slidingStep;
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (this.rowRecordList.size() <= this.beginIndex) {
                        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                    }
                    this.window.seek(this.beginIndex, this.rowRecordList.size(), this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(this.rowRecordList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.hasCached) {
                    return true;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("MultiInputColumnIntermediateLayer$LayerRowWindowReader: index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return false;
                }
                int rowsToBeCollected = endIndex - this.rowRecordList.size();
                if (0 < rowsToBeCollected) {
                    LayerCacheUtils.cacheRows(udfInputDataSet, this.rowRecordList, rowsToBeCollected);
                    if (this.rowRecordList.size() <= this.beginIndex) {
                        return false;
                    }
                    this.window.seek(this.beginIndex, this.rowRecordList.size(), this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(this.rowRecordList.size() - 1));
                } else {
                    this.window.seek(this.beginIndex, endIndex, this.rowRecordList.getTime(this.beginIndex), this.rowRecordList.getTime(endIndex - 1));
                }
                this.hasCached = true;
                return true;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.rowRecordList.setEvictionUpperBound(this.beginIndex + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(final SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final MultiInputColumnIntermediateLayer udfInputDataSet = this;
        final ElasticSerializableRowRecordList rowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableRowRecordListBackedMultiColumnWindow window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(rowRecordList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private boolean hasCached = false;
            private long nextWindowTimeBegin = strategy.getDisplayWindowBegin();
            private int nextIndexBegin = 0;

            @Override
            public YieldableState yield() throws IOException, QueryProcessException {
                if (this.isFirstIteration) {
                    if (rowRecordList.size() == 0 && this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        YieldableState yieldableState = LayerCacheUtils.yieldRow(udfInputDataSet, rowRecordList);
                        if (yieldableState != YieldableState.YIELDABLE) {
                            return yieldableState;
                        }
                        this.nextWindowTimeBegin = rowRecordList.getTime(0);
                    }
                    this.hasAtLeastOneRow = rowRecordList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (rowRecordList.getTime(rowRecordList.size() - 1) < nextWindowTimeEnd) {
                    YieldableState yieldableState = LayerCacheUtils.yieldRow(udfInputDataSet, rowRecordList);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= rowRecordList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != rowRecordList.size() - 1) continue;
                    this.nextIndexBegin = rowRecordList.size();
                }
                int nextIndexEnd = rowRecordList.size();
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (nextWindowTimeEnd > rowRecordList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd;
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                if (this.isFirstIteration) {
                    if (rowRecordList.size() == 0 && LayerCacheUtils.cacheRow(udfInputDataSet, rowRecordList) && this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = rowRecordList.getTime(0);
                    }
                    this.hasAtLeastOneRow = rowRecordList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return true;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return false;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (rowRecordList.getTime(rowRecordList.size() - 1) < nextWindowTimeEnd && LayerCacheUtils.cacheRow(udfInputDataSet, rowRecordList)) {
                }
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= rowRecordList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != rowRecordList.size() - 1) continue;
                    this.nextIndexBegin = rowRecordList.size();
                }
                int nextIndexEnd = rowRecordList.size();
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (nextWindowTimeEnd > rowRecordList.getTime(i)) continue;
                    nextIndexEnd = i;
                    break;
                }
                window.seek(this.nextIndexBegin, nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != nextIndexEnd;
                return this.hasCached;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                rowRecordList.setEvictionUpperBound(this.nextIndexBegin + 1);
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final long sessionTimeGap = strategy.getSessionTimeGap();
        final MultiInputColumnIntermediateLayer udfInputDataSet = this;
        final ElasticSerializableRowRecordList rowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, this.queryId, memoryBudgetInMB, 2);
        final ElasticSerializableRowRecordListBackedMultiColumnWindow window = new ElasticSerializableRowRecordListBackedMultiColumnWindow(rowRecordList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 1;

            @Override
            public YieldableState yield() throws IOException, QueryProcessException {
                YieldableState yieldableState;
                if (this.isFirstIteration) {
                    if (rowRecordList.size() == 0 && (yieldableState = LayerCacheUtils.yieldRow(udfInputDataSet, rowRecordList)) != YieldableState.YIELDABLE) {
                        return yieldableState;
                    }
                    this.nextWindowTimeBegin = Math.max(displayWindowBegin, rowRecordList.getTime(0));
                    this.hasAtLeastOneRow = rowRecordList.size() != 0;
                    this.isFirstIteration = false;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                while (rowRecordList.getTime(rowRecordList.size() - 1) < displayWindowEnd) {
                    yieldableState = LayerCacheUtils.yieldRow(udfInputDataSet, rowRecordList);
                    if (yieldableState == YieldableState.YIELDABLE) {
                        if (rowRecordList.getTime(rowRecordList.size() - 2) >= displayWindowBegin && rowRecordList.getTime(rowRecordList.size() - 1) - rowRecordList.getTime(rowRecordList.size() - 2) >= sessionTimeGap) {
                            this.nextIndexEnd = rowRecordList.size() - 1;
                            break;
                        }
                        ++this.nextIndexEnd;
                        continue;
                    }
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (yieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    this.nextIndexEnd = rowRecordList.size();
                    break;
                }
                this.nextWindowTimeEnd = rowRecordList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                for (int i = this.nextIndexBegin; i < rowRecordList.size(); ++i) {
                    if (this.nextWindowTimeBegin <= rowRecordList.getTime(i)) {
                        this.nextIndexBegin = i;
                        break;
                    }
                    if (i != rowRecordList.size() - 1) continue;
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            @Override
            public boolean next() throws IOException, QueryProcessException {
                return false;
            }

            @Override
            public void readyForNext() throws IOException, QueryProcessException {
                if (this.nextIndexEnd < rowRecordList.size()) {
                    this.nextWindowTimeBegin = rowRecordList.getTime(this.nextIndexEnd);
                }
                rowRecordList.setEvictionUpperBound(this.nextIndexBegin + 1);
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return MultiInputColumnIntermediateLayer.this.dataTypes;
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy strategy, float memoryBudgetInMB) {
        throw new UnsupportedOperationException();
    }
}

