/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateContinuousQueryPlan
extends PhysicalPlan {
    private String querySql;
    private String querySqlBeforeGroupByClause;
    private String querySqlAfterGroupByClause;
    private String continuousQueryName;
    private PartialPath targetPath;
    private long everyInterval;
    private long forInterval;
    private long groupByTimeInterval;
    private String groupByTimeIntervalString;
    private long firstExecutionTimeBoundary;

    public CreateContinuousQueryPlan() {
        super(Operator.OperatorType.CREATE_CONTINUOUS_QUERY);
    }

    public CreateContinuousQueryPlan(String querySql, String continuousQueryName, PartialPath targetPath, long everyInterval, long forInterval, long groupByTimeIntervalUnit, String groupByTimeIntervalString, Long firstExecutionTimeBoundary) {
        super(Operator.OperatorType.CREATE_CONTINUOUS_QUERY);
        this.querySql = querySql;
        String querySqlLowerCase = querySql.toLowerCase();
        int indexOfGroupBy = querySqlLowerCase.indexOf("group by");
        this.querySqlBeforeGroupByClause = indexOfGroupBy == -1 ? querySql : querySql.substring(0, indexOfGroupBy);
        int indexOfLevel = querySqlLowerCase.indexOf("level");
        this.querySqlAfterGroupByClause = indexOfLevel == -1 ? "" : querySql.substring(indexOfLevel);
        this.continuousQueryName = continuousQueryName;
        this.targetPath = targetPath;
        this.everyInterval = everyInterval;
        this.forInterval = forInterval;
        this.groupByTimeInterval = groupByTimeIntervalUnit;
        this.groupByTimeIntervalString = groupByTimeIntervalString;
        this.firstExecutionTimeBoundary = firstExecutionTimeBoundary != null ? firstExecutionTimeBoundary : DateTimeUtils.currentTime();
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public String getQuerySqlBeforeGroupByClause() {
        return this.querySqlBeforeGroupByClause;
    }

    public String getQuerySqlAfterGroupByClause() {
        return this.querySqlAfterGroupByClause;
    }

    public String getContinuousQueryName() {
        return this.continuousQueryName;
    }

    public void setTargetPath(PartialPath targetPath) {
        this.targetPath = targetPath;
    }

    public PartialPath getTargetPath() {
        return this.targetPath;
    }

    public long getEveryInterval() {
        return this.everyInterval;
    }

    public long getForInterval() {
        return this.forInterval;
    }

    public long getGroupByTimeInterval() {
        return this.groupByTimeInterval;
    }

    public String getGroupByTimeIntervalString() {
        return this.groupByTimeIntervalString;
    }

    public long getFirstExecutionTimeBoundary() {
        return this.firstExecutionTimeBoundary;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_CONTINUOUS_QUERY.ordinal());
        ReadWriteIOUtils.write((String)this.continuousQueryName, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.querySql, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.querySqlBeforeGroupByClause, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.querySqlAfterGroupByClause, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.targetPath.getFullPath(), (ByteBuffer)buffer);
        buffer.putLong(this.everyInterval);
        buffer.putLong(this.forInterval);
        buffer.putLong(this.groupByTimeInterval);
        ReadWriteIOUtils.write((String)this.groupByTimeIntervalString, (ByteBuffer)buffer);
        buffer.putLong(this.firstExecutionTimeBoundary);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.continuousQueryName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.querySql = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.querySqlBeforeGroupByClause = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.querySqlAfterGroupByClause = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.targetPath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        this.everyInterval = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        this.forInterval = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        this.groupByTimeInterval = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        this.groupByTimeIntervalString = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.firstExecutionTimeBoundary = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
    }
}

