/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class CreateTimeSeriesPlan
extends PhysicalPlan
implements ICreateTimeSeriesPlan {
    private PartialPath path;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private String alias;
    private Map<String, String> props = null;
    private Map<String, String> tags = null;
    private Map<String, String> attributes = null;
    private long tagOffset = -1L;

    public CreateTimeSeriesPlan() {
        super(Operator.OperatorType.CREATE_TIMESERIES);
        this.canBeSplit = false;
    }

    public CreateTimeSeriesPlan(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String alias) {
        super(Operator.OperatorType.CREATE_TIMESERIES);
        this.path = path;
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressor = compressor;
        this.tags = tags;
        this.attributes = attributes;
        this.alias = alias;
        this.canBeSplit = false;
        if (props != null) {
            this.props = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.props.putAll(props);
        }
    }

    public CreateTimeSeriesPlan(PartialPath path, MeasurementSchema schema) {
        super(Operator.OperatorType.CREATE_TIMESERIES);
        this.path = path;
        this.dataType = schema.getType();
        this.encoding = schema.getEncodingType();
        this.compressor = schema.getCompressor();
        this.canBeSplit = false;
    }

    @Override
    public PartialPath getPath() {
        return this.path;
    }

    @Override
    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public CompressionType getCompressor() {
        return this.compressor;
    }

    @Override
    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    @Override
    public TSEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public Map<String, String> getProps() {
        return this.props;
    }

    @Override
    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public long getTagOffset() {
        return this.tagOffset;
    }

    @Override
    public void setTagOffset(long tagOffset) {
        this.tagOffset = tagOffset;
    }

    public String toString() {
        return String.format("seriesPath: %s, resultDataType: %s, encoding: %s, compression: %s, tagOffset: %s", this.path, this.dataType, this.encoding, this.compressor, this.tagOffset);
    }

    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.path);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_TIMESERIES.ordinal());
        byte[] bytes = this.path.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        stream.write(this.dataType.ordinal());
        stream.write(this.encoding.ordinal());
        stream.write(this.compressor.ordinal());
        stream.writeLong(this.tagOffset);
        if (this.alias != null) {
            stream.write(1);
            ReadWriteIOUtils.write((String)this.alias, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.props != null && !this.props.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.props, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.tags, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            stream.write(1);
            ReadWriteIOUtils.write(this.attributes, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_TIMESERIES.ordinal());
        byte[] bytes = this.path.getFullPath().getBytes();
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        buffer.put((byte)this.dataType.ordinal());
        buffer.put((byte)this.encoding.ordinal());
        buffer.put((byte)this.compressor.ordinal());
        buffer.putLong(this.tagOffset);
        if (this.alias != null) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write((String)this.alias, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        if (this.props != null && !this.props.isEmpty()) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.props, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.tags, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.attributes, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        this.path = new PartialPath(new String(bytes));
        this.dataType = TSDataType.values()[buffer.get()];
        this.encoding = TSEncoding.values()[buffer.get()];
        this.compressor = CompressionType.values()[buffer.get()];
        this.tagOffset = buffer.getLong();
        if (buffer.get() == 1) {
            this.alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.tags = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        if (buffer.get() == 1) {
            this.attributes = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        }
        this.index = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTimeSeriesPlan that = (CreateTimeSeriesPlan)o;
        return Objects.equals(this.path, that.path) && this.dataType == that.dataType && this.encoding == that.encoding && this.compressor == that.compressor && this.tagOffset == that.tagOffset;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.dataType, this.encoding, this.compressor, this.tagOffset);
    }
}

