/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.groupby.impl;

import java.util.Comparator;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.executor.groupby.SlidingWindowGroupByExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class MonotonicQueueSlidingWindowGroupByExecutor
extends SlidingWindowGroupByExecutor {
    private final Comparator<AggregateResult> comparator;

    public MonotonicQueueSlidingWindowGroupByExecutor(TSDataType dataType, String aggrFuncName, boolean ascending, Comparator<AggregateResult> comparator) {
        super(dataType, aggrFuncName, ascending);
        this.comparator = comparator;
    }

    @Override
    public void update(AggregateResult aggregateResult) {
        if (aggregateResult.getResult() == null) {
            return;
        }
        while (!this.deque.isEmpty() && this.comparator.compare(aggregateResult, (AggregateResult)this.deque.getLast()) > 0) {
            this.deque.removeLast();
        }
        this.deque.addLast(aggregateResult);
        if (!this.deque.isEmpty()) {
            this.aggregateResult = (AggregateResult)this.deque.getFirst();
        } else {
            this.aggregateResult.reset();
        }
    }

    @Override
    protected void evictingExpiredValue() {
        while (!this.deque.isEmpty() && !this.inTimeRange(((AggregateResult)this.deque.getFirst()).getTime())) {
            this.deque.removeFirst();
        }
        if (!this.deque.isEmpty()) {
            this.aggregateResult = (AggregateResult)this.deque.getFirst();
        } else {
            this.aggregateResult.reset();
        }
    }
}

