/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.service.metrics.MetricServiceMBean;
import org.apache.iotdb.db.service.metrics.predefined.FileMetrics;
import org.apache.iotdb.db.service.metrics.predefined.ProcessMetrics;
import org.apache.iotdb.db.service.metrics.predefined.SystemMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.metricsets.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.metricsets.predefined.jvm.JvmMetrics;
import org.apache.iotdb.metrics.metricsets.predefined.logback.LogbackMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricService
extends AbstractMetricService
implements MetricServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MetricService.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    private MetricService() {
    }

    public void start() throws StartupException {
        try {
            if (this.isEnable()) {
                logger.info("Start to start metric Service.");
                JMXService.registerMBean((Object)MetricService.getInstance(), (String)this.mbeanName);
                this.startService();
                logger.info("Finish start metric Service");
            }
        }
        catch (Exception e) {
            logger.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    public void restart() {
        logger.info("Restart metric Service.");
        this.restartService();
        logger.info("Finish restart metric Service");
    }

    public void stop() {
        if (this.isEnable()) {
            logger.info("Stop metric Service.");
            this.stopService();
            JMXService.deregisterMBean((String)this.mbeanName);
            logger.info("Finish stop metric Service");
        }
    }

    public void enablePredefinedMetrics(PredefinedMetric metric) {
        Object metricSet;
        switch (metric) {
            case JVM: {
                metricSet = new JvmMetrics();
                break;
            }
            case LOGBACK: {
                metricSet = new LogbackMetrics();
                break;
            }
            case FILE: {
                metricSet = new FileMetrics();
                break;
            }
            case PROCESS: {
                metricSet = new ProcessMetrics();
                break;
            }
            case SYSTEM: {
                metricSet = new SystemMetrics();
                break;
            }
            default: {
                logger.error("Unknown predefined metrics: {}", (Object)metric);
                return;
            }
        }
        metricSet.bindTo((AbstractMetricService)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProperties(ReloadLevel reloadLevel) {
        logger.info("Reload properties of metric service");
        MetricService metricService = this;
        synchronized (metricService) {
            try {
                switch (reloadLevel) {
                    case START_METRIC: {
                        this.isEnableMetric = true;
                        this.start();
                        break;
                    }
                    case STOP_METRIC: {
                        this.stop();
                        this.isEnableMetric = false;
                        break;
                    }
                    case RESTART_METRIC: {
                        this.isEnableMetric = true;
                        this.restart();
                        break;
                    }
                    case RESTART_REPORTER: {
                        this.stopAllReporter();
                        this.loadReporter();
                        this.startAllReporter();
                        logger.info("Finish restart metric reporters.");
                        break;
                    }
                    case NOTHING: {
                        logger.debug("There are nothing change in metric module.");
                        break;
                    }
                }
            }
            catch (StartupException startupException) {
                logger.error("Failed to start metric when reload properties");
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.METRIC_SERVICE;
    }

    public static MetricService getInstance() {
        return MetricsServiceHolder.INSTANCE;
    }

    private static class MetricsServiceHolder {
        private static final MetricService INSTANCE = new MetricService();

        private MetricsServiceHolder() {
        }
    }
}

