/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.metadata.template.TemplateQueryType;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandalonePartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.SessionTimeoutManager;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Operation;
import org.apache.iotdb.db.service.thrift.impl.IClientRPCServiceWithHandler;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.ConfigNodeConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRPCServiceImpl
implements IClientRPCServiceWithHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRPCServiceImpl.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher PARTITION_FETCHER;
    private final ISchemaFetcher SCHEMA_FETCHER;

    public ClientRPCServiceImpl() {
        if (config.isClusterMode()) {
            this.PARTITION_FETCHER = ClusterPartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();
        } else {
            this.PARTITION_FETCHER = StandalonePartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = StandaloneSchemaFetcher.getInstance();
        }
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        TSStatus loginStatus;
        IoTDBConstant.ClientVersion clientVersion = this.parseClientVersion(req);
        try {
            loginStatus = AuthorizerManager.getInstance().checkUser(req.username, req.password);
        }
        catch (ConfigNodeConnectionException e) {
            TSStatus tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.AUTHENTICATION_ERROR, (String)e.getMessage());
            return new TSOpenSessionResp(tsStatus, ServiceProvider.CURRENT_RPC_VERSION);
        }
        BasicOpenSessionResp openSessionResp = new BasicOpenSessionResp();
        long sessionId = -1L;
        if (loginStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            boolean compatible = req.client_protocol.equals((Object)SessionManager.CURRENT_RPC_VERSION);
            if (!compatible) {
                openSessionResp.setCode(TSStatusCode.INCOMPATIBLE_VERSION.getStatusCode());
                openSessionResp.setMessage("The version is incompatible, please upgrade to " + IoTDBConstant.VERSION);
                openSessionResp = openSessionResp.sessionId(sessionId);
            } else {
                openSessionResp.setCode(loginStatus.getCode());
                openSessionResp.setMessage(loginStatus.getMessage());
                sessionId = SESSION_MANAGER.requestSessionId(req.username, req.zoneId, clientVersion);
                LOGGER.info("{}: Login status: {}. User : {}, opens Session-{}", new Object[]{"IoTDB", openSessionResp.getMessage(), req.username, sessionId});
                SessionTimeoutManager.getInstance().register(sessionId);
                openSessionResp = openSessionResp.sessionId(sessionId);
            }
        } else {
            openSessionResp.setMessage(loginStatus.getMessage());
            openSessionResp.setCode(loginStatus.getCode());
            sessionId = SESSION_MANAGER.requestSessionId(req.username, req.zoneId, clientVersion);
            SessionManager.AUDIT_LOGGER.info("User {} opens Session failed with an incorrect password", (Object)req.username);
            SessionTimeoutManager.getInstance().register(sessionId);
            openSessionResp = openSessionResp.sessionId(sessionId);
        }
        TSStatus tsStatus = RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, ServiceProvider.CURRENT_RPC_VERSION);
        return resp.setSessionId(openSessionResp.getSessionId());
    }

    private IoTDBConstant.ClientVersion parseClientVersion(TSOpenSessionReq req) {
        Map configuration = req.configuration;
        if (configuration != null && configuration.containsKey("version")) {
            return IoTDBConstant.ClientVersion.valueOf((String)((String)configuration.get("version")));
        }
        return IoTDBConstant.ClientVersion.V_0_12;
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        SESSION_MANAGER.releaseSessionResource(req.sessionId, this::cleanupQueryExecution);
        return new TSStatus(!SESSION_MANAGER.closeSession(req.sessionId) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        return SESSION_MANAGER.closeOperation(req.sessionId, req.queryId, req.statementId, req.isSetStatementId(), req.isSetQueryId(), this::cleanupQueryExecution);
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = SESSION_MANAGER.getZoneId(sessionId);
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.GET_TIME_ZONE, TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            SESSION_MANAGER.setTimezone(req.sessionId, req.timeZone);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_TIME_ZONE, TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        properties.setBuildInfo(IoTDBConstant.BUILD_INFO);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        properties.setMaxConcurrentClientNum(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum());
        properties.setWatermarkSecretKey(IoTDBDescriptor.getInstance().getConfig().getWatermarkSecretKey());
        properties.setWatermarkBitString(IoTDBDescriptor.getInstance().getConfig().getWatermarkBitString());
        properties.setWatermarkParamMarkRate(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMarkRate());
        properties.setWatermarkParamMaxRightBit(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMaxRightBit());
        properties.setIsReadOnly(CommonDescriptor.getInstance().getConfig().isReadOnly());
        properties.setThriftMaxFrameSize(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
        return properties;
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            SetStorageGroupStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(sessionId)) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create storage group {}", (Object)SESSION_MANAGER.getCurrSessionId(), (Object)storageGroup);
            }
            if ((status = AuthorityChecker.checkAuthority(statement = (SetStorageGroupStatement)StatementGenerator.createStatement(storageGroup), sessionId)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.SET_STORAGE_GROUP, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_STORAGE_GROUP, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create timeseries {}", (Object)SESSION_MANAGER.getCurrSessionId(), (Object)req.getPath());
            }
            PathUtils.isLegalSingleMeasurements(Collections.singletonList(req.getMeasurementAlias()));
            CreateTimeSeriesStatement statement = (CreateTimeSeriesStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create aligned timeseries {}.{}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getMeasurements()});
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurementAlias());
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            CreateAlignedTimeSeriesStatement statement = (CreateAlignedTimeSeriesStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_ALIGNED_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_ALIGNED_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create {} timeseries, the first is {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.getPaths().size(), req.getPaths().get(0)});
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurementAliasList());
            CreateMultiTimeSeriesStatement statement = (CreateMultiTimeSeriesStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_MULTI_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_MULTI_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> path) {
        try {
            if (!SESSION_MANAGER.checkLogin(sessionId)) {
                return this.getNotLoggedInStatus();
            }
            DeleteTimeSeriesStatement statement = StatementGenerator.createDeleteTimeSeriesStatement(path);
            TSStatus status = AuthorityChecker.checkAuthority(statement, sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        try {
            DeleteStorageGroupStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(sessionId)) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} delete {} storage groups, the first is {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), storageGroups.size(), storageGroups.get(0)});
            }
            if ((status = AuthorityChecker.checkAuthority(statement = (DeleteStorageGroupStatement)StatementGenerator.createStatement(storageGroups), sessionId)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_STORAGE_GROUPS, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_STORAGE_GROUPS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        String statement = req.getStatement();
        if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(statement, SESSION_MANAGER.getZoneId(req.getSessionId()));
            if (s == null) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)"This operation type is not supported"));
                return tSExecuteStatementResp;
            }
            TSStatus status = AuthorityChecker.checkAuthority(s, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp costTime = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return costTime;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)req.sessionId, (Object)statement);
            long queryId = SESSION_MANAGER.requestQueryId(req.statementId, true);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), statement, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                return tSExecuteStatementResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution != null && queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    resp.setQueryDataSet(QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize));
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            long costTime = System.currentTimeMillis() - startTime;
            if (costTime >= ServiceProvider.CONFIG.getSlowQueryThreshold()) {
                ServiceProvider.SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)costTime, (Object)statement);
            }
        }
    }

    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> results = new ArrayList<TSStatus>();
        boolean isAllSuccessful = true;
        if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
            return this.getNotLoggedInStatus();
        }
        for (int i = 0; i < req.getStatements().size(); ++i) {
            TSStatus status;
            String statement = (String)req.getStatements().get(i);
            try {
                Statement s = StatementGenerator.createStatement(statement, SESSION_MANAGER.getZoneId(req.getSessionId()));
                if (s == null) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"This operation type is not supported");
                }
                status = AuthorityChecker.checkAuthority(s, req.sessionId);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return status;
                }
                ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
                ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)req.sessionId, (Object)s);
                long queryId = SESSION_MANAGER.requestQueryId(false);
                long t2 = System.currentTimeMillis();
                ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), statement, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
                this.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
                results.add(result.status);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error occurred when executing executeBatchStatement: ", (Throwable)e);
                status = ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_BATCH_STATEMENT));
                if (status.getCode() != TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    isAllSuccessful = false;
                }
                results.add(status);
            }
        }
        this.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        return isAllSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully") : RpcUtils.getStatus(results);
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) throws TException {
        return this.executeStatement(req);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) throws TException {
        return this.executeStatement(req);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
            return RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
        }
        TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(req.queryId);
        SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
        try {
            TSQueryDataSet result = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize);
            boolean hasResultSet = result.bufferForTime().limit() != 0;
            resp.setHasResultSet(hasResultSet);
            resp.setQueryDataSet(result);
            resp.setIsAlign(true);
            ServiceProvider.QUERY_TIME_MANAGER.unRegisterQuery(req.queryId, false);
            if (!hasResultSet) {
                COORDINATOR.removeQueryExecution(req.queryId);
            }
            TSFetchResultsResp tSFetchResultsResp = resp;
            queryName.close();
            return tSFetchResultsResp;
        }
        catch (Throwable throwable) {
            try {
                try {
                    queryName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecords(TSInsertRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.prefixPaths.get(0), req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsStatement statement = (InsertRowsStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.prefixPath, req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsOfOneDeviceStatement statement = (InsertRowsOfOneDeviceStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.prefixPath, req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsOfOneDeviceStatement statement = (InsertRowsOfOneDeviceStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecord(TSInsertRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getTimestamp()});
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            InsertRowStatement statement = (InsertRowStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertMultiTabletsStatement statement = (InsertMultiTabletsStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLETS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            InsertTabletStatement statement = (InsertTabletStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLET, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLET, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.prefixPaths.get(0), req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsStatement statement = (InsertRowsStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                return this.getNotLoggedInStatus();
            }
            DeleteDataStatement statement = StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_DATA, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_DATA, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, SESSION_MANAGER.getZoneId(req.getSessionId()));
            TSStatus status = AuthorityChecker.checkAuthority(s, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Raw Data Query: {}", (Object)req.sessionId, (Object)req);
            long queryId = SESSION_MANAGER.requestQueryId(req.statementId, true);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    resp.setQueryDataSet(QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize));
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_RAW_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            long costTime = System.currentTimeMillis() - startTime;
            if (costTime >= ServiceProvider.CONFIG.getSlowQueryThreshold()) {
                ServiceProvider.SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)costTime, (Object)req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req) {
        if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, SESSION_MANAGER.getZoneId(req.getSessionId()));
            TSStatus status = AuthorityChecker.checkAuthority(s, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Last Data Query: {}", (Object)req.sessionId, (Object)req);
            long queryId = SESSION_MANAGER.requestQueryId(req.statementId, true);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    resp.setQueryDataSet(QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize));
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            long costTime = System.currentTimeMillis() - startTime;
            if (costTime >= ServiceProvider.CONFIG.getSlowQueryThreshold()) {
                ServiceProvider.SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)costTime, (Object)req);
            }
        }
    }

    public long requestStatementId(long sessionId) {
        return SESSION_MANAGER.requestStatementId(sessionId);
    }

    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) {
        try {
            CreateSchemaTemplateStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create schema template {}", (Object)SESSION_MANAGER.getCurrSessionId(), (Object)req.getName());
            }
            if ((status = AuthorityChecker.checkAuthority(statement = StatementGenerator.createStatement(req), req.sessionId)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_SCHEMA_TEMPLATE, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_SCHEMA_TEMPLATE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req) {
        throw new UnsupportedOperationException();
    }

    public TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req) {
        throw new UnsupportedOperationException();
    }

    public TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) {
        TSQueryTemplateResp resp = new TSQueryTemplateResp();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                resp.setStatus(this.getNotLoggedInStatus());
                return resp;
            }
            Statement statement = StatementGenerator.createStatement(req);
            if (statement == null) {
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)(TemplateQueryType.values()[req.getQueryType()].name() + "has not been supported.")));
                return resp;
            }
            switch (TemplateQueryType.values()[req.getQueryType()]) {
                case SHOW_MEASUREMENTS: {
                    resp.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
                    break;
                }
                case SHOW_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_SET_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_USING_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
                }
            }
            return this.executeTemplateQueryStatement(statement, req, resp);
        }
        catch (Exception e) {
            resp.setStatus(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_QUERY_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR));
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSQueryTemplateResp executeTemplateQueryStatement(Statement statement, TSQueryTemplateReq req, TSQueryTemplateResp resp) {
        long startTime = System.currentTimeMillis();
        try {
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)req.sessionId, (Object)statement);
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult executionResult = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), null, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
            if (executionResult.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionResult.status.code != TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
                resp.setStatus(executionResult.status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ArrayList<String> result = new ArrayList<String>();
                while (queryExecution.hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = queryExecution.getBatchResult();
                    }
                    catch (IoTDBException e) {
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        result.add(column.getBinary(i).getStringValue());
                    }
                }
                resp.setMeasurements(result);
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully"));
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                threadName.close();
                return tSQueryTemplateResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    resp.setStatus(ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    TSQueryTemplateResp tSQueryTemplateResp = null;
                    return tSQueryTemplateResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            long costTime = System.currentTimeMillis() - startTime;
            if (costTime >= ServiceProvider.CONFIG.getSlowQueryThreshold()) {
                ServiceProvider.SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)costTime, (Object)statement);
            }
        }
    }

    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        try {
            SetSchemaTemplateStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} set schema template {}.{}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.getTemplateName(), req.getPrefixPath()});
            }
            if ((status = AuthorityChecker.checkAuthority(statement = StatementGenerator.createStatement(req), req.sessionId)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req) throws TException {
        throw new UnsupportedOperationException();
    }

    public TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req) throws TException {
        throw new UnsupportedOperationException();
    }

    public TSStatus handshake(TSyncIdentityInfo info) throws TException {
        return SyncService.getInstance().handshake(info);
    }

    public TSStatus sendPipeData(ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportPipeData(buff);
    }

    public TSStatus sendFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportFile(metaInfo, buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(req.getSessionId())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{SESSION_MANAGER.getCurrSessionId(), req.getPrefixPath(), req.getTimestamp()});
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            InsertRowStatement statement = (InsertRowStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, req.sessionId);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId(false);
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(req.sessionId), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    private TSExecuteStatementResp createResponse(DatasetHeader header, long queryId) {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        resp.setColumnNameIndexMap(header.getColumnNameIndexMap());
        resp.setSgColumns(new ArrayList());
        resp.setColumns(header.getRespColumns());
        resp.setDataTypeList(header.getRespDataTypeList());
        resp.setAliasColumns(header.getRespAliasColumns());
        resp.setIgnoreTimeStamp(header.isIgnoreTimestamp());
        resp.setQueryId(queryId);
        return resp;
    }

    private TSStatus getNotLoggedInStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR, (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private void addOperationLatency(Operation operation, long startTime) {
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnablePerformanceStat().booleanValue()) {
            MetricService.getInstance().histogram(System.currentTimeMillis() - startTime, "operation_histogram", MetricLevel.IMPORTANT, new String[]{"name", operation.getName()});
            MetricService.getInstance().count(1L, "operation_count", MetricLevel.IMPORTANT, new String[]{"name", operation.getName()});
        }
    }

    @Override
    public void handleClientExit() {
        Long sessionId = SESSION_MANAGER.getCurrSessionId();
        if (sessionId != null) {
            TSCloseSessionReq req = new TSCloseSessionReq(sessionId.longValue());
            this.closeSession(req);
        }
        SyncService.getInstance().handleClientExit();
    }

    private void cleanupQueryExecution(Long queryId) {
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        if (queryExecution != null) {
            try (SetThreadName threadName = new SetThreadName(queryExecution.getQueryId());){
                LOGGER.info("[CleanUpQuery]]");
                queryExecution.stopAndCleanup();
                COORDINATOR.removeQueryExecution(queryId);
            }
        }
    }
}

