/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.receiver.load.DeletionLoader;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionPipeData
extends PipeData {
    private static final Logger logger = LoggerFactory.getLogger(DeletionPipeData.class);
    private String storageGroup;
    private Deletion deletion;

    public DeletionPipeData() {
    }

    public DeletionPipeData(Deletion deletion, long serialNumber) {
        this("", deletion, serialNumber);
    }

    public DeletionPipeData(String sgName, Deletion deletion, long serialNumber) {
        super(serialNumber);
        this.storageGroup = sgName;
        this.deletion = deletion;
    }

    @Override
    public PipeData.PipeDataType getType() {
        return PipeData.PipeDataType.DELETION;
    }

    @Override
    public long serialize(DataOutputStream stream) throws IOException {
        return super.serialize(stream) + (long)ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)stream) + this.deletion.serializeWithoutFileOffset(stream);
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        super.deserialize(stream);
        this.storageGroup = ReadWriteIOUtils.readString((InputStream)stream);
        this.deletion = Deletion.deserializeWithoutFileOffset(stream);
    }

    @Override
    public ILoader createLoader() {
        return new DeletionLoader(this.deletion);
    }

    public String toString() {
        return "DeletionData{serialNumber=" + this.serialNumber + ", deletion=" + this.deletion + '}';
    }

    public Deletion getDeletion() {
        return this.deletion;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionPipeData that = (DeletionPipeData)o;
        return Objects.equals(this.deletion, that.deletion) && Objects.equals(this.serialNumber, that.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.deletion, this.serialNumber);
    }
}

