/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.apache.iotdb.db.sync.receiver.load.SchemaLoader;

public class SchemaPipeData
extends PipeData {
    private static final int SERIALIZE_BUFFER_SIZE = 1024;
    private PhysicalPlan plan;

    public SchemaPipeData() {
    }

    public SchemaPipeData(PhysicalPlan plan, long serialNumber) {
        super(serialNumber);
        this.plan = plan;
    }

    @Override
    public PipeData.PipeDataType getType() {
        return PipeData.PipeDataType.SCHEMA;
    }

    @Override
    public long serialize(DataOutputStream stream) throws IOException {
        long serializeSize = super.serialize(stream);
        byte[] bytes = this.getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        return serializeSize += (long)(4 + bytes.length);
    }

    private byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        this.plan.serialize(buffer);
        byte[] bytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        super.deserialize(stream);
        byte[] bytes = new byte[stream.readInt()];
        stream.read(bytes);
        this.plan = PhysicalPlan.Factory.create(ByteBuffer.wrap(bytes));
    }

    @Override
    public ILoader createLoader() {
        return new SchemaLoader(this.plan);
    }

    public String toString() {
        return "SchemaPipeData{serialNumber=" + this.serialNumber + ", plan=" + this.plan + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaPipeData that = (SchemaPipeData)o;
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.serialNumber, that.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.serialNumber);
    }
}

