/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.BackwardSort;
import org.apache.iotdb.db.utils.datastructure.QuickBinaryTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class BackBinaryTVList
extends QuickBinaryTVList
implements BackwardSort {
    private final List<long[]> tmpTimestamps = new ArrayList<long[]>();
    private final List<Binary[]> tmpValues = new ArrayList<Binary[]>();
    private int tmpLength = 0;

    @Override
    public void sort() {
        if (!this.sorted) {
            this.backwardSort(this.timestamps, this.rowCount);
            this.clearTmp();
        }
        this.sorted = true;
    }

    @Override
    public void setFromTmp(int src, int dest) {
        this.set(dest, this.tmpTimestamps.get(src / PrimitiveArrayManager.ARRAY_SIZE)[src % PrimitiveArrayManager.ARRAY_SIZE], this.tmpValues.get(src / PrimitiveArrayManager.ARRAY_SIZE)[src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    public void setToTmp(int src, int dest) {
        this.tmpTimestamps.get((int)(dest / PrimitiveArrayManager.ARRAY_SIZE))[dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.tmpValues.get((int)(dest / PrimitiveArrayManager.ARRAY_SIZE))[dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getBinary(src);
    }

    @Override
    public void backward_set(int src, int dest) {
        this.set(src, dest);
    }

    @Override
    public int compareTmp(int idx, int tmpIdx) {
        long t1 = this.getTime(idx);
        long t2 = this.tmpTimestamps.get(tmpIdx / PrimitiveArrayManager.ARRAY_SIZE)[tmpIdx % PrimitiveArrayManager.ARRAY_SIZE];
        return Long.compare(t1, t2);
    }

    @Override
    public void checkTmpLength(int len) {
        while (len > this.tmpLength) {
            this.tmpTimestamps.add((long[])this.getPrimitiveArraysByType(TSDataType.INT64));
            this.tmpValues.add((Binary[])this.getPrimitiveArraysByType(TSDataType.TEXT));
            this.tmpLength += PrimitiveArrayManager.ARRAY_SIZE;
        }
    }

    @Override
    public void clearTmp() {
        for (Object[] dataArray : this.tmpTimestamps) {
            PrimitiveArrayManager.release(dataArray);
        }
        this.tmpTimestamps.clear();
        Iterator<Object[]> iterator = this.tmpValues.iterator();
        while (iterator.hasNext()) {
            Object[] dataArray;
            dataArray = (Binary[])iterator.next();
            PrimitiveArrayManager.release(dataArray);
        }
        this.tmpValues.clear();
    }
}

