/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

public interface TimSort {
    public static final int SMALL_ARRAY_LENGTH = 32;

    public void tim_set(int var1, int var2);

    public void setFromSorted(int var1, int var2);

    public void setToSorted(int var1, int var2);

    public void setPivotTo(int var1);

    public void saveAsPivot(int var1);

    public void clearSortedTime();

    public void clearSortedValue();

    public int compare(int var1, int var2);

    public void reverseRange(int var1, int var2);

    default public void sort(int lo, int hi) {
        if (lo == hi) {
            return;
        }
        if (hi - lo <= 32) {
            int initRunLen = this.countRunAndMakeAscending(lo, hi);
            this.binarySort(lo, hi, lo + initRunLen);
            return;
        }
        int mid = lo + hi >>> 1;
        this.sort(lo, mid);
        this.sort(mid, hi);
        this.merge(lo, mid, hi);
    }

    default public int countRunAndMakeAscending(int lo, int hi) {
        if (!1.$assertionsDisabled && lo >= hi) {
            throw new AssertionError();
        }
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (this.compare(runHi++, lo) == -1) {
            while (runHi < hi && this.compare(runHi, runHi - 1) == -1) {
                ++runHi;
            }
            this.reverseRange(lo, runHi);
        } else {
            while (runHi < hi && this.compare(runHi, runHi - 1) >= 0) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    default public void binarySort(int lo, int hi, int start) {
        if (!(1.$assertionsDisabled || lo <= start && start <= hi)) {
            throw new AssertionError();
        }
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            int n;
            this.saveAsPivot(start);
            int left = lo;
            int right = start;
            if (!1.$assertionsDisabled && left > right) {
                throw new AssertionError();
            }
            while (left < right) {
                int mid = left + right >>> 1;
                if (this.compare(start, mid) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            if (!1.$assertionsDisabled && left != right) {
                throw new AssertionError();
            }
            for (int i = n = start - left; i >= 1; --i) {
                this.tim_set(left + i - 1, left + i);
            }
            this.setPivotTo(left);
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setToSorted(i, i);
        }
    }

    default public void merge(int lo, int mid, int hi) {
        int end;
        int start;
        int tmpIdx = 0;
        int leftIdx = lo;
        int rightIdx = mid;
        int endSide = 0;
        while (endSide == 0) {
            if (this.compare(leftIdx, rightIdx) <= 0) {
                this.setToSorted(leftIdx, lo + tmpIdx);
                ++tmpIdx;
                if (++leftIdx != mid) continue;
                endSide = 1;
                continue;
            }
            this.setToSorted(rightIdx, lo + tmpIdx);
            ++tmpIdx;
            if (++rightIdx != hi) continue;
            endSide = 2;
        }
        if (endSide == 1) {
            start = rightIdx;
            end = hi;
        } else {
            start = leftIdx;
            end = mid;
        }
        while (start < end) {
            this.setToSorted(start, lo + tmpIdx);
            ++tmpIdx;
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setFromSorted(i, i);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

