/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;

public class LoadDataPlan
extends PhysicalPlan {
    private final String inputFilePath;
    private final String measureType;

    public LoadDataPlan(String inputFilePath, String measureType) {
        super(false, Operator.OperatorType.LOADDATA);
        this.inputFilePath = inputFilePath;
        this.measureType = measureType;
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        if (this.measureType != null) {
            ret.add(new Path(this.measureType));
        }
        return ret;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public String getMeasureType() {
        return this.measureType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadDataPlan)) {
            return false;
        }
        LoadDataPlan that = (LoadDataPlan)o;
        return Objects.equals(this.getInputFilePath(), that.getInputFilePath()) && Objects.equals(this.getMeasureType(), that.getMeasureType());
    }

    public int hashCode() {
        return Objects.hash(this.getInputFilePath(), this.getMeasureType());
    }
}

