/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class AvgAggrFunc
extends AggregateFunction {
    protected double sum = 0.0;
    private int cnt = 0;
    private TSDataType seriesDataType;
    private static final String AVG_AGGR_NAME = "AVG";

    public AvgAggrFunc(TSDataType seriesDataType) {
        super(TSDataType.DOUBLE);
        this.seriesDataType = seriesDataType;
    }

    @Override
    public void init() {
        this.resultData.reset();
        this.sum = 0.0;
        this.cnt = 0;
    }

    @Override
    public AggreResultData getResult() {
        if (this.cnt > 0) {
            this.resultData.setTimestamp(0L);
            this.resultData.setDoubleRet(this.sum / (double)this.cnt);
        }
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        this.sum += pageHeader.getStatistics().getSum();
        this.cnt += pageHeader.getNumOfValues();
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        this.calculateValueFromPageData(dataInThisPage, unsequenceReader, false, 0L);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        this.calculateValueFromPageData(dataInThisPage, unsequenceReader, true, bound);
    }

    private void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, boolean hasBound, long bound) throws IOException {
        while (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            Object sumVal = null;
            long time = Math.min(dataInThisPage.currentTime(), unsequenceReader.current().getTimestamp());
            if (hasBound && time >= bound) break;
            if (dataInThisPage.currentTime() < unsequenceReader.current().getTimestamp()) {
                sumVal = dataInThisPage.currentValue();
                dataInThisPage.next();
            } else if (dataInThisPage.currentTime() == unsequenceReader.current().getTimestamp()) {
                sumVal = unsequenceReader.current().getValue().getValue();
                dataInThisPage.next();
                unsequenceReader.next();
            } else {
                sumVal = unsequenceReader.current().getValue().getValue();
                unsequenceReader.next();
            }
            this.updateMean(this.seriesDataType, sumVal);
        }
        while (dataInThisPage.hasNext() && (!hasBound || dataInThisPage.currentTime() < bound)) {
            this.updateMean(this.seriesDataType, dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    private void updateMean(TSDataType type, Object sumVal) throws IOException {
        switch (type) {
            case INT32: {
                this.sum += (double)((Integer)sumVal).intValue();
                break;
            }
            case INT64: {
                this.sum += (double)((Long)sumVal).longValue();
                break;
            }
            case FLOAT: {
                this.sum += (double)((Float)sumVal).floatValue();
                break;
            }
            case DOUBLE: {
                this.sum += ((Double)sumVal).doubleValue();
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported data type in aggregation %s : %s", this.getAggreTypeName(), type));
            }
        }
        ++this.cnt;
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        while (unsequenceReader.hasNext()) {
            TimeValuePair pair = unsequenceReader.next();
            this.updateMean(this.seriesDataType, pair.getValue().getValue());
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            TimeValuePair pair = unsequenceReader.next();
            this.updateMean(this.seriesDataType, pair.getValue().getValue());
        }
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.updateMean(this.seriesDataType, value);
        }
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    public String getAggreTypeName() {
        return AVG_AGGR_NAME;
    }
}

