/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.iot.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.BaseStateMachine;
import org.apache.iotdb.db.consensus.statemachine.visitor.DataExecutionVisitor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.snapshot.SnapshotLoader;
import org.apache.iotdb.db.engine.snapshot.SnapshotTaker;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionStateMachine
extends BaseStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(DataRegionStateMachine.class);
    private static final FragmentInstanceManager QUERY_INSTANCE_MANAGER = FragmentInstanceManager.getInstance();
    protected DataRegion region;

    public DataRegionStateMachine(DataRegion region) {
        this.region = region;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly() && !CommonDescriptor.getInstance().getConfig().isStopping();
    }

    public boolean takeSnapshot(File snapshotDir) {
        try {
            return new SnapshotTaker(this.region).takeFullSnapshot(snapshotDir.getAbsolutePath(), true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionId(), snapshotDir, e});
            return false;
        }
    }

    public boolean takeSnapshot(File snapshotDir, String snapshotTmpId, String snapshotId) {
        try {
            return new SnapshotTaker(this.region).takeFullSnapshot(snapshotDir.getAbsolutePath(), snapshotTmpId, snapshotId, true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionId(), snapshotDir, e});
            return false;
        }
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        DataRegion newRegion = new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getDatabaseName(), this.region.getDataRegionId()).loadSnapshotForStateMachine();
        if (newRegion == null) {
            logger.error("Fail to load snapshot from {}", (Object)latestSnapshotRootDir);
            return;
        }
        this.region = newRegion;
        try {
            StorageEngine.getInstance().setDataRegion(new DataRegionId(Integer.parseInt(this.region.getDataRegionId())), this.region);
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            BloomFilterCache.getInstance().clear();
        }
        catch (Exception e) {
            logger.error("Exception occurs when replacing data region in storage engine.", (Throwable)e);
        }
    }

    protected PlanNode grabInsertNode(IndexedConsensusRequest indexedRequest) {
        ArrayList<InsertNode> insertNodes = new ArrayList<InsertNode>(indexedRequest.getRequests().size());
        for (IConsensusRequest req : indexedRequest.getRequests()) {
            PlanNode planNode = this.getPlanNode(req);
            if (planNode instanceof InsertNode) {
                InsertNode innerNode = (InsertNode)planNode;
                innerNode.setSearchIndex(indexedRequest.getSearchIndex());
                insertNodes.add(innerNode);
                continue;
            }
            if (indexedRequest.getRequests().size() == 1) {
                return planNode;
            }
            throw new IllegalArgumentException("PlanNodes in IndexedConsensusRequest are not InsertNode and the size of requests are larger than 1");
        }
        return this.mergeInsertNodes(insertNodes);
    }

    protected InsertNode mergeInsertNodes(List<InsertNode> insertNodes) {
        InsertNode result;
        int size = insertNodes.size();
        if (size == 0) {
            throw new RuntimeException();
        }
        if (size == 1) {
            return insertNodes.get(0);
        }
        if (insertNodes.get(0) instanceof InsertTabletNode) {
            ArrayList<Integer> index = new ArrayList<Integer>(size);
            ArrayList<InsertTabletNode> insertTabletNodes = new ArrayList<InsertTabletNode>(size);
            int i = 0;
            for (InsertNode insertNode : insertNodes) {
                insertTabletNodes.add((InsertTabletNode)insertNode);
                index.add(i);
                ++i;
            }
            result = new InsertMultiTabletsNode(insertNodes.get(0).getPlanNodeId(), index, insertTabletNodes);
        } else {
            boolean sameDevice = true;
            PartialPath device = insertNodes.get(0).getDevicePath();
            ArrayList<Integer> index = new ArrayList<Integer>(size);
            ArrayList<InsertRowNode> insertRowNodes = new ArrayList<InsertRowNode>(size);
            int i = 0;
            for (InsertNode insertNode : insertNodes) {
                if (sameDevice && !insertNode.getDevicePath().equals((Object)device)) {
                    sameDevice = false;
                }
                insertRowNodes.add((InsertRowNode)insertNode);
                index.add(i);
                ++i;
            }
            result = sameDevice ? new InsertRowsOfOneDeviceNode(insertNodes.get(0).getPlanNodeId(), index, insertRowNodes) : new InsertRowsNode(insertNodes.get(0).getPlanNodeId(), index, insertRowNodes);
        }
        ((InsertNode)result).setSearchIndex(insertNodes.get(0).getSearchIndex());
        result.setDevicePath(insertNodes.get(0).getDevicePath());
        return result;
    }

    public List<Path> getSnapshotFiles(File latestSnapshotRootDir) {
        try {
            return new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getDatabaseName(), this.region.getDataRegionId()).getSnapshotFileInfo().stream().map(File::toPath).collect(Collectors.toList());
        }
        catch (IOException e) {
            logger.error("Meets error when getting snapshot files for {}-{}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionId(), e});
            return null;
        }
    }

    public TSStatus write(IConsensusRequest request) {
        try {
            return this.write((PlanNode)request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    protected TSStatus write(PlanNode planNode) {
        return planNode.accept(new DataExecutionVisitor(), this.region);
    }

    public DataSet read(IConsensusRequest request) {
        FragmentInstance fragmentInstance;
        if (request instanceof GetConsensusReqReaderPlan) {
            return this.region.getWALNode();
        }
        try {
            fragmentInstance = this.getFragmentInstance(request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return null;
        }
        return QUERY_INSTANCE_MANAGER.execDataQueryFragmentInstance(fragmentInstance, this.region);
    }

    public boolean shouldRetry(TSStatus writeResult) {
        return super.shouldRetry(writeResult);
    }

    public TSStatus updateResult(TSStatus previousResult, TSStatus retryResult) {
        return super.updateResult(previousResult, retryResult);
    }

    public long getSleepTime() {
        return super.getSleepTime();
    }

    public File getSnapshotRoot() {
        String snapshotDir = IoTDBDescriptor.getInstance().getConfig().getRatisDataRegionSnapshotDir() + File.separator + this.region.getDatabaseName() + "-" + this.region.getDataRegionId();
        try {
            return new File(snapshotDir).getCanonicalFile();
        }
        catch (IOException e) {
            logger.warn("{}: cannot get the canonical file of {} due to {}", new Object[]{this, snapshotDir, e});
            return null;
        }
    }
}

