/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StampedWriterPreferredLock {
    private final Lock lock = new ReentrantLock();
    private final Condition okToRead = this.lock.newCondition();
    private final Condition okToWrite = this.lock.newCondition();
    private long stampAllocator = 0L;
    private final Map<Long, Integer> readCnt = new HashMap<Long, Integer>();
    private int readWait = 0;
    private int writeCnt = 0;
    private int writeWait = 0;
    private final ThreadLocal<Long> sharedOwnerStamp = new ThreadLocal();

    public long stampedReadLock() {
        this.lock.lock();
        try {
            long l = this.acquireReadLockStamp();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void threadReadLock() {
        this.lock.lock();
        try {
            Long allocateStamp = this.sharedOwnerStamp.get();
            if (allocateStamp == null) {
                this.sharedOwnerStamp.set(this.acquireReadLockStamp());
            } else {
                this.readCnt.put(allocateStamp, this.readCnt.get(allocateStamp) + 1);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private long acquireReadLockStamp() {
        if (this.writeCnt + this.writeWait > 0) {
            ++this.readWait;
            try {
                this.okToRead.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                --this.readWait;
            }
        }
        long allocateStamp = this.allocateUniqueStamp();
        this.readCnt.put(allocateStamp, 1);
        return allocateStamp;
    }

    private long allocateUniqueStamp() {
        if (++this.stampAllocator < 0L) {
            this.stampAllocator = 1L;
        }
        return this.stampAllocator;
    }

    public void stampedReadUnlock(long stamp) {
        this.lock.lock();
        try {
            if (this.readCnt.containsKey(stamp)) {
                if (this.readCnt.get(stamp) == 1) {
                    this.readCnt.remove(stamp);
                    if (this.readCnt.isEmpty() && this.writeWait > 0) {
                        this.okToWrite.signalAll();
                    }
                } else {
                    this.readCnt.put(stamp, this.readCnt.get(stamp) - 1);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void threadReadUnlock() {
        this.lock.lock();
        try {
            if (this.sharedOwnerStamp.get() != null) {
                long allocateStamp = this.sharedOwnerStamp.get();
                this.stampedReadUnlock(allocateStamp);
                if (!this.readCnt.containsKey(allocateStamp)) {
                    this.sharedOwnerStamp.remove();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void writeLock() {
        this.lock.lock();
        try {
            while (!this.readCnt.isEmpty() || this.writeCnt > 0) {
                ++this.writeWait;
                try {
                    this.okToWrite.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    --this.writeWait;
                }
            }
            ++this.writeCnt;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unlockWrite() {
        this.lock.lock();
        try {
            --this.writeCnt;
            if (this.writeCnt == 0) {
                if (this.writeWait > 0) {
                    this.okToWrite.signalAll();
                } else if (this.readWait > 0) {
                    this.okToRead.signalAll();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

