/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.mpp.common.schematree.visitor.SchemaTreeVisitor;

public class SchemaTreeVisitorWithLimitOffsetWrapper<R>
extends SchemaTreeVisitor<R> {
    private final SchemaTreeVisitor<R> visitor;
    private final int limit;
    private final int offset;
    private final boolean hasLimit;
    private int count = 0;
    int curOffset = 0;

    public SchemaTreeVisitorWithLimitOffsetWrapper(SchemaTreeVisitor<R> visitor, int limit, int offset) {
        this.visitor = visitor;
        this.limit = limit;
        this.offset = offset;
        boolean bl = this.hasLimit = limit > 0 || offset > 0;
        if (this.hasLimit) {
            while (this.curOffset < offset && visitor.hasNext()) {
                visitor.next();
                ++this.curOffset;
            }
        }
    }

    public boolean hasNext() {
        if (this.hasLimit) {
            return this.count < this.limit && this.visitor.hasNext();
        }
        return this.visitor.hasNext();
    }

    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.visitor.next();
        if (this.hasLimit) {
            ++this.count;
        }
        return (R)result;
    }

    public void close() {
        this.visitor.close();
    }

    @Override
    public List<R> getAllResult() {
        ArrayList<R> result = new ArrayList<R>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }

    protected boolean acceptInternalMatchedNode(SchemaNode node) {
        return false;
    }

    protected boolean acceptFullMatchedNode(SchemaNode node) {
        return false;
    }

    protected R generateResult(SchemaNode nextMatchedNode) {
        return null;
    }

    public void reset() {
        this.visitor.reset();
        this.count = 0;
        this.curOffset = 0;
        if (this.hasLimit) {
            while (this.curOffset < this.offset && this.visitor.hasNext()) {
                this.visitor.next();
                ++this.curOffset;
            }
        }
    }

    public int getNextOffset() {
        return this.curOffset + this.count;
    }
}

