/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class RowBasedTimeJoinOperator
extends AbstractConsumeAllOperator {
    private final int[] inputIndex;
    private final int[] shadowInputIndex;
    private final boolean[] noMoreTsBlocks;
    private final TimeSelector timeSelector;
    private final int outputColumnCount;
    private final List<TSDataType> dataTypes;
    private final List<ColumnMerger> mergers;
    private final TsBlockBuilder tsBlockBuilder;
    private boolean finished;
    private final TimeComparator comparator;

    public RowBasedTimeJoinOperator(OperatorContext operatorContext, List<Operator> children, Ordering mergeOrder, List<TSDataType> dataTypes, List<ColumnMerger> mergers, TimeComparator comparator) {
        super(operatorContext, children);
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"child size of TimeJoinOperator should be larger than 0");
        this.inputIndex = new int[this.inputOperatorsCount];
        this.shadowInputIndex = new int[this.inputOperatorsCount];
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.timeSelector = new TimeSelector(this.inputOperatorsCount << 1, Ordering.ASC == mergeOrder);
        this.outputColumnCount = dataTypes.size();
        this.dataTypes = dataTypes;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.mergers = mergers;
        this.comparator = comparator;
        this.maxReturnSize = Math.min(this.maxReturnSize, (1L + (long)this.outputColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i)) continue;
            ListenableFuture<?> blocked = ((Operator)this.children.get(i)).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        long currentTime;
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        this.tsBlockBuilder.reset();
        if (!this.prepareInput()) {
            return null;
        }
        long currentEndTime = 0L;
        boolean init = false;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i]) continue;
            currentEndTime = init ? this.comparator.getCurrentEndTime(currentEndTime, this.inputTsBlocks[i].getEndTime()) : this.inputTsBlocks[i].getEndTime();
            init = true;
        }
        if (this.timeSelector.isEmpty()) {
            TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(0, this.dataTypes);
            return tsBlockBuilder.build();
        }
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        do {
            int i;
            currentTime = this.timeSelector.pollFirst();
            timeBuilder.writeLong(currentTime);
            for (i = 0; i < this.outputColumnCount; ++i) {
                ColumnMerger merger = this.mergers.get(i);
                merger.mergeColumn(this.inputTsBlocks, this.inputIndex, this.shadowInputIndex, currentTime, this.tsBlockBuilder.getColumnBuilder(i));
            }
            for (i = 0; i < this.inputOperatorsCount; ++i) {
                if (this.inputIndex[i] == this.shadowInputIndex[i]) continue;
                this.inputIndex[i] = this.shadowInputIndex[i];
                if (this.isEmpty(i)) continue;
                this.updateTimeSelector(i);
            }
            this.tsBlockBuilder.declarePosition();
        } while (currentTime < currentEndTime && !this.timeSelector.isEmpty());
        this.resultTsBlock = this.tsBlockBuilder.build();
        return this.checkTsBlockSizeAndGetResult();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        if (this.retainedTsBlock != null) {
            return true;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (!this.canCallNext[i] || ((Operator)this.children.get(i)).hasNextWithTimer()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return false;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        if (this.retainedTsBlock != null) {
            return false;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.isEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemory());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    private void updateTimeSelector(int index) {
        this.timeSelector.add(this.inputTsBlocks[index].getTimeByIndex(this.inputIndex[index]));
    }

    @Override
    protected boolean prepareInput() throws Exception {
        boolean allReady = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i)) continue;
            if (this.canCallNext[i]) {
                if (((Operator)this.children.get(i)).hasNextWithTimer()) {
                    this.inputTsBlocks[i] = this.getNextTsBlock(i);
                    this.canCallNext[i] = false;
                    if (this.isEmpty(i)) {
                        allReady = false;
                        continue;
                    }
                    this.updateTimeSelector(i);
                    continue;
                }
                this.noMoreTsBlocks[i] = true;
                this.inputTsBlocks[i] = null;
                continue;
            }
            allReady = false;
        }
        return allReady;
    }

    public List<Operator> getChildren() {
        return this.children;
    }

    @Override
    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        this.inputIndex[childIndex] = 0;
        return ((Operator)this.children.get(childIndex)).nextWithTimer();
    }

    @Override
    protected boolean isEmpty(int columnIndex) {
        return this.inputTsBlocks[columnIndex] == null || this.inputTsBlocks[columnIndex].getPositionCount() == this.inputIndex[columnIndex];
    }
}

