/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryResourceMetricSet
implements IMetricSet {
    public static final String SEQUENCE_TSFILE = "sequence_tsfile";
    public static final String UNSEQUENCE_TSFILE = "unsequence_tsfile";
    public static final String FLUSHING_MEMTABLE = "flushing_memtable";
    public static final String WORKING_MEMTABLE = "working_memtable";
    private static final String metric = Metric.QUERY_RESOURCE.toString();
    private final String tagKey = Tag.TYPE.toString();
    private static final List<String> resourceTypes = Arrays.asList("sequence_tsfile", "unsequence_tsfile", "flushing_memtable", "working_memtable");

    public void bindTo(AbstractMetricService metricService) {
        for (String type : resourceTypes) {
            metricService.getOrCreateHistogram(metric, MetricLevel.IMPORTANT, new String[]{this.tagKey, type});
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (String type : resourceTypes) {
            metricService.remove(MetricType.HISTOGRAM, metric, new String[]{this.tagKey, type});
        }
    }
}

