/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class ConcatPathRewriter {
    private PathPatternTree patternTree;

    public Statement rewrite(Statement statement, PathPatternTree patternTree) throws StatementAnalyzeException {
        QueryStatement queryStatement = (QueryStatement)statement;
        this.patternTree = patternTree;
        List<PartialPath> prefixPaths = queryStatement.getFromComponent().getPrefixPaths();
        if (queryStatement.isAlignByDevice()) {
            for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(resultColumn.getExpression(), prefixPaths, patternTree);
            }
            if (queryStatement.hasGroupByExpression()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getGroupByComponent().getControlColumnExpression(), prefixPaths, patternTree);
            }
        } else {
            List<ResultColumn> resultColumns = this.concatSelectWithFrom(queryStatement.getSelectComponent(), prefixPaths, queryStatement.isGroupByLevel());
            queryStatement.getSelectComponent().setResultColumns(resultColumns);
            if (queryStatement.hasGroupByExpression()) {
                queryStatement.getGroupByComponent().setControlColumnExpression(this.contactGroupByWithFrom(queryStatement.getGroupByComponent().getControlColumnExpression(), prefixPaths));
            }
        }
        if (queryStatement.getWhereCondition() != null) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getWhereCondition().getPredicate(), prefixPaths, patternTree);
        }
        if (queryStatement.getHavingCondition() != null) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getHavingCondition().getPredicate(), prefixPaths, patternTree);
        }
        return queryStatement;
    }

    private List<ResultColumn> concatSelectWithFrom(SelectComponent selectComponent, List<PartialPath> prefixPaths, boolean isGroupByLevel) throws StatementAnalyzeException {
        ArrayList<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            boolean needAliasCheck = resultColumn.hasAlias() && !isGroupByLevel;
            List<Expression> resultExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(resultColumn.getExpression(), prefixPaths, this.patternTree);
            if (needAliasCheck && resultExpressions.size() > 1) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
            }
            for (Expression resultExpression : resultExpressions) {
                resultColumns.add(new ResultColumn(resultExpression, resultColumn.getAlias(), resultColumn.getColumnType()));
            }
        }
        return resultColumns;
    }

    private Expression contactGroupByWithFrom(Expression expression, List<PartialPath> prefixPaths) {
        List<Expression> resultExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(expression, prefixPaths, this.patternTree);
        if (resultExpressions.size() != 1) {
            throw new IllegalStateException("Expression in group by should indicate one value");
        }
        return resultExpressions.get(0);
    }
}

