/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.udf.builtin.BuiltinFunction;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.analyze.GroupByLevelController;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;

public class ExpressionAnalyzer {
    public static void checkIsAllMeasurement(Expression expression) {
        if (expression instanceof TernaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((TernaryExpression)expression).getFirstExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((TernaryExpression)expression).getSecondExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((TernaryExpression)expression).getThirdExpression());
        } else if (expression instanceof BinaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((BinaryExpression)expression).getLeftExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((BinaryExpression)expression).getRightExpression());
        } else if (expression instanceof UnaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((UnaryExpression)expression).getExpression());
        } else if (expression instanceof FunctionExpression) {
            for (Expression childExpression : expression.getExpressions()) {
                ExpressionAnalyzer.checkIsAllMeasurement(childExpression);
            }
        } else if (expression instanceof TimeSeriesOperand) {
            PartialPath path = ((TimeSeriesOperand)expression).getPath();
            if (path.getNodes().length > 1 || path.getFullPath().equals("**")) {
                throw new SemanticException("the suffix paths can only be measurement or one-level wildcard");
            }
        } else if (!(expression instanceof TimestampOperand) && !(expression instanceof ConstantOperand)) {
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
        }
    }

    public static ResultColumn.ColumnType identifyOutputColumnType(Expression expression, boolean isRoot) {
        if (expression instanceof TernaryExpression) {
            ResultColumn.ColumnType firstType = ExpressionAnalyzer.identifyOutputColumnType(((TernaryExpression)expression).getFirstExpression(), false);
            ResultColumn.ColumnType secondType = ExpressionAnalyzer.identifyOutputColumnType(((TernaryExpression)expression).getSecondExpression(), false);
            ResultColumn.ColumnType thirdType = ExpressionAnalyzer.identifyOutputColumnType(((TernaryExpression)expression).getThirdExpression(), false);
            boolean rawFlag = false;
            boolean aggregationFlag = false;
            if (firstType == ResultColumn.ColumnType.RAW || secondType == ResultColumn.ColumnType.RAW || thirdType == ResultColumn.ColumnType.RAW) {
                rawFlag = true;
            }
            if (firstType == ResultColumn.ColumnType.AGGREGATION || secondType == ResultColumn.ColumnType.AGGREGATION || thirdType == ResultColumn.ColumnType.AGGREGATION) {
                aggregationFlag = true;
            }
            if (rawFlag && aggregationFlag) {
                throw new SemanticException("Raw data and aggregation result hybrid calculation is not supported.");
            }
            if (firstType == ResultColumn.ColumnType.CONSTANT && secondType == ResultColumn.ColumnType.CONSTANT && thirdType == ResultColumn.ColumnType.CONSTANT) {
                throw new SemanticException("Constant column is not supported.");
            }
            if (firstType != ResultColumn.ColumnType.CONSTANT) {
                return firstType;
            }
            if (secondType != ResultColumn.ColumnType.CONSTANT) {
                return secondType;
            }
            return thirdType;
        }
        if (expression instanceof BinaryExpression) {
            ResultColumn.ColumnType leftType = ExpressionAnalyzer.identifyOutputColumnType(((BinaryExpression)expression).getLeftExpression(), false);
            ResultColumn.ColumnType rightType = ExpressionAnalyzer.identifyOutputColumnType(((BinaryExpression)expression).getRightExpression(), false);
            if (leftType == ResultColumn.ColumnType.RAW && rightType == ResultColumn.ColumnType.AGGREGATION || leftType == ResultColumn.ColumnType.AGGREGATION && rightType == ResultColumn.ColumnType.RAW) {
                throw new SemanticException("Raw data and aggregation result hybrid calculation is not supported.");
            }
            if (isRoot && leftType == ResultColumn.ColumnType.CONSTANT && rightType == ResultColumn.ColumnType.CONSTANT) {
                throw new SemanticException("Constant column is not supported.");
            }
            if (leftType != ResultColumn.ColumnType.CONSTANT) {
                return leftType;
            }
            return rightType;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.identifyOutputColumnType(((UnaryExpression)expression).getExpression(), false);
        }
        if (expression instanceof FunctionExpression) {
            ResultColumn.ColumnType columnType;
            int i;
            List<Expression> inputExpressions = expression.getExpressions();
            if (expression.isBuiltInAggregationFunctionExpression()) {
                for (Expression inputExpression : inputExpressions) {
                    if (ExpressionAnalyzer.identifyOutputColumnType(inputExpression, false) != ResultColumn.ColumnType.AGGREGATION) continue;
                    throw new SemanticException("Aggregation results cannot be as input of the aggregation function.");
                }
                return ResultColumn.ColumnType.AGGREGATION;
            }
            ResultColumn.ColumnType checkedType = null;
            int lastCheckedIndex = 0;
            for (i = 0; i < inputExpressions.size(); ++i) {
                columnType = ExpressionAnalyzer.identifyOutputColumnType(inputExpressions.get(i), false);
                if (columnType == ResultColumn.ColumnType.CONSTANT) continue;
                checkedType = columnType;
                lastCheckedIndex = i;
                break;
            }
            if (checkedType == null) {
                throw new SemanticException(String.format("Input of '%s' is illegal.", ((FunctionExpression)expression).getFunctionName()));
            }
            for (i = lastCheckedIndex; i < inputExpressions.size(); ++i) {
                columnType = ExpressionAnalyzer.identifyOutputColumnType(inputExpressions.get(i), false);
                if (columnType == ResultColumn.ColumnType.CONSTANT || columnType == checkedType) continue;
                throw new SemanticException(String.format("Raw data and aggregation result hybrid input of '%s' is not supported.", ((FunctionExpression)expression).getFunctionName()));
            }
            return checkedType;
        }
        if (expression instanceof TimeSeriesOperand || expression instanceof TimestampOperand) {
            return ResultColumn.ColumnType.RAW;
        }
        if (expression instanceof ConstantOperand) {
            return ResultColumn.ColumnType.CONSTANT;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> concatExpressionWithSuffixPaths(Expression expression, List<PartialPath> prefixPaths, PathPatternTree patternTree) {
        if (expression instanceof TernaryExpression) {
            List<Expression> firstExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getFirstExpression(), prefixPaths, patternTree);
            List<Expression> secondExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getSecondExpression(), prefixPaths, patternTree);
            List<Expression> thirdExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getThirdExpression(), prefixPaths, patternTree);
            return ExpressionUtils.reconstructTernaryExpressions(expression, firstExpressions, secondExpressions, thirdExpressions);
        }
        if (expression instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getLeftExpression(), prefixPaths, patternTree);
            List<Expression> rightExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getRightExpression(), prefixPaths, patternTree);
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (expression instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((UnaryExpression)expression).getExpression(), prefixPaths, patternTree);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, childExpressions);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList extendedExpressions = new ArrayList();
            for (Expression suffixExpression : expression.getExpressions()) {
                extendedExpressions.add(ExpressionAnalyzer.concatExpressionWithSuffixPaths(suffixExpression, prefixPaths, patternTree));
                if (!expression.isBuiltInAggregationFunctionExpression()) continue;
                List<Expression> children = expression.getExpressions();
                for (int i = 1; i < children.size(); ++i) {
                    extendedExpressions.add(Collections.singletonList(children.get(i)));
                }
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)expression, childExpressionsList);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            ArrayList<PartialPath> actualPaths = new ArrayList<PartialPath>();
            if (rawPath.getFullPath().startsWith("root.")) {
                actualPaths.add(rawPath);
                patternTree.appendPathPattern(rawPath);
            } else {
                for (PartialPath prefixPath : prefixPaths) {
                    PartialPath concatPath = prefixPath.concatPath(rawPath);
                    patternTree.appendPathPattern(concatPath);
                    actualPaths.add(concatPath);
                }
            }
            return ExpressionUtils.reconstructTimeSeriesOperands(actualPaths);
        }
        if (expression instanceof TimestampOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof ConstantOperand) {
            return Collections.singletonList(expression);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<PartialPath> concatExpressionWithSuffixPaths(Expression expression, List<PartialPath> prefixPaths) {
        HashSet<PartialPath> resultPaths = new HashSet<PartialPath>();
        if (expression instanceof TernaryExpression) {
            List<PartialPath> firstExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getFirstExpression(), prefixPaths);
            List<PartialPath> secondExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getSecondExpression(), prefixPaths);
            List<PartialPath> thirdExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((TernaryExpression)expression).getThirdExpression(), prefixPaths);
            resultPaths.addAll(firstExpressions);
            resultPaths.addAll(secondExpressions);
            resultPaths.addAll(thirdExpressions);
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof BinaryExpression) {
            List<PartialPath> leftExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getLeftExpression(), prefixPaths);
            List<PartialPath> rightExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getRightExpression(), prefixPaths);
            resultPaths.addAll(leftExpressions);
            resultPaths.addAll(rightExpressions);
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof UnaryExpression) {
            List<PartialPath> childExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((UnaryExpression)expression).getExpression(), prefixPaths);
            resultPaths.addAll(childExpressions);
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof FunctionExpression) {
            for (Expression suffixExpression : expression.getExpressions()) {
                resultPaths.addAll(ExpressionAnalyzer.concatExpressionWithSuffixPaths(suffixExpression, prefixPaths));
            }
            return new ArrayList<PartialPath>(resultPaths);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            ArrayList<PartialPath> actualPaths = new ArrayList<PartialPath>();
            if (rawPath.getFullPath().startsWith("root.")) {
                actualPaths.add(rawPath);
            } else {
                for (PartialPath prefixPath : prefixPaths) {
                    PartialPath concatPath = prefixPath.concatPath(rawPath);
                    actualPaths.add(concatPath);
                }
            }
            return actualPaths;
        }
        if (expression instanceof TimestampOperand || expression instanceof ConstantOperand) {
            return new ArrayList<PartialPath>();
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static void constructPatternTreeFromExpression(Expression predicate, List<PartialPath> prefixPaths, PathPatternTree patternTree) {
        if (predicate instanceof TernaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((TernaryExpression)predicate).getFirstExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((TernaryExpression)predicate).getSecondExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((TernaryExpression)predicate).getThirdExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof BinaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((BinaryExpression)predicate).getLeftExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((BinaryExpression)predicate).getRightExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof UnaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((UnaryExpression)predicate).getExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof FunctionExpression) {
            for (Expression suffixExpression : predicate.getExpressions()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(suffixExpression, prefixPaths, patternTree);
            }
        } else if (predicate instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)predicate).getPath();
            if (rawPath.getFullPath().startsWith("root.")) {
                patternTree.appendPathPattern(rawPath);
                return;
            }
            for (PartialPath prefixPath : prefixPaths) {
                PartialPath concatPath = prefixPath.concatPath(rawPath);
                patternTree.appendPathPattern(concatPath);
            }
        } else if (!(predicate instanceof TimestampOperand) && !(predicate instanceof ConstantOperand)) {
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
        }
    }

    public static List<Expression> removeWildcardInExpression(Expression expression, ISchemaTree schemaTree) {
        if (expression instanceof TernaryExpression) {
            List<Expression> firstExpressions = ExpressionAnalyzer.removeWildcardInExpression(((TernaryExpression)expression).getFirstExpression(), schemaTree);
            List<Expression> secondExpressions = ExpressionAnalyzer.removeWildcardInExpression(((TernaryExpression)expression).getSecondExpression(), schemaTree);
            List<Expression> thirdExpressions = ExpressionAnalyzer.removeWildcardInExpression(((TernaryExpression)expression).getThirdExpression(), schemaTree);
            return ExpressionUtils.reconstructTernaryExpressions(expression, firstExpressions, secondExpressions, thirdExpressions);
        }
        if (expression instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.removeWildcardInExpression(((BinaryExpression)expression).getLeftExpression(), schemaTree);
            List<Expression> rightExpressions = ExpressionAnalyzer.removeWildcardInExpression(((BinaryExpression)expression).getRightExpression(), schemaTree);
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (expression instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.removeWildcardInExpression(((UnaryExpression)expression).getExpression(), schemaTree);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, childExpressions);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
            for (Expression originExpression : expression.getExpressions()) {
                List<Expression> actualExpressions = ExpressionAnalyzer.removeWildcardInExpression(originExpression, schemaTree);
                if (actualExpressions.isEmpty()) {
                    return Collections.emptyList();
                }
                extendedExpressions.add(actualExpressions);
                if (!expression.isBuiltInAggregationFunctionExpression()) continue;
                List<Expression> children = expression.getExpressions();
                TypeInferenceUtils.bindTypeForAggregationNonSeriesInputExpressions(((FunctionExpression)expression).getFunctionName(), children, extendedExpressions);
                break;
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)expression, childExpressionsList);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath path = ((TimeSeriesOperand)expression).getPath();
            List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)path).left;
            return ExpressionUtils.reconstructTimeSeriesOperands(actualPaths);
        }
        if (expression instanceof TimestampOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof ConstantOperand) {
            return Collections.singletonList(expression);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> removeWildcardInFilter(Expression predicate, List<PartialPath> prefixPaths, ISchemaTree schemaTree, boolean isRoot) {
        if (predicate instanceof TernaryExpression) {
            List<Expression> firstExpressions = ExpressionAnalyzer.removeWildcardInFilter(((TernaryExpression)predicate).getFirstExpression(), prefixPaths, schemaTree, false);
            List<Expression> secondExpressions = ExpressionAnalyzer.removeWildcardInFilter(((TernaryExpression)predicate).getSecondExpression(), prefixPaths, schemaTree, false);
            List<Expression> thirdExpressions = ExpressionAnalyzer.removeWildcardInFilter(((TernaryExpression)predicate).getThirdExpression(), prefixPaths, schemaTree, false);
            return ExpressionUtils.reconstructTernaryExpressions(predicate, firstExpressions, secondExpressions, thirdExpressions);
        }
        if (predicate instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.removeWildcardInFilter(((BinaryExpression)predicate).getLeftExpression(), prefixPaths, schemaTree, false);
            List<Expression> rightExpressions = ExpressionAnalyzer.removeWildcardInFilter(((BinaryExpression)predicate).getRightExpression(), prefixPaths, schemaTree, false);
            if (isRoot && predicate.getExpressionType() == ExpressionType.LOGIC_AND) {
                ArrayList<Expression> resultExpressions = new ArrayList<Expression>(leftExpressions);
                resultExpressions.addAll(rightExpressions);
                return resultExpressions;
            }
            return ExpressionUtils.reconstructBinaryExpressions(predicate.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (predicate instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.removeWildcardInFilter(((UnaryExpression)predicate).getExpression(), prefixPaths, schemaTree, false);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)predicate, childExpressions);
        }
        if (predicate instanceof FunctionExpression) {
            ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
            for (Expression suffixExpression : predicate.getExpressions()) {
                extendedExpressions.add(ExpressionAnalyzer.removeWildcardInFilter(suffixExpression, prefixPaths, schemaTree, false));
                if (!predicate.isBuiltInAggregationFunctionExpression()) continue;
                List<Expression> children = predicate.getExpressions();
                TypeInferenceUtils.bindTypeForAggregationNonSeriesInputExpressions(((FunctionExpression)predicate).getFunctionName(), children, extendedExpressions);
                break;
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)predicate, childExpressionsList);
        }
        if (predicate instanceof TimeSeriesOperand) {
            PartialPath filterPath = ((TimeSeriesOperand)predicate).getPath();
            ArrayList<PartialPath> concatPaths = new ArrayList<PartialPath>();
            if (!filterPath.getFirstNode().equals("root")) {
                prefixPaths.forEach(prefix -> concatPaths.add(prefix.concatPath(filterPath)));
            } else {
                concatPaths.add(filterPath);
            }
            ArrayList noStarPaths = new ArrayList();
            for (PartialPath concatPath : concatPaths) {
                List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)concatPath).left;
                if (actualPaths.isEmpty()) {
                    return Collections.singletonList(new NullOperand());
                }
                noStarPaths.addAll(actualPaths);
            }
            return ExpressionUtils.reconstructTimeSeriesOperands(noStarPaths);
        }
        if (predicate instanceof LeafOperand) {
            return Collections.singletonList(predicate);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static Expression replaceRawPathWithGroupedPath(Expression expression, GroupByLevelController.RawPathToGroupedPathMap rawPathToGroupedPathMap) {
        if (expression instanceof TernaryExpression) {
            Expression firstExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(((TernaryExpression)expression).getFirstExpression(), rawPathToGroupedPathMap);
            Expression secondExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(((TernaryExpression)expression).getSecondExpression(), rawPathToGroupedPathMap);
            Expression thirdExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(((TernaryExpression)expression).getThirdExpression(), rawPathToGroupedPathMap);
            return ExpressionUtils.reconstructTernaryExpression(expression, firstExpression, secondExpression, thirdExpression);
        }
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(((BinaryExpression)expression).getLeftExpression(), rawPathToGroupedPathMap);
            Expression rightExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(((BinaryExpression)expression).getRightExpression(), rawPathToGroupedPathMap);
            return ExpressionUtils.reconstructBinaryExpression(expression.getExpressionType(), leftExpression, rightExpression);
        }
        if (expression instanceof UnaryExpression) {
            Expression childExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(((UnaryExpression)expression).getExpression(), rawPathToGroupedPathMap);
            return ExpressionUtils.reconstructUnaryExpression((UnaryExpression)expression, childExpression);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList<Expression> childrenExpressions = new ArrayList<Expression>();
            for (Expression childExpression : expression.getExpressions()) {
                childrenExpressions.add(ExpressionAnalyzer.replaceRawPathWithGroupedPath(childExpression, rawPathToGroupedPathMap));
                if (!expression.isBuiltInAggregationFunctionExpression()) continue;
                List<Expression> children = expression.getExpressions();
                for (int i = 1; i < children.size(); ++i) {
                    childrenExpressions.add(children.get(i));
                }
            }
            return ExpressionUtils.reconstructFunctionExpression((FunctionExpression)expression, childrenExpressions);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            PartialPath groupedPath = rawPathToGroupedPathMap.get(rawPath);
            return ExpressionUtils.reconstructTimeSeriesOperand(groupedPath);
        }
        if (expression instanceof TimestampOperand || expression instanceof ConstantOperand) {
            return expression;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> concatDeviceAndRemoveWildcard(Expression expression, PartialPath devicePath, ISchemaTree schemaTree) {
        if (expression instanceof TernaryExpression) {
            List<Expression> firstExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((TernaryExpression)expression).getFirstExpression(), devicePath, schemaTree);
            List<Expression> secondExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((TernaryExpression)expression).getSecondExpression(), devicePath, schemaTree);
            List<Expression> thirdExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((TernaryExpression)expression).getThirdExpression(), devicePath, schemaTree);
            return ExpressionUtils.reconstructTernaryExpressions(expression, firstExpressions, secondExpressions, thirdExpressions);
        }
        if (expression instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((BinaryExpression)expression).getLeftExpression(), devicePath, schemaTree);
            List<Expression> rightExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((BinaryExpression)expression).getRightExpression(), devicePath, schemaTree);
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (expression instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((UnaryExpression)expression).getExpression(), devicePath, schemaTree);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, childExpressions);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList<List<Expression>> extendedExpressions = new ArrayList<List<Expression>>();
            for (Expression suffixExpression : expression.getExpressions()) {
                List<Expression> concatedExpression = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(suffixExpression, devicePath, schemaTree);
                if (concatedExpression != null && !concatedExpression.isEmpty()) {
                    extendedExpressions.add(concatedExpression);
                }
                if (!expression.isBuiltInAggregationFunctionExpression()) continue;
                List<Expression> children = expression.getExpressions();
                TypeInferenceUtils.bindTypeForAggregationNonSeriesInputExpressions(((FunctionExpression)expression).getFunctionName(), children, extendedExpressions);
                break;
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)expression, childExpressionsList);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath measurement = ((TimeSeriesOperand)expression).getPath();
            PartialPath concatPath = devicePath.concatPath(measurement);
            List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)concatPath).left;
            if (actualPaths.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList noStarPaths = new ArrayList(actualPaths);
            return ExpressionUtils.reconstructTimeSeriesOperands(noStarPaths);
        }
        if (expression instanceof TimestampOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof ConstantOperand) {
            return Collections.singletonList(expression);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> removeWildcardInFilterByDevice(Expression predicate, PartialPath devicePath, ISchemaTree schemaTree, boolean isWhere) {
        if (predicate instanceof TernaryExpression) {
            List<Expression> firstExpressions = ExpressionAnalyzer.removeWildcardInFilterByDevice(((TernaryExpression)predicate).getFirstExpression(), devicePath, schemaTree, isWhere);
            List<Expression> secondExpressions = ExpressionAnalyzer.removeWildcardInFilterByDevice(((TernaryExpression)predicate).getSecondExpression(), devicePath, schemaTree, isWhere);
            List<Expression> thirdExpressions = ExpressionAnalyzer.removeWildcardInFilterByDevice(((TernaryExpression)predicate).getThirdExpression(), devicePath, schemaTree, isWhere);
            return ExpressionUtils.reconstructTernaryExpressions(predicate, firstExpressions, secondExpressions, thirdExpressions);
        }
        if (predicate instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.removeWildcardInFilterByDevice(((BinaryExpression)predicate).getLeftExpression(), devicePath, schemaTree, isWhere);
            List<Expression> rightExpressions = ExpressionAnalyzer.removeWildcardInFilterByDevice(((BinaryExpression)predicate).getRightExpression(), devicePath, schemaTree, isWhere);
            if (predicate.getExpressionType() == ExpressionType.LOGIC_AND) {
                ArrayList<Expression> resultExpressions = new ArrayList<Expression>(leftExpressions);
                resultExpressions.addAll(rightExpressions);
                return resultExpressions;
            }
            return ExpressionUtils.reconstructBinaryExpressions(predicate.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (predicate instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.removeWildcardInFilterByDevice(((UnaryExpression)predicate).getExpression(), devicePath, schemaTree, isWhere);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)predicate, childExpressions);
        }
        if (predicate instanceof FunctionExpression) {
            if (predicate.isBuiltInAggregationFunctionExpression() && isWhere) {
                throw new SemanticException("aggregate functions are not supported in WHERE clause");
            }
            ArrayList extendedExpressions = new ArrayList();
            for (Expression suffixExpression : predicate.getExpressions()) {
                extendedExpressions.add(ExpressionAnalyzer.removeWildcardInFilterByDevice(suffixExpression, devicePath, schemaTree, isWhere));
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)predicate, childExpressionsList);
        }
        if (predicate instanceof TimeSeriesOperand) {
            PartialPath measurement = ((TimeSeriesOperand)predicate).getPath();
            PartialPath concatPath = devicePath.concatPath(measurement);
            List noStarPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)concatPath).left;
            if (noStarPaths.isEmpty()) {
                return Collections.singletonList(new NullOperand());
            }
            return ExpressionUtils.reconstructTimeSeriesOperands(noStarPaths);
        }
        if (predicate instanceof TimestampOperand) {
            return Collections.singletonList(predicate);
        }
        if (predicate instanceof ConstantOperand) {
            return Collections.singletonList(predicate);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static Pair<Filter, Boolean> extractGlobalTimeFilter(Expression predicate, boolean canRewrite, boolean isFirstOr) {
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_AND)) {
            Pair<Filter, Boolean> leftResultPair = ExpressionAnalyzer.extractGlobalTimeFilter(((BinaryExpression)predicate).getLeftExpression(), canRewrite, isFirstOr);
            Pair<Filter, Boolean> rightResultPair = ExpressionAnalyzer.extractGlobalTimeFilter(((BinaryExpression)predicate).getRightExpression(), canRewrite, isFirstOr);
            if (canRewrite) {
                if (leftResultPair.left != null && !((Boolean)leftResultPair.right).booleanValue()) {
                    ((BinaryExpression)predicate).setLeftExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                }
                if (rightResultPair.left != null && !((Boolean)rightResultPair.right).booleanValue()) {
                    ((BinaryExpression)predicate).setRightExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                }
            }
            if (leftResultPair.left != null && rightResultPair.left != null) {
                return new Pair((Object)FilterFactory.and((Filter)((Filter)leftResultPair.left), (Filter)((Filter)rightResultPair.left)), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            if (leftResultPair.left != null) {
                return new Pair((Object)((Filter)leftResultPair.left), (Object)true);
            }
            if (rightResultPair.left != null) {
                return new Pair((Object)((Filter)rightResultPair.left), (Object)true);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_OR)) {
            Pair<Filter, Boolean> leftResultPair = ExpressionAnalyzer.extractGlobalTimeFilter(((BinaryExpression)predicate).getLeftExpression(), false, false);
            Pair<Filter, Boolean> rightResultPair = ExpressionAnalyzer.extractGlobalTimeFilter(((BinaryExpression)predicate).getRightExpression(), false, false);
            if (leftResultPair.left != null && rightResultPair.left != null) {
                if (isFirstOr && !((Boolean)leftResultPair.right).booleanValue() && !((Boolean)rightResultPair.right).booleanValue()) {
                    ((BinaryExpression)predicate).setLeftExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                    ((BinaryExpression)predicate).setRightExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                }
                return new Pair((Object)FilterFactory.or((Filter)((Filter)leftResultPair.left), (Filter)((Filter)rightResultPair.left)), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_NOT)) {
            Pair<Filter, Boolean> childResultPair = ExpressionAnalyzer.extractGlobalTimeFilter(((UnaryExpression)predicate).getExpression(), canRewrite, isFirstOr);
            if (childResultPair.left != null) {
                return new Pair((Object)FilterFactory.not((Filter)((Filter)childResultPair.left)), (Object)((Boolean)childResultPair.right));
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.isCompareBinaryExpression()) {
            Filter timeInLeftFilter = ExpressionUtils.constructTimeFilter(predicate.getExpressionType(), ((BinaryExpression)predicate).getLeftExpression(), ((BinaryExpression)predicate).getRightExpression());
            if (timeInLeftFilter != null) {
                return new Pair((Object)timeInLeftFilter, (Object)false);
            }
            Filter timeInRightFilter = ExpressionUtils.constructTimeFilter(predicate.getExpressionType(), ((BinaryExpression)predicate).getRightExpression(), ((BinaryExpression)predicate).getLeftExpression());
            if (timeInRightFilter != null) {
                return new Pair((Object)timeInRightFilter, (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LIKE) || predicate.getExpressionType().equals((Object)ExpressionType.REGEXP)) {
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.BETWEEN)) {
            Expression firstExpression = ((TernaryExpression)predicate).getFirstExpression();
            Expression secondExpression = ((TernaryExpression)predicate).getSecondExpression();
            Expression thirdExpression = ((TernaryExpression)predicate).getThirdExpression();
            if (firstExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                return ExpressionUtils.getPairFromBetweenTimeFirst(secondExpression, thirdExpression, ((BetweenExpression)predicate).isNotBetween());
            }
            if (secondExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                if (ExpressionUtils.checkConstantSatisfy(firstExpression, thirdExpression)) {
                    return ExpressionUtils.getPairFromBetweenTimeSecond((BetweenExpression)predicate, firstExpression);
                }
                return new Pair(null, (Object)true);
            }
            if (thirdExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                if (ExpressionUtils.checkConstantSatisfy(secondExpression, firstExpression)) {
                    return ExpressionUtils.getPairFromBetweenTimeThird((BetweenExpression)predicate, firstExpression);
                }
                return new Pair(null, (Object)true);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.IS_NULL)) {
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.IN)) {
            Expression timeExpression = ((InExpression)predicate).getExpression();
            if (timeExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                return new Pair((Object)TimeFilter.in(((InExpression)predicate).getValues().stream().map(Long::parseLong).collect(Collectors.toSet()), (boolean)((InExpression)predicate).isNotIn()), (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.TIMESERIES)) {
            return new Pair(null, (Object)true);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static boolean checkIfTimeFilterExist(Expression predicate) {
        if (predicate instanceof TernaryExpression) {
            return ExpressionAnalyzer.checkIfTimeFilterExist(((TernaryExpression)predicate).getFirstExpression()) || ExpressionAnalyzer.checkIfTimeFilterExist(((TernaryExpression)predicate).getSecondExpression()) || ExpressionAnalyzer.checkIfTimeFilterExist(((TernaryExpression)predicate).getThirdExpression());
        }
        if (predicate instanceof BinaryExpression) {
            return ExpressionAnalyzer.checkIfTimeFilterExist(((BinaryExpression)predicate).getLeftExpression()) || ExpressionAnalyzer.checkIfTimeFilterExist(((BinaryExpression)predicate).getRightExpression());
        }
        if (predicate instanceof UnaryExpression) {
            return ExpressionAnalyzer.checkIfTimeFilterExist(((UnaryExpression)predicate).getExpression());
        }
        if (predicate instanceof FunctionExpression) {
            boolean timeFilterExist = false;
            for (Expression childExpression : predicate.getExpressions()) {
                timeFilterExist = timeFilterExist || ExpressionAnalyzer.checkIfTimeFilterExist(childExpression);
            }
            return timeFilterExist;
        }
        if (predicate instanceof TimeSeriesOperand || predicate instanceof ConstantOperand) {
            return false;
        }
        if (predicate instanceof TimestampOperand) {
            return true;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static List<Expression> searchSourceExpressions(Expression expression) {
        if (expression instanceof TernaryExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((TernaryExpression)expression).getFirstExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((TernaryExpression)expression).getSecondExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((TernaryExpression)expression).getThirdExpression()));
            return resultExpressions;
        }
        if (expression instanceof BinaryExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((BinaryExpression)expression).getLeftExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((BinaryExpression)expression).getRightExpression()));
            return resultExpressions;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.searchSourceExpressions(((UnaryExpression)expression).getExpression());
        }
        if (expression instanceof FunctionExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (Expression childExpression : expression.getExpressions()) {
                resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(childExpression));
            }
            return resultExpressions;
        }
        if (expression instanceof TimeSeriesOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof LeafOperand) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> searchAggregationExpressions(Expression expression) {
        if (expression instanceof TernaryExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((TernaryExpression)expression).getFirstExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((TernaryExpression)expression).getSecondExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((TernaryExpression)expression).getThirdExpression()));
            return resultExpressions;
        }
        if (expression instanceof BinaryExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((BinaryExpression)expression).getLeftExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((BinaryExpression)expression).getRightExpression()));
            return resultExpressions;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.searchAggregationExpressions(((UnaryExpression)expression).getExpression());
        }
        if (expression instanceof FunctionExpression) {
            if (expression.isBuiltInAggregationFunctionExpression()) {
                return Collections.singletonList(expression);
            }
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (Expression inputExpression : expression.getExpressions()) {
                resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(inputExpression));
            }
            return resultExpressions;
        }
        if (expression instanceof LeafOperand) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static Expression removeAliasFromExpression(Expression expression) {
        if (expression instanceof TernaryExpression) {
            Expression firstExpression = ExpressionAnalyzer.removeAliasFromExpression(((TernaryExpression)expression).getFirstExpression());
            Expression secondExpression = ExpressionAnalyzer.removeAliasFromExpression(((TernaryExpression)expression).getSecondExpression());
            Expression thirdExpression = ExpressionAnalyzer.removeAliasFromExpression(((TernaryExpression)expression).getThirdExpression());
            return ExpressionUtils.reconstructTernaryExpressions(expression, Collections.singletonList(firstExpression), Collections.singletonList(secondExpression), Collections.singletonList(thirdExpression)).get(0);
        }
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ExpressionAnalyzer.removeAliasFromExpression(((BinaryExpression)expression).getLeftExpression());
            Expression rightExpression = ExpressionAnalyzer.removeAliasFromExpression(((BinaryExpression)expression).getRightExpression());
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), Collections.singletonList(leftExpression), Collections.singletonList(rightExpression)).get(0);
        }
        if (expression instanceof UnaryExpression) {
            Expression childExpression = ExpressionAnalyzer.removeAliasFromExpression(((UnaryExpression)expression).getExpression());
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, Collections.singletonList(childExpression)).get(0);
        }
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            ArrayList<Expression> childExpressions = new ArrayList<Expression>();
            for (Expression suffixExpression : expression.getExpressions()) {
                childExpressions.add(ExpressionAnalyzer.removeAliasFromExpression(suffixExpression));
            }
            return new FunctionExpression(functionExpression.getFunctionName().toLowerCase(), functionExpression.getFunctionAttributes(), childExpressions);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            if (rawPath.isMeasurementAliasExists()) {
                MeasurementPath measurementPath = (MeasurementPath)rawPath;
                MeasurementPath newPath = new MeasurementPath((PartialPath)measurementPath, measurementPath.getMeasurementSchema());
                newPath.setUnderAlignedEntity(measurementPath.isUnderAlignedEntity());
                return new TimeSeriesOperand((PartialPath)newPath);
            }
            return expression;
        }
        if (expression instanceof LeafOperand) {
            return expression;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static boolean checkIsNeedTransform(Expression expression) {
        if (expression instanceof TernaryExpression) {
            return true;
        }
        if (expression instanceof BinaryExpression) {
            return true;
        }
        if (expression instanceof UnaryExpression) {
            return true;
        }
        if (expression instanceof FunctionExpression) {
            return !expression.isBuiltInAggregationFunctionExpression();
        }
        if (expression instanceof TimeSeriesOperand) {
            return false;
        }
        if (expression instanceof ConstantOperand) {
            return false;
        }
        if (expression instanceof NullOperand) {
            return true;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static String getDeviceNameInSourceExpression(Expression expression) {
        if (!(expression instanceof TimeSeriesOperand)) {
            throw new IllegalArgumentException("unsupported expression type for source expression: " + (Object)((Object)expression.getExpressionType()));
        }
        return ((TimeSeriesOperand)expression).getPath().getDevice();
    }

    public static Expression getMeasurementExpression(Expression expression) {
        if (expression instanceof TernaryExpression) {
            Expression firstExpression = ExpressionAnalyzer.getMeasurementExpression(((TernaryExpression)expression).getFirstExpression());
            Expression secondExpression = ExpressionAnalyzer.getMeasurementExpression(((TernaryExpression)expression).getSecondExpression());
            Expression thirdExpression = ExpressionAnalyzer.getMeasurementExpression(((TernaryExpression)expression).getThirdExpression());
            return ExpressionUtils.reconstructTernaryExpressions(expression, Collections.singletonList(firstExpression), Collections.singletonList(secondExpression), Collections.singletonList(thirdExpression)).get(0);
        }
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ExpressionAnalyzer.getMeasurementExpression(((BinaryExpression)expression).getLeftExpression());
            Expression rightExpression = ExpressionAnalyzer.getMeasurementExpression(((BinaryExpression)expression).getRightExpression());
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), Collections.singletonList(leftExpression), Collections.singletonList(rightExpression)).get(0);
        }
        if (expression instanceof UnaryExpression) {
            Expression childExpression = ExpressionAnalyzer.getMeasurementExpression(((UnaryExpression)expression).getExpression());
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, Collections.singletonList(childExpression)).get(0);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList<Expression> childExpressions = new ArrayList<Expression>();
            for (Expression suffixExpression : expression.getExpressions()) {
                childExpressions.add(ExpressionAnalyzer.getMeasurementExpression(suffixExpression));
            }
            return new FunctionExpression(((FunctionExpression)expression).getFunctionName(), ((FunctionExpression)expression).getFunctionAttributes(), childExpressions);
        }
        if (expression instanceof TimeSeriesOperand) {
            MeasurementPath rawPath = (MeasurementPath)((TimeSeriesOperand)expression).getPath();
            PartialPath measurement = new PartialPath(rawPath.getMeasurement(), false);
            MeasurementPath measurementWithSchema = new MeasurementPath(measurement, rawPath.getMeasurementSchema());
            if (rawPath.isMeasurementAliasExists()) {
                measurementWithSchema.setMeasurementAlias(rawPath.getMeasurementAlias());
            }
            measurementWithSchema.setTagMap(rawPath.getTagMap());
            return new TimeSeriesOperand((PartialPath)measurementWithSchema);
        }
        if (expression instanceof LeafOperand) {
            return expression;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static Expression evaluatePredicate(Expression predicate) {
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_AND)) {
            boolean isRightTrue;
            Expression left = ExpressionAnalyzer.evaluatePredicate(((BinaryExpression)predicate).getLeftExpression());
            Expression right = ExpressionAnalyzer.evaluatePredicate(((BinaryExpression)predicate).getRightExpression());
            boolean isLeftTrue = left.isConstantOperand() && Boolean.parseBoolean(left.getExpressionString());
            boolean bl = isRightTrue = right.isConstantOperand() && Boolean.parseBoolean(right.getExpressionString());
            if (isLeftTrue && isRightTrue) {
                return new ConstantOperand(TSDataType.BOOLEAN, "true");
            }
            if (isLeftTrue) {
                return right;
            }
            if (isRightTrue) {
                return left;
            }
            return predicate;
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_OR)) {
            boolean isRightTrue;
            Expression left = ExpressionAnalyzer.evaluatePredicate(((BinaryExpression)predicate).getLeftExpression());
            Expression right = ExpressionAnalyzer.evaluatePredicate(((BinaryExpression)predicate).getRightExpression());
            boolean isLeftTrue = left.isConstantOperand() && Boolean.parseBoolean(left.getExpressionString());
            boolean bl = isRightTrue = right.isConstantOperand() && Boolean.parseBoolean(right.getExpressionString());
            if (isRightTrue || isLeftTrue) {
                return new ConstantOperand(TSDataType.BOOLEAN, "true");
            }
        }
        return predicate;
    }

    public static Expression bindTypeForTimeSeriesOperand(Expression predicate, List<ColumnHeader> columnHeaders) {
        if (predicate instanceof TernaryExpression) {
            Expression firstExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(((TernaryExpression)predicate).getFirstExpression(), columnHeaders);
            Expression secondExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(((TernaryExpression)predicate).getSecondExpression(), columnHeaders);
            Expression thirdExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(((TernaryExpression)predicate).getThirdExpression(), columnHeaders);
            return ExpressionUtils.reconstructTernaryExpression(predicate, firstExpression, secondExpression, thirdExpression);
        }
        if (predicate instanceof BinaryExpression) {
            Expression leftExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(((BinaryExpression)predicate).getLeftExpression(), columnHeaders);
            Expression rightExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(((BinaryExpression)predicate).getRightExpression(), columnHeaders);
            return ExpressionUtils.reconstructBinaryExpression(predicate.getExpressionType(), leftExpression, rightExpression);
        }
        if (predicate instanceof UnaryExpression) {
            Expression expression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(((UnaryExpression)predicate).getExpression(), columnHeaders);
            return ExpressionUtils.reconstructUnaryExpression((UnaryExpression)predicate, expression);
        }
        if (predicate instanceof FunctionExpression) {
            List<Expression> expressions = predicate.getExpressions();
            ArrayList<Expression> childrenExpressions = new ArrayList<Expression>();
            for (Expression expression : expressions) {
                childrenExpressions.add(ExpressionAnalyzer.bindTypeForTimeSeriesOperand(expression, columnHeaders));
            }
            return ExpressionUtils.reconstructFunctionExpression((FunctionExpression)predicate, childrenExpressions);
        }
        if (predicate instanceof TimeSeriesOperand) {
            String oldPathString = ((TimeSeriesOperand)predicate).getPath().getFullPath();
            for (ColumnHeader columnHeader : columnHeaders) {
                if (!oldPathString.equalsIgnoreCase(columnHeader.getColumnName())) continue;
                try {
                    return ExpressionUtils.reconstructTimeSeriesOperand((PartialPath)new MeasurementPath(columnHeader.getColumnName(), columnHeader.getColumnType()));
                }
                catch (IllegalPathException illegalPathException) {
                }
            }
            throw new SemanticException(String.format("please ensure input[%s] is correct", oldPathString));
        }
        if (predicate instanceof LeafOperand) {
            return predicate;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static boolean isDeviceViewNeedSpecialProcess(Expression expression) {
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)expression;
            return ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(ternaryExpression.getFirstExpression()) || ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(ternaryExpression.getSecondExpression()) || ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(ternaryExpression.getThirdExpression());
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(binaryExpression.getLeftExpression()) || ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(binaryExpression.getRightExpression());
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(((UnaryExpression)expression).getExpression());
        }
        if (expression instanceof FunctionExpression) {
            if (((FunctionExpression)expression).isBuiltInFunction().booleanValue() && BuiltinFunction.DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS.contains(((FunctionExpression)expression).getFunctionName().toLowerCase())) {
                return true;
            }
            for (Expression child : expression.getExpressions()) {
                if (!ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(child)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof LeafOperand) {
            return false;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static boolean checkIsScalarExpression(Expression expression, Analysis analysis) {
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)expression;
            return ExpressionAnalyzer.checkIsScalarExpression(ternaryExpression.getFirstExpression(), analysis) && ExpressionAnalyzer.checkIsScalarExpression(ternaryExpression.getSecondExpression(), analysis) && ExpressionAnalyzer.checkIsScalarExpression(ternaryExpression.getThirdExpression(), analysis);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return ExpressionAnalyzer.checkIsScalarExpression(binaryExpression.getLeftExpression(), analysis) && ExpressionAnalyzer.checkIsScalarExpression(binaryExpression.getRightExpression(), analysis);
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.checkIsScalarExpression(((UnaryExpression)expression).getExpression(), analysis);
        }
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            if (!functionExpression.isMappable(analysis.getExpressionTypes()) || BuiltinFunction.DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS.contains(functionExpression.getFunctionName())) {
                return false;
            }
            List<Expression> inputExpressions = functionExpression.getExpressions();
            for (Expression inputExpression : inputExpressions) {
                if (ExpressionAnalyzer.checkIsScalarExpression(inputExpression, analysis)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof LeafOperand) {
            return true;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }
}

