/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.schema;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.metadata.template.ITemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

class ClusterSchemaFetchExecutor {
    private final Coordinator coordinator;
    private final ITemplateManager templateManager;
    private final Supplier<Long> queryIdProvider;
    private final BiFunction<Long, Statement, ExecutionResult> statementExecutor;
    private final Consumer<ClusterSchemaTree> schemaCacheUpdater;

    ClusterSchemaFetchExecutor(Coordinator coordinator, ITemplateManager templateManager, Supplier<Long> queryIdProvider, BiFunction<Long, Statement, ExecutionResult> statementExecutor, Consumer<ClusterSchemaTree> schemaCacheUpdater) {
        this.coordinator = coordinator;
        this.templateManager = templateManager;
        this.queryIdProvider = queryIdProvider;
        this.statementExecutor = statementExecutor;
        this.schemaCacheUpdater = schemaCacheUpdater;
    }

    ClusterSchemaTree fetchSchemaOfFuzzyMatch(PathPatternTree patternTree, boolean withTags) {
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        List pathPatternList = patternTree.getAllPathPatterns();
        for (PartialPath pattern : pathPatternList) {
            templateMap.putAll(this.templateManager.checkAllRelatedTemplate(pattern));
        }
        return this.executeSchemaFetchQuery(new SchemaFetchStatement(patternTree, templateMap, withTags));
    }

    ClusterSchemaTree fetchSchemaOfPreciseMatch(List<PartialPath> fullPathList, PathPatternTree rawPatternTree) {
        ClusterSchemaTree schemaTree = this.executeSchemaFetchQuery(new SchemaFetchStatement(rawPatternTree, this.analyzeTemplate(fullPathList), false));
        if (!schemaTree.isEmpty()) {
            this.schemaCacheUpdater.accept(schemaTree);
        }
        return schemaTree;
    }

    ClusterSchemaTree fetchSchemaOfOneDevice(PartialPath devicePath, String[] measurements, List<Integer> indexOfTargetMeasurements) {
        PathPatternTree patternTree = new PathPatternTree();
        for (int index : indexOfTargetMeasurements) {
            patternTree.appendFullPath(devicePath, measurements[index]);
        }
        patternTree.constructTree();
        return this.fetchSchemaAndCacheResult(patternTree);
    }

    ClusterSchemaTree fetchSchemaOfMultiDevices(List<PartialPath> devicePathList, List<String[]> measurementsList, List<Integer> indexOfTargetDevices, List<List<Integer>> indexOfTargetMeasurementsList) {
        PathPatternTree patternTree = new PathPatternTree();
        int size = indexOfTargetDevices.size();
        for (int i = 0; i < size; ++i) {
            int deviceIndex = indexOfTargetDevices.get(i);
            for (int measurementIndex : indexOfTargetMeasurementsList.get(i)) {
                patternTree.appendFullPath(devicePathList.get(deviceIndex), measurementsList.get(deviceIndex)[measurementIndex]);
            }
        }
        patternTree.constructTree();
        return this.fetchSchemaAndCacheResult(patternTree);
    }

    private ClusterSchemaTree fetchSchemaAndCacheResult(PathPatternTree patternTree) {
        ClusterSchemaTree schemaTree = this.executeSchemaFetchQuery(new SchemaFetchStatement(patternTree, this.analyzeTemplate(patternTree.getAllPathPatterns()), false));
        if (!schemaTree.isEmpty()) {
            this.schemaCacheUpdater.accept(schemaTree);
        }
        return schemaTree;
    }

    private Map<Integer, Template> analyzeTemplate(List<PartialPath> pathPatternList) {
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (PartialPath pattern : pathPatternList) {
            templateMap.putAll(this.templateManager.checkAllRelatedTemplate(pattern));
        }
        return templateMap;
    }

    private ClusterSchemaTree executeSchemaFetchQuery(SchemaFetchStatement schemaFetchStatement) {
        long queryId = this.queryIdProvider.get();
        try {
            ExecutionResult executionResult = this.statementExecutor.apply(queryId, schemaFetchStatement);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(String.format("cannot fetch schema, status is: %s, msg is: %s", executionResult.status.getCode(), executionResult.status.getMessage()));
            }
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ClusterSchemaTree result = new ClusterSchemaTree();
                HashSet<String> databaseSet = new HashSet<String>();
                while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                    }
                    catch (IoTDBException e) {
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        this.parseFetchedData(column.getBinary(i), result, databaseSet);
                    }
                }
                result.setDatabases(databaseSet);
                ClusterSchemaTree clusterSchemaTree = result;
                threadName.close();
                return clusterSchemaTree;
            }
            catch (Throwable throwable) {
                try {
                    threadName.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.coordinator.cleanupQueryExecution(queryId);
        }
    }

    private void parseFetchedData(Binary data, ClusterSchemaTree resultSchemaTree, Set<String> databaseSet) {
        block5: {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getValues());
            try {
                byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
                if (type == 0) {
                    int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
                    for (int i = 0; i < size; ++i) {
                        databaseSet.add(ReadWriteIOUtils.readString((InputStream)inputStream));
                    }
                    break block5;
                }
                if (type == 1) {
                    resultSchemaTree.mergeSchemaTree(ClusterSchemaTree.deserialize(inputStream));
                    break block5;
                }
                throw new RuntimeException(new MetadataException("Failed to fetch schema because of unrecognized data"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

