/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.ITemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.AutoCreateSchemaExecutor;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ClusterSchemaFetchExecutor;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaAutoCreation;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaComputationWithAutoCreation;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class ClusterSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final DataNodeSchemaCache schemaCache = DataNodeSchemaCache.getInstance();
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    private final AutoCreateSchemaExecutor autoCreateSchemaExecutor = new AutoCreateSchemaExecutor(this.templateManager, statement -> {
        long queryId = SessionManager.getInstance().requestQueryId();
        return this.coordinator.execute((Statement)statement, queryId, null, "", ClusterPartitionFetcher.getInstance(), this, this.config.getQueryTimeoutThreshold());
    });
    private final ClusterSchemaFetchExecutor clusterSchemaFetchExecutor = new ClusterSchemaFetchExecutor(this.coordinator, this.templateManager, () -> SessionManager.getInstance().requestQueryId(), (queryId, statement) -> this.coordinator.execute((Statement)statement, (long)queryId, null, "", ClusterPartitionFetcher.getInstance(), this, this.config.getQueryTimeoutThreshold()), this.schemaCache::put);

    public static ClusterSchemaFetcher getInstance() {
        return ClusterSchemaFetcherHolder.INSTANCE;
    }

    private ClusterSchemaFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterSchemaTree fetchSchema(PathPatternTree patternTree) {
        patternTree.constructTree();
        List pathPatternList = patternTree.getAllPathPatterns();
        ArrayList<PartialPath> fullPathList = new ArrayList<PartialPath>();
        for (PartialPath pattern : pathPatternList) {
            if (pattern.hasWildcard()) continue;
            fullPathList.add(pattern);
        }
        if (fullPathList.size() < pathPatternList.size()) {
            return this.clusterSchemaFetchExecutor.fetchSchemaOfFuzzyMatch(patternTree, false);
        }
        this.schemaCache.takeReadLock();
        try {
            if (fullPathList.size() == pathPatternList.size()) {
                boolean isAllCached = true;
                ClusterSchemaTree schemaTree = new ClusterSchemaTree();
                HashSet<String> storageGroupSet = new HashSet<String>();
                for (PartialPath fullPath : fullPathList) {
                    ClusterSchemaTree cachedSchema = this.schemaCache.get(fullPath);
                    if (cachedSchema.isEmpty()) {
                        isAllCached = false;
                        break;
                    }
                    schemaTree.mergeSchemaTree(cachedSchema);
                    storageGroupSet.addAll(cachedSchema.getDatabases());
                }
                if (isAllCached) {
                    schemaTree.setDatabases(storageGroupSet);
                    ClusterSchemaTree clusterSchemaTree = schemaTree;
                    return clusterSchemaTree;
                }
            }
            ClusterSchemaTree clusterSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfPreciseMatch(fullPathList, patternTree);
            return clusterSchemaTree;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public ClusterSchemaTree fetchSchemaWithTags(PathPatternTree patternTree) {
        patternTree.constructTree();
        return this.clusterSchemaFetchExecutor.fetchSchemaOfFuzzyMatch(patternTree, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndComputeSchemaWithAutoCreate(ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation) {
        this.schemaCache.takeReadLock();
        try {
            PartialPath devicePath = schemaComputationWithAutoCreation.getDevicePath();
            String[] measurements = schemaComputationWithAutoCreation.getMeasurements();
            List<Integer> indexOfMissingMeasurements = this.schemaCache.compute(schemaComputationWithAutoCreation);
            if (indexOfMissingMeasurements.isEmpty()) {
                return;
            }
            ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfOneDevice(devicePath, measurements, indexOfMissingMeasurements);
            if ((indexOfMissingMeasurements = remoteSchemaTree.compute(schemaComputationWithAutoCreation, indexOfMissingMeasurements)).isEmpty()) {
                return;
            }
            if (this.config.isAutoCreateSchemaEnabled()) {
                ClusterSchemaTree schemaTree = new ClusterSchemaTree();
                this.autoCreateSchemaExecutor.autoCreateMissingMeasurements(schemaTree, devicePath, indexOfMissingMeasurements, measurements, schemaComputationWithAutoCreation::getDataType, schemaComputationWithAutoCreation.isAligned());
                indexOfMissingMeasurements = schemaTree.compute(schemaComputationWithAutoCreation, indexOfMissingMeasurements);
                if (indexOfMissingMeasurements.isEmpty()) {
                    return;
                }
            }
            for (int index : indexOfMissingMeasurements) {
                schemaComputationWithAutoCreation.computeMeasurement(index, null);
            }
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndComputeSchemaWithAutoCreate(List<? extends ISchemaComputationWithAutoCreation> schemaComputationWithAutoCreationList) {
        this.schemaCache.takeReadLock();
        try {
            List<Integer> indexOfMissingMeasurements;
            ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation;
            ArrayList<List<Integer>> indexOfMissingMeasurementsList = new ArrayList<List<Integer>>(schemaComputationWithAutoCreationList.size());
            ArrayList<Integer> indexOfDevicesWithMissingMeasurements = new ArrayList<Integer>();
            int size = schemaComputationWithAutoCreationList.size();
            for (int i = 0; i < size; ++i) {
                schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get(i);
                indexOfMissingMeasurements = this.schemaCache.compute(schemaComputationWithAutoCreation);
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesWithMissingMeasurements.add(i);
                indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
            }
            if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                return;
            }
            ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfMultiDevices(schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getDevicePath).collect(Collectors.toList()), schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getMeasurements).collect(Collectors.toList()), indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList);
            ArrayList<Integer> indexOfDevicesNeedAutoCreateSchema = new ArrayList<Integer>();
            ArrayList<List<Integer>> indexOfMeasurementsNeedAutoCreate = new ArrayList<List<Integer>>();
            for (int i = 0; i < indexOfDevicesWithMissingMeasurements.size(); ++i) {
                schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesWithMissingMeasurements.get(i));
                indexOfMissingMeasurements = remoteSchemaTree.compute(schemaComputationWithAutoCreation, (List)indexOfMissingMeasurementsList.get(i));
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesNeedAutoCreateSchema.add((Integer)indexOfDevicesWithMissingMeasurements.get(i));
                indexOfMeasurementsNeedAutoCreate.add(indexOfMissingMeasurements);
            }
            if (indexOfDevicesNeedAutoCreateSchema.isEmpty()) {
                return;
            }
            if (this.config.isAutoCreateSchemaEnabled()) {
                ClusterSchemaTree schemaTree = new ClusterSchemaTree();
                this.autoCreateSchemaExecutor.autoCreateMissingMeasurements(schemaTree, schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getDevicePath).collect(Collectors.toList()), indexOfDevicesNeedAutoCreateSchema, indexOfMeasurementsNeedAutoCreate, schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getMeasurements).collect(Collectors.toList()), schemaComputationWithAutoCreationList.stream().map(o -> {
                    TSDataType[] dataTypes = new TSDataType[o.getMeasurements().length];
                    int length = dataTypes.length;
                    for (int i = 0; i < length; ++i) {
                        dataTypes[i] = o.getDataType(i);
                    }
                    return dataTypes;
                }).collect(Collectors.toList()), null, null, schemaComputationWithAutoCreationList.stream().map(ISchemaAutoCreation::isAligned).collect(Collectors.toList()));
                indexOfDevicesWithMissingMeasurements = new ArrayList();
                indexOfMissingMeasurementsList = new ArrayList();
                for (int i = 0; i < indexOfDevicesNeedAutoCreateSchema.size(); ++i) {
                    schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesNeedAutoCreateSchema.get(i));
                    indexOfMissingMeasurements = schemaTree.compute(schemaComputationWithAutoCreation, (List)indexOfMeasurementsNeedAutoCreate.get(i));
                    if (indexOfMissingMeasurements.isEmpty()) continue;
                    indexOfDevicesWithMissingMeasurements.add((Integer)indexOfDevicesNeedAutoCreateSchema.get(i));
                    indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
                }
                if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                    return;
                }
            } else {
                indexOfDevicesWithMissingMeasurements = indexOfDevicesNeedAutoCreateSchema;
                indexOfMissingMeasurementsList = indexOfMeasurementsNeedAutoCreate;
            }
            for (int i = 0; i < indexOfDevicesWithMissingMeasurements.size(); ++i) {
                schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesWithMissingMeasurements.get(i));
                Iterator iterator = ((List)indexOfMissingMeasurementsList.get(i)).iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    schemaComputationWithAutoCreation.computeMeasurement(index, null);
                }
            }
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList) {
        this.schemaCache.takeReadLock();
        try {
            Object indexOfMissingMeasurements;
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            ArrayList<List<Integer>> indexOfMissingMeasurementsList = new ArrayList<List<Integer>>(devicePathList.size());
            ArrayList<Integer> indexOfDevicesWithMissingMeasurements = new ArrayList<Integer>();
            for (int i = 0; i < devicePathList.size(); ++i) {
                schemaTree.mergeSchemaTree(this.schemaCache.get(devicePathList.get(i), measurementsList.get(i)));
                indexOfMissingMeasurements = this.checkMissingMeasurements(schemaTree, devicePathList.get(i), measurementsList.get(i));
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesWithMissingMeasurements.add(i);
                indexOfMissingMeasurementsList.add((List<Integer>)indexOfMissingMeasurements);
            }
            if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                ClusterSchemaTree i = schemaTree;
                return i;
            }
            ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfMultiDevices(devicePathList, measurementsList, indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList);
            if (!remoteSchemaTree.isEmpty()) {
                schemaTree.mergeSchemaTree(remoteSchemaTree);
            }
            if (!this.config.isAutoCreateSchemaEnabled()) {
                indexOfMissingMeasurements = schemaTree;
                return indexOfMissingMeasurements;
            }
            ArrayList<Integer> indexOfDevicesNeedAutoCreateSchema = new ArrayList<Integer>();
            ArrayList<List<Integer>> indexOfMeasurementsNeedAutoCreate = new ArrayList<List<Integer>>();
            int size = indexOfDevicesWithMissingMeasurements.size();
            for (int i = 0; i < size; ++i) {
                int deviceIndex = (Integer)indexOfDevicesWithMissingMeasurements.get(i);
                List<Integer> indexOfMissingMeasurements2 = (List<Integer>)indexOfMissingMeasurementsList.get(i);
                indexOfMissingMeasurements2 = this.checkMissingMeasurementsAfterSchemaFetch(schemaTree, devicePathList.get(deviceIndex), indexOfMissingMeasurements2, measurementsList.get(deviceIndex));
                if (indexOfMissingMeasurements2.isEmpty()) continue;
                indexOfDevicesNeedAutoCreateSchema.add(deviceIndex);
                indexOfMeasurementsNeedAutoCreate.add(indexOfMissingMeasurements2);
            }
            if (!indexOfDevicesNeedAutoCreateSchema.isEmpty()) {
                this.autoCreateSchemaExecutor.autoCreateMissingMeasurements(schemaTree, devicePathList, indexOfDevicesNeedAutoCreateSchema, indexOfMeasurementsNeedAutoCreate, measurementsList, tsDataTypesList, encodingsList, compressionTypesList, isAlignedList);
            }
            ClusterSchemaTree clusterSchemaTree = schemaTree;
            return clusterSchemaTree;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetInfo(PartialPath path) {
        return this.templateManager.checkTemplateSetInfo(path);
    }

    @Override
    public Map<Integer, Template> checkAllRelatedTemplate(PartialPath pathPattern) {
        return this.templateManager.checkAllRelatedTemplate(pathPattern);
    }

    @Override
    public Pair<Template, List<PartialPath>> getAllPathsSetTemplate(String templateName) {
        return this.templateManager.getAllPathsSetTemplate(templateName);
    }

    private List<Integer> checkMissingMeasurements(ISchemaTree schemaTree, PartialPath devicePath, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, Arrays.asList(measurements));
        if (deviceSchemaInfo == null) {
            return IntStream.range(0, measurements.length).boxed().collect(Collectors.toList());
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        for (int i = 0; i < measurements.length; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(i);
        }
        return indexOfMissingMeasurements;
    }

    private List<Integer> checkMissingMeasurementsAfterSchemaFetch(ClusterSchemaTree schemaTree, PartialPath devicePath, List<Integer> indexOfTargetMeasurements, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, indexOfTargetMeasurements.stream().map(index -> measurements[index]).collect(Collectors.toList()));
        if (deviceSchemaInfo == null) {
            return indexOfTargetMeasurements;
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        int size = schemaList.size();
        for (int i = 0; i < size; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(indexOfTargetMeasurements.get(i));
        }
        return indexOfMissingMeasurements;
    }

    @Override
    public void invalidAllCache() {
        DataNodeSchemaCache.getInstance().invalidateAll();
    }

    private static final class ClusterSchemaFetcherHolder {
        private static final ClusterSchemaFetcher INSTANCE = new ClusterSchemaFetcher();

        private ClusterSchemaFetcherHolder() {
        }
    }
}

