/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.load;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSingleTsFileNode
extends WritePlanNode {
    private static final Logger logger = LoggerFactory.getLogger(LoadSingleTsFileNode.class);
    private File tsFile;
    private TsFileResource resource;
    private boolean needDecodeTsFile;
    private boolean deleteAfterLoad;
    private TRegionReplicaSet localRegionReplicaSet;
    private DataPartition dataPartition;

    public LoadSingleTsFileNode(PlanNodeId id) {
        super(id);
    }

    public LoadSingleTsFileNode(PlanNodeId id, TsFileResource resource, boolean deleteAfterLoad, DataPartition dataPartition) {
        super(id);
        this.tsFile = resource.getTsFile();
        this.resource = resource;
        this.deleteAfterLoad = deleteAfterLoad;
        this.dataPartition = dataPartition;
    }

    public void checkIfNeedDecodeTsFile() throws IOException {
        HashSet<TRegionReplicaSet> allRegionReplicaSet = new HashSet<TRegionReplicaSet>();
        TTimePartitionSlot timePartitionSlot = null;
        this.needDecodeTsFile = false;
        for (String device : this.resource.getDevices()) {
            TTimePartitionSlot startSlot = TimePartitionUtils.getTimePartition(this.resource.getStartTime(device));
            if (timePartitionSlot == null) {
                timePartitionSlot = startSlot;
            }
            if (!startSlot.equals(timePartitionSlot) || !TimePartitionUtils.getTimePartition(this.resource.getEndTime(device)).equals(timePartitionSlot)) {
                this.needDecodeTsFile = true;
                return;
            }
            allRegionReplicaSet.add(this.dataPartition.getDataRegionReplicaSetForWriting(device, timePartitionSlot));
        }
        boolean bl = this.needDecodeTsFile = !this.isDispatchedToLocal(allRegionReplicaSet);
        if (!this.needDecodeTsFile && !this.resource.resourceFileExists()) {
            this.resource.serialize();
        }
    }

    private boolean isDispatchedToLocal(Set<TRegionReplicaSet> replicaSets) {
        if (replicaSets.size() > 1) {
            return false;
        }
        Iterator<TRegionReplicaSet> iterator = replicaSets.iterator();
        if (iterator.hasNext()) {
            TRegionReplicaSet replicaSet = iterator.next();
            List dataNodeLocationList = replicaSet.getDataNodeLocations();
            if (dataNodeLocationList.size() > 1) {
                return false;
            }
            this.localRegionReplicaSet = replicaSet;
            return this.isDispatchedToLocal(((TDataNodeLocation)dataNodeLocationList.get(0)).getInternalEndPoint());
        }
        return true;
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return IoTDBDescriptor.getInstance().getConfig().getInternalAddress().equals(endPoint.getIp()) && IoTDBDescriptor.getInstance().getConfig().getInternalPort() == endPoint.port;
    }

    public boolean needDecodeTsFile() {
        return this.needDecodeTsFile;
    }

    public boolean isDeleteAfterLoad() {
        return this.deleteAfterLoad;
    }

    public TRegionReplicaSet getLocalRegionReplicaSet() {
        return this.localRegionReplicaSet;
    }

    public DataPartition getDataPartition() {
        return this.dataPartition;
    }

    public TsFileResource getTsFileResource() {
        return this.resource;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load single TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        throw new NotImplementedException("split load single TsFile is not implemented");
    }

    public String toString() {
        return "LoadSingleTsFileNode{tsFile=" + this.tsFile + ", needDecodeTsFile=" + this.needDecodeTsFile + '}';
    }

    public void clean() {
        try {
            if (this.deleteAfterLoad) {
                Files.deleteIfExists(this.tsFile.toPath());
                Files.deleteIfExists(new File(this.tsFile.getAbsolutePath() + ".resource").toPath());
                Files.deleteIfExists(new File(this.tsFile.getAbsolutePath() + ".mods").toPath());
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Delete After Loading %s error.", this.tsFile), (Throwable)e);
        }
    }
}

