/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v1.handler;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.protocol.rest.v1.model.InsertTabletRequest;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public class StatementConstructionHandler {
    private StatementConstructionHandler() {
    }

    public static InsertTabletStatement constructInsertTabletStatement(InsertTabletRequest insertTabletRequest) throws IllegalPathException, WriteProcessRejectException {
        InsertTabletStatement insertStatement = new InsertTabletStatement();
        insertStatement.setDevicePath(new PartialPath(insertTabletRequest.getDeviceId()));
        insertStatement.setMeasurements(insertTabletRequest.getMeasurements().toArray(new String[0]));
        List rawData = insertTabletRequest.getValues();
        List rawDataType = insertTabletRequest.getDataTypes();
        int rowSize = insertTabletRequest.getTimestamps().size();
        int columnSize = rawDataType.size();
        Object[] columns = new Object[columnSize];
        BitMap[] bitMaps = new BitMap[columnSize];
        TSDataType[] dataTypes = new TSDataType[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            dataTypes[i] = TSDataType.valueOf((String)((String)rawDataType.get(i)).toUpperCase(Locale.ROOT));
        }
        block9: for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            bitMaps[columnIndex] = new BitMap(rowSize);
            switch (dataTypes[columnIndex]) {
                case BOOLEAN: {
                    boolean[] booleanValues = new boolean[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object data = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (data == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        booleanValues[rowIndex] = "1".equals(data.toString()) ? true : ("0".equals(data.toString()) ? false : (Boolean)data);
                    }
                    columns[columnIndex] = booleanValues;
                    continue block9;
                }
                case INT32: {
                    int[] intValues = new int[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            intValues[rowIndex] = (Integer)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = intValues;
                    continue block9;
                }
                case INT64: {
                    long[] longValues = new long[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            longValues[rowIndex] = ((Integer)object).intValue();
                            continue;
                        }
                        if (object instanceof Long) {
                            longValues[rowIndex] = (Long)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = longValues;
                    continue block9;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object data = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (data == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        floatValues[rowIndex] = Float.valueOf(String.valueOf(data)).floatValue();
                    }
                    columns[columnIndex] = floatValues;
                    continue block9;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        doubleValues[rowIndex] = Double.valueOf(String.valueOf(((List)rawData.get(columnIndex)).get(rowIndex)));
                    }
                    columns[columnIndex] = doubleValues;
                    continue block9;
                }
                case TEXT: {
                    Binary[] binaryValues = new Binary[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            binaryValues[rowIndex] = new Binary("".getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        binaryValues[rowIndex] = new Binary(((List)rawData.get(columnIndex)).get(rowIndex).toString().getBytes(StandardCharsets.UTF_8));
                    }
                    columns[columnIndex] = binaryValues;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Invalid input: " + (String)rawDataType.get(columnIndex));
                }
            }
        }
        insertStatement.setTimes(insertTabletRequest.getTimestamps().stream().mapToLong(Long::longValue).toArray());
        insertStatement.setColumns(columns);
        insertStatement.setBitMaps(bitMaps);
        insertStatement.setRowCount(insertTabletRequest.getTimestamps().size());
        insertStatement.setDataTypes(dataTypes);
        insertStatement.setAligned(insertTabletRequest.getIsAligned());
        return insertStatement;
    }
}

