/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.SeriesCompactionExecutor;
import org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element.FileElement;
import org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.engine.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class AlignedSeriesCompactionExecutor
extends SeriesCompactionExecutor {
    private final Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap;
    private final List<IMeasurementSchema> measurementSchemas;

    public AlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, String deviceId, int subTaskId, List<IMeasurementSchema> measurementSchemas, FastCompactionTaskSummary summary) {
        super(compactionWriter, readerCacheMap, modificationCacheMap, deviceId, true, subTaskId, summary);
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.measurementSchemas = measurementSchemas;
        sortedSourceFiles.forEach(x -> this.fileList.add(new FileElement((TsFileResource)x)));
    }

    @Override
    public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
        this.compactionWriter.startMeasurement(this.measurementSchemas, this.subTaskId);
        this.compactFiles();
        this.compactionWriter.endMeasurement(this.subTaskId);
    }

    @Override
    protected void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException {
        while (!this.fileList.isEmpty()) {
            List<FileElement> overlappedFiles = this.findOverlapFiles((FileElement)this.fileList.get(0));
            this.deserializeFileIntoChunkMetadataQueue(overlappedFiles);
            this.compactChunks();
        }
    }

    @Override
    void deserializeFileIntoChunkMetadataQueue(List<FileElement> fileElements) throws IOException, IllegalPathException {
        for (FileElement fileElement : fileElements) {
            TsFileResource resource = fileElement.resource;
            List timeChunkMetadatas = new ArrayList();
            ArrayList<List> valueChunkMetadatas = new ArrayList<List>();
            for (Map.Entry<String, Map<TsFileResource, Pair<Long, Long>>> entry : this.timeseriesMetadataOffsetMap.entrySet()) {
                String measurementID = entry.getKey();
                Pair<Long, Long> timeseriesOffsetInCurrentFile = entry.getValue().get(resource);
                if (measurementID.equals("")) {
                    if (timeseriesOffsetInCurrentFile == null) {
                        timeChunkMetadatas = null;
                        break;
                    }
                    timeChunkMetadatas = ((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesOffsetInCurrentFile.left).longValue(), ((Long)timeseriesOffsetInCurrentFile.right).longValue());
                    continue;
                }
                if (timeseriesOffsetInCurrentFile == null) {
                    valueChunkMetadatas.add(null);
                    continue;
                }
                valueChunkMetadatas.add(((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesOffsetInCurrentFile.left).longValue(), ((Long)timeseriesOffsetInCurrentFile.right).longValue()));
            }
            ArrayList<AlignedChunkMetadata> alignedChunkMetadataList = new ArrayList<AlignedChunkMetadata>();
            if (timeChunkMetadatas != null) {
                for (int i = 0; i < timeChunkMetadatas.size(); ++i) {
                    ArrayList<IChunkMetadata> valueChunkMetadataList = new ArrayList<IChunkMetadata>();
                    for (List chunkMetadata : valueChunkMetadatas) {
                        if (chunkMetadata == null) {
                            valueChunkMetadataList.add(null);
                            continue;
                        }
                        valueChunkMetadataList.add((IChunkMetadata)chunkMetadata.get(i));
                    }
                    AlignedChunkMetadata alignedChunkMetadata = new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadatas.get(i), valueChunkMetadataList);
                    alignedChunkMetadataList.add(alignedChunkMetadata);
                }
                ArrayList<List<Modification>> valueModifications = new ArrayList<List<Modification>>();
                ((AlignedChunkMetadata)alignedChunkMetadataList.get(0)).getValueChunkMetadataList().forEach(x -> {
                    try {
                        if (x == null) {
                            valueModifications.add(null);
                        } else {
                            valueModifications.add(this.getModificationsFromCache(resource, new PartialPath(this.deviceId, x.getMeasurementUid())));
                        }
                    }
                    catch (IllegalPathException e) {
                        throw new RuntimeException(e);
                    }
                });
                ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, valueModifications);
            }
            if (alignedChunkMetadataList.isEmpty()) {
                this.removeFile(fileElement);
            }
            for (int i = 0; i < alignedChunkMetadataList.size(); ++i) {
                this.chunkMetadataQueue.add(new ChunkMetadataElement((IChunkMetadata)alignedChunkMetadataList.get(i), resource.getVersion(), i == alignedChunkMetadataList.size() - 1, fileElement));
            }
        }
    }

    @Override
    void deserializeChunkIntoPageQueue(ChunkMetadataElement chunkMetadataElement) throws IOException {
        int i;
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.DESERIALIZE_CHUNK);
        ArrayList<PageHeader> timePageHeaders = new ArrayList<PageHeader>();
        ArrayList<ByteBuffer> compressedTimePageDatas = new ArrayList<ByteBuffer>();
        ArrayList valuePageHeaders = new ArrayList();
        ArrayList compressedValuePageDatas = new ArrayList();
        Chunk timeChunk = chunkMetadataElement.chunk;
        ChunkReader chunkReader = new ChunkReader(timeChunk);
        ByteBuffer chunkDataBuffer = timeChunk.getData();
        ChunkHeader chunkHeader = timeChunk.getHeader();
        while (chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)timeChunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
            ByteBuffer compressedPageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
            timePageHeaders.add(pageHeader);
            compressedTimePageDatas.add(compressedPageData);
        }
        List<Chunk> valueChunks = chunkMetadataElement.valueChunks;
        for (i = 0; i < valueChunks.size(); ++i) {
            Chunk valueChunk = valueChunks.get(i);
            if (valueChunk == null) {
                valuePageHeaders.add(null);
                compressedValuePageDatas.add(null);
                continue;
            }
            chunkReader = new ChunkReader(valueChunk);
            chunkDataBuffer = valueChunk.getData();
            chunkHeader = valueChunk.getHeader();
            valuePageHeaders.add(new ArrayList());
            compressedValuePageDatas.add(new ArrayList());
            while (chunkDataBuffer.remaining() > 0) {
                PageHeader pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)valueChunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
                if (pageHeader.getCompressedSize() == 0) {
                    ((List)valuePageHeaders.get(i)).add(null);
                    ((List)compressedValuePageDatas.get(i)).add(null);
                    continue;
                }
                ByteBuffer compressedPageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
                ((List)valuePageHeaders.get(i)).add(pageHeader);
                ((List)compressedValuePageDatas.get(i)).add(compressedPageData);
            }
        }
        for (i = 0; i < timePageHeaders.size(); ++i) {
            ArrayList<PageHeader> alignedPageHeaders = new ArrayList<PageHeader>();
            ArrayList<ByteBuffer> alignedPageDatas = new ArrayList<ByteBuffer>();
            for (int j = 0; j < valuePageHeaders.size(); ++j) {
                if (valuePageHeaders.get(j) == null) {
                    alignedPageHeaders.add(null);
                    alignedPageDatas.add(null);
                    continue;
                }
                alignedPageHeaders.add((PageHeader)((List)valuePageHeaders.get(j)).get(i));
                alignedPageDatas.add((ByteBuffer)((List)compressedValuePageDatas.get(j)).get(i));
            }
            this.pageQueue.add(new PageElement((PageHeader)timePageHeaders.get(i), alignedPageHeaders, (ByteBuffer)compressedTimePageDatas.get(i), alignedPageDatas, new AlignedChunkReader(timeChunk, valueChunks), chunkMetadataElement, i == timePageHeaders.size() - 1, chunkMetadataElement.priority));
        }
        chunkMetadataElement.clearChunks();
    }

    @Override
    void readChunk(ChunkMetadataElement chunkMetadataElement) throws IOException {
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.READ_IN);
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadataElement.chunkMetadata;
        chunkMetadataElement.chunk = ((TsFileSequenceReader)this.readerCacheMap.get(chunkMetadataElement.fileElement.resource)).readMemChunk((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
        ArrayList<Chunk> valueChunks = new ArrayList<Chunk>();
        for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
            if (valueChunkMetadata == null || valueChunkMetadata.getStatistics().getCount() == 0L) {
                valueChunks.add(null);
                continue;
            }
            valueChunks.add(((TsFileSequenceReader)this.readerCacheMap.get(chunkMetadataElement.fileElement.resource)).readMemChunk((ChunkMetadata)valueChunkMetadata));
        }
        chunkMetadataElement.valueChunks = valueChunks;
    }

    @Override
    protected SeriesCompactionExecutor.ModifiedStatus isPageModified(PageElement pageElement) {
        long startTime = pageElement.startTime;
        long endTime = pageElement.pageHeader.getEndTime();
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)pageElement.chunkMetadataElement.chunkMetadata;
        SeriesCompactionExecutor.ModifiedStatus lastPageStatus = null;
        for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
            SeriesCompactionExecutor.ModifiedStatus currentPageStatus;
            SeriesCompactionExecutor.ModifiedStatus modifiedStatus = currentPageStatus = valueChunkMetadata == null ? SeriesCompactionExecutor.ModifiedStatus.ALL_DELETED : this.checkIsModified(startTime, endTime, valueChunkMetadata.getDeleteIntervalList());
            if (currentPageStatus == SeriesCompactionExecutor.ModifiedStatus.PARTIAL_DELETED) {
                return SeriesCompactionExecutor.ModifiedStatus.PARTIAL_DELETED;
            }
            if (lastPageStatus == null) {
                lastPageStatus = currentPageStatus;
                continue;
            }
            if (currentPageStatus.equals((Object)lastPageStatus)) continue;
            lastPageStatus = SeriesCompactionExecutor.ModifiedStatus.NONE_DELETED;
        }
        return lastPageStatus;
    }
}

