/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.store.CachedMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;

public class ReentrantReadOnlyCachedMTreeStore
implements IMTreeStore {
    private final CachedMTreeStore store;
    private final long readLockStamp;

    public ReentrantReadOnlyCachedMTreeStore(CachedMTreeStore store) {
        this.store = store;
        this.readLockStamp = store.stampedReadLock();
    }

    @Override
    public IMNode generatePrefix(PartialPath storageGroupPath) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public IMNode getRoot() {
        return this.store.getRoot();
    }

    @Override
    public boolean hasChild(IMNode parent, String name) throws MetadataException {
        return this.store.hasChild(parent, name, false);
    }

    @Override
    public IMNode getChild(IMNode parent, String name) throws MetadataException {
        return this.store.getChild(parent, name, false);
    }

    @Override
    public IMNodeIterator getChildrenIterator(IMNode parent) throws MetadataException {
        return this.store.getChildrenIterator(parent, false);
    }

    @Override
    public IMNodeIterator getTraverserIterator(IMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        return this.store.getTraverserIterator(this, parent, templateMap, skipPreDeletedSchema);
    }

    @Override
    public IMNode addChild(IMNode parent, String childName, IMNode child) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void deleteChild(IMNode parent, String childName) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void updateMNode(IMNode node) {
        this.store.updateMNode(node, false);
    }

    @Override
    public IEntityMNode setToEntity(IMNode node) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public IMNode setToInternal(IEntityMNode entityMNode) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void pin(IMNode node) throws MetadataException {
        this.store.pin(node, false);
    }

    @Override
    public void unPin(IMNode node) {
        this.store.unPin(node, false);
    }

    @Override
    public void unPinPath(IMNode node) {
        this.store.unPinPath(node, false);
    }

    @Override
    public IMTreeStore getWithReentrantReadLock() {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        throw new UnsupportedOperationException("ReadOnlyReentrantMTreeStore");
    }

    public void unlockRead() {
        this.store.stampedReadUnlock(this.readLockStamp);
    }
}

